/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM627AddDocumentationToAnAPIWithDocTypeOtherThroughPublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIM627PublisherTest";
    private final String apiVersion = "1.0.0";
    private APIPublisherRestClient apiPublisher;
    private String apiProvider;
    private String apiEndPointUrl;

    @Factory(dataProvider="userModeDataProvider")
    public APIM627AddDocumentationToAnAPIWithDocTypeOtherThroughPublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiProductionEndpointPostfixUrl;
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type Other And Source Inline through the publisher rest API ")
    public void testAddDocumentToAnAPIOtherInline() throws Exception {
        String apiContext = "apim627PublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTags = "tag627-1, tag628-2";
        String docName = "APIM627PublisherTestHowTo-Inline-summary";
        String docType = "other";
        String sourceType = "inline";
        String newType = "Type APIM627";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM627PublisherTest", apiContext, "1.0.0", this.apiProvider, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags(apiTags);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setDefaultVersion("default_version");
        apiCreationRequestBean.setDefaultVersionChecked("default_version");
        apiCreationRequestBean.setBizOwner("api620b");
        apiCreationRequestBean.setBizOwnerMail("api620b@ee.com");
        apiCreationRequestBean.setTechOwner("api620t");
        apiCreationRequestBean.setTechOwnerMail("api620t@ww.com");
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        JSONObject apiResponse = new JSONObject(apiCreationResponse.getData());
        Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when creating the API");
        Assert.assertFalse((boolean)apiResponse.getBoolean("error"), (String)"APIM627PublisherTestis not created as expected");
        HttpResponse apiResponsePublisher = this.apiPublisher.getAPI("APIM627PublisherTest", this.apiProvider, "1.0.0");
        JSONObject jsonObject = new JSONObject(apiResponsePublisher.getData());
        JSONObject apiObject = new JSONObject(jsonObject.getString("api"));
        Assert.assertFalse((boolean)jsonObject.getBoolean("error"), (String)"APIM627PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)apiObject.getString("name").equals("APIM627PublisherTest"), (String)"APIM627PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)apiObject.getString("status").equals("CREATED"), (String)"Status of the APIM627PublisherTestis not a valid status");
        HttpResponse docResponse = this.apiPublisher.addDocument("APIM627PublisherTest", "1.0.0", this.apiProvider, docName, docType, sourceType, null, "Testing", null, "", newType);
        JSONObject jsonObjectDoc1 = new JSONObject(docResponse.getData());
        Assert.assertFalse((boolean)jsonObjectDoc1.getBoolean("error"), (String)"Error when adding document to the API");
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type HowTo And Source Url through the publisher rest API ", dependsOnMethods={"testAddDocumentToAnAPIOtherInline"})
    public void testAddDocumentToAnAPIOtherUrl() throws Exception {
        String docName = "APIM628PublisherTestHowTo-Url-summary";
        String docType = "other";
        String sourceType = "URL";
        String docUrl = "https://docs.wso2.com/display/AM191/Published+APIs";
        String newType = "Type APIM628";
        HttpResponse docResponse = this.apiPublisher.addDocument("APIM627PublisherTest", "1.0.0", this.apiProvider, docName, docType, sourceType, docUrl, "Testing", "", "", newType);
        JSONObject jsonObjectDoc1 = new JSONObject(docResponse.getData());
        Assert.assertFalse((boolean)jsonObjectDoc1.getBoolean("error"), (String)"Error when adding document with source Url to the API");
    }

    @Test(groups={"wso2.am"}, description="Remove API Documentation from the API through the publisher rest API ", dependsOnMethods={"testAddDocumentToAnAPIOtherInline"})
    public void testRemoveDocumentationOtherTheAPI() throws Exception {
        String docName = "APIM627PublisherTestHowTo-Inline-summary";
        String docType = "Other";
        String sourceType = "Inline";
        String newType = "Type APIM627";
        HttpResponse docRemoveResponse = this.apiPublisher.removeDocumentation("APIM627PublisherTest", "1.0.0", this.apiProvider, docName, docType);
        JSONObject jsonObjectDocRemove = new JSONObject(docRemoveResponse.getData());
        Assert.assertFalse((boolean)jsonObjectDocRemove.getBoolean("error"), (String)"Error when adding document with source file to the API");
        HttpResponse docResponse = this.apiPublisher.addDocument("APIM627PublisherTest", "1.0.0", this.apiProvider, docName, docType, sourceType, "", "Testing", "", "", newType);
        JSONObject jsonObjectDoc1 = new JSONObject(docResponse.getData());
        Assert.assertFalse((boolean)jsonObjectDoc1.getBoolean("error"), (String)"Error when adding document to the API");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.apiPublisher.deleteAPI("APIM627PublisherTest", "1.0.0", this.apiProvider);
        super.cleanUp();
    }
}

