/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class APIM634GetAllTheThrottlingTiersFromThePublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private APIPublisherRestClient apiPublisher;

    @Factory(dataProvider="userModeDataProvider")
    public APIM634GetAllTheThrottlingTiersFromThePublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
    }

    @Test(groups={"wso2.am"}, description="Get all the throttling tiers from the publisher rest API ")
    public void testGetAllTheThrottlingTiers() throws Exception {
        JSONObject tiersResponse = new JSONObject(this.apiPublisher.getTiers().getData());
        JSONArray tierArrayList = tiersResponse.getJSONArray("tiers");
        JSONObject tierUnlimited = (JSONObject)tierArrayList.get(0);
        Assert.assertEquals((String)tierUnlimited.getString("tierDescription"), (String)"Allows unlimited requests", (String)"Invalid description of the tier Unlimited");
        Assert.assertEquals((String)tierUnlimited.getString("tierDisplayName"), (String)"Unlimited", (String)"Invalid display name of the tier Unlimited");
        Assert.assertEquals((String)tierUnlimited.getString("tierName"), (String)"Unlimited", (String)"Invalid name of the tier Unlimited");
        Assert.assertEquals((String)tierUnlimited.getString("defaultTier"), (String)"true", (String)"Invalid value for the default tier");
        JSONObject tierGold = (JSONObject)tierArrayList.get(1);
        Assert.assertEquals((String)tierGold.getString("tierDescription"), (String)"Allows 5000 requests per minute", (String)"Invalid description of the tier Gold");
        Assert.assertEquals((String)tierGold.getString("tierDisplayName"), (String)"Gold", (String)"Invalid display name of the tier Gold");
        Assert.assertEquals((String)tierGold.getString("tierName"), (String)"Gold", (String)"Invalid name of the tier Gold");
        Assert.assertEquals((String)tierGold.getString("defaultTier"), (String)"false", (String)"Invalid value for the default tier");
        JSONObject tierSilver = (JSONObject)tierArrayList.get(2);
        Assert.assertEquals((String)tierSilver.getString("tierDescription"), (String)"Allows 2000 requests per minute", (String)"Invalid description of the tier Silver");
        Assert.assertEquals((String)tierSilver.getString("tierDisplayName"), (String)"Silver", (String)"Invalid display name of the tier Silver");
        Assert.assertEquals((String)tierSilver.getString("tierName"), (String)"Silver", (String)"Invalid name of the tier Silver");
        Assert.assertEquals((String)tierSilver.getString("defaultTier"), (String)"false", (String)"Invalid value for the default tier");
        JSONObject tierBronze = (JSONObject)tierArrayList.get(3);
        Assert.assertEquals((String)tierBronze.getString("tierDescription"), (String)"Allows 1000 requests per minute", (String)"Invalid description of the tier Bronze");
        Assert.assertEquals((String)tierBronze.getString("tierDisplayName"), (String)"Bronze", (String)"Invalid display name of the tier Bronze");
        Assert.assertEquals((String)tierBronze.getString("tierName"), (String)"Bronze", (String)"Invalid name of the tier Bronze");
        Assert.assertEquals((String)tierBronze.getString("defaultTier"), (String)"false", (String)"Invalid value for the default tier");
    }
}

