/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class APIM638ValidateTheRoleOfAnExistingUserThroughThePublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private final String adminRole = "carbonAdmin";
    private final String creatorRole = "creator";
    private APIPublisherRestClient apiPublisher;
    private String publisherBackEndUrl;

    @Factory(dataProvider="userModeDataProvider")
    public APIM638ValidateTheRoleOfAnExistingUserThroughThePublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String permissionListApiLogin = "/permission/admin/login";
        String permissionListApiManage = "/permission/admin/manage/api";
        String permissionListApiCreate = "/permission/admin/manage/api/create";
        String permissionListApiPublish = "/permission/admin/manage/api/publish";
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.publisherBackEndUrl = this.publisherContext.getContextUrls().getBackEndUrl();
        UserManagementClient userManagementClientAdmin = new UserManagementClient(this.publisherBackEndUrl, this.createSession(this.publisherContext));
        userManagementClientAdmin.addRole("carbonAdmin", new String[0], new String[]{permissionListApiLogin, permissionListApiManage, permissionListApiCreate, permissionListApiPublish});
        userManagementClientAdmin.addRole("creator", new String[0], new String[]{permissionListApiLogin, permissionListApiCreate});
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
    }

    @Test(groups={"wso2.am"}, description="Validate the Role of an existing user through the publisher rest API ")
    public void testValidateTheRoleOfAnExistingUser() throws Exception {
        JSONObject jsonObjectAdmin = new JSONObject(this.apiPublisher.validateRoles("carbonAdmin").getData());
        Assert.assertFalse((boolean)jsonObjectAdmin.getBoolean("error"), (String)"Invalid Role Name - carbonAdmin");
        Assert.assertTrue((boolean)jsonObjectAdmin.getBoolean("response"), (String)"Invalid response for the Role - carbonAdmin");
        JSONObject jsonObjectCreator = new JSONObject(this.apiPublisher.validateRoles("creator").getData());
        Assert.assertFalse((boolean)jsonObjectCreator.getBoolean("error"), (String)"Invalid Role Name - creator");
        Assert.assertTrue((boolean)jsonObjectCreator.getBoolean("response"), (String)"Invalid response for the Role - creator");
    }

    @Test(groups={"wso2.am"}, description="Validate the Role of an non-existing user through the publisher rest API ")
    public void testValidateTheRoleOfAnNonExistingUser() throws Exception {
        String publisherRole = "publisher";
        JSONObject jsonObjectPublisher = new JSONObject(this.apiPublisher.validateRoles(publisherRole).getData());
        Assert.assertFalse((boolean)jsonObjectPublisher.getBoolean("error"), (String)("Invalid Role Name - " + publisherRole));
        Assert.assertFalse((boolean)jsonObjectPublisher.getBoolean("response"), (String)("Invalid response for the Role - " + publisherRole));
    }

    @AfterClass(alwaysRun=true)
    public void clearRoles() throws Exception {
        UserManagementClient userManagementClientAdmin = new UserManagementClient(this.publisherBackEndUrl, this.createSession(this.publisherContext));
        userManagementClientAdmin.deleteRole("carbonAdmin");
        userManagementClientAdmin.deleteRole("creator");
        super.cleanUp();
    }
}

