/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.rest;

import java.net.URL;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

public class SearchPaginatedAPIsWithMultipleStatusTestCase
extends APIMIntegrationBaseTest {
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private ServerConfigurationManager serverConfigurationManager;
    private final int apiCount = 24;
    private static final String PROVIDER = "admin";
    private static final String TENANT_DOMAIN = "carbon.super";
    private static final String API_NAME_PREFIX = "YoutubeFeeds";
    private static final String API_CONTEXT_PREFIX = "youtube";
    private static final String API_VERSION = "1.0.0";
    private static final String API_URL = "http://gdata.youtube.com/feeds/api/standardfeeds";
    private static final int PAGINATED_COUNT = 10;

    @Factory(dataProvider="userModeDataProvider")
    public SearchPaginatedAPIsWithMultipleStatusTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
    }

    @Test(groups={"wso2.am"}, description="check paginated API count")
    public void testPaginationWithMultipleStatus() throws Exception {
        for (int i = 0; i < 24; ++i) {
            APIRequest apiRequest = new APIRequest(API_NAME_PREFIX + i, API_CONTEXT_PREFIX + i, new URL(API_URL));
            this.apiPublisher.addAPI(apiRequest);
            if (i % 2 == 0) {
                APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(API_NAME_PREFIX + i, this.user.getUserName(), APILifeCycleState.PUBLISHED);
                this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
            }
            Thread.sleep(500L);
        }
        Thread.sleep(10000L);
        HttpResponse response = this.apiStore.searchPaginateAPIs(TENANT_DOMAIN, "0", "10", API_NAME_PREFIX);
        JSONObject responseJSON = new JSONObject(response.getData());
        JSONArray returnedAPIs = responseJSON.getJSONArray("result");
        Assert.assertEquals((int)returnedAPIs.length(), (int)10);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        for (int i = 0; i < 24; ++i) {
            this.apiPublisher.deleteAPI(API_NAME_PREFIX + i, API_VERSION, PROVIDER);
        }
        super.cleanUp();
    }
}

