/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.sequence;

import java.io.File;
import java.net.URL;
import javax.activation.DataHandler;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.registry.ResourceAdminServiceClient;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class DefaultEndpointTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "AddDynamicEndpointAndInvokeAPITest";
    private final String API_CONTEXT = "AddDynamicEndpointAndInvokeAPI";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "AddDynamicEndpointAndInvokeAPI";
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private APICreationRequestBean apiCreationRequestBean;
    private APIIdentifier apiIdentifier;
    private String accessToken;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        String providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("AddDynamicEndpointAndInvokeAPITest", "AddDynamicEndpointAndInvokeAPI", "1.0.0", providerName);
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiIdentifier = new APIIdentifier(providerName, "AddDynamicEndpointAndInvokeAPITest", "1.0.0");
        this.apiIdentifier.setTier("Gold");
        this.apiStoreClientUser1.addApplication("AddDynamicEndpointAndInvokeAPI", "50PerMin", "", "");
        this.accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, "AddDynamicEndpointAndInvokeAPI").getAccessToken();
    }

    @Test(groups={"wso2.am"}, description="Invoke the API after adding the default endpoint")
    public void testAPIInvocationAfterAddingDynamicEndpoint() throws Exception {
        String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        String apiUser = this.gatewayContextMgt.getContextTenant().getContextUser().getUserName();
        this.createPublishAndSubscribeToAPI(this.apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, "AddDynamicEndpointAndInvokeAPI");
        ResourceAdminServiceClient resourceAdminServiceStub = new ResourceAdminServiceClient(this.publisherContext.getContextUrls().getBackEndUrl(), gatewaySessionCookie);
        boolean isResourceAdded = resourceAdminServiceStub.addResource("/_system/governance/apimgt/applicationdata/provider" + File.separator + apiUser + File.separator + "AddDynamicEndpointAndInvokeAPITest" + File.separator + "1.0.0" + File.separator + "in/default_endpoint.xml", "application/xml", "xml files", new DataHandler(new URL("file:///" + this.getAMResourceLocation() + File.separator + "sequence" + File.separator + "default_endpoint.xml")));
        Assert.assertTrue((boolean)isResourceAdded, (String)"Adding Mediation Sequence File failed");
        this.apiCreationRequestBean.setInSequence("default_endpoint");
        this.apiPublisherClientUser1.updateAPI(this.apiCreationRequestBean);
        this.waitForAPIDeployment();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet request = new HttpGet(this.getAPIInvocationURLHttp("AddDynamicEndpointAndInvokeAPI", "1.0.0"));
        request.setHeader("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = client.execute((HttpUriRequest)request);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        Assert.assertEquals((String)response.getHeaders("Content-Type")[0].getValue(), (String)"application/xml");
    }
}

