/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.server.mgt;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.telnet.TelnetClient;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.tests.server.mgt.CarbonTestServerManager;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.extensions.servers.carbonserver.TestServerManager;
import org.wso2.carbon.automation.test.utils.common.FileManager;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class OSGIServerBundleStatusTestCase {
    private static final Log log = LogFactory.getLog(OSGIServerBundleStatusTestCase.class);
    private static int telnetPort = 2000;
    private TelnetClient telnet = new TelnetClient();
    private ArrayList<String> arrList = new ArrayList();
    private ArrayList<String> unsatisfiedList = new ArrayList();
    private HashMap<String, String> serverPropertyMap = new HashMap();
    private PrintStream out;
    TestServerManager testServerManager;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        this.serverPropertyMap.put("-DportOffset", "510");
        this.serverPropertyMap.put("-DosgiConsole", Integer.toString(telnetPort));
        AutomationContext autoCtx = new AutomationContext();
        CarbonTestServerManager server = new CarbonTestServerManager(autoCtx, System.getProperty("carbon.zip"), this.serverPropertyMap);
        this.testServerManager = new TestServerManager(autoCtx, null, this.serverPropertyMap){

            public void configureServer() throws AutomationFrameworkException {
                try {
                    File sourceFile = new File(TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "configFiles" + File.separator + "osgi" + File.separator + "api-manager.xml");
                    FileManager.copyFile((File)sourceFile, (String)(this.getCarbonHome() + File.separator + "repository" + File.separator + "conf" + File.separator + "api-manager.xml"));
                }
                catch (IOException e) {
                    throw new AutomationFrameworkException(e.getMessage(), (Throwable)e);
                }
            }
        };
        this.testServerManager.startServer();
    }

    @AfterClass(alwaysRun=true)
    public void stopServers() throws Exception {
        this.disconnect();
        this.testServerManager.stopServer();
    }

    @Test(groups={"wso2.all"}, description="Identifying and storing unsatisfied OSGI components")
    public void testOSGIUnsatisfiedComponents() throws Exception {
        this.telnet.connect(InetAddress.getLocalHost().getHostAddress(), telnetPort);
        this.telnet.setSoTimeout(10000);
        ArrayList<String> arr = this.retrieveUnsatisfiedComponentsList("ls");
        for (int x = 0; x < arr.size(); ++x) {
            this.unsatisfiedList.add(this.arrList.get(x).split("\t")[3]);
            log.info((Object)this.unsatisfiedList.get(x));
        }
        Assert.assertEquals((int)this.unsatisfiedList.size(), (int)0, (String)("Unsatisfied components detected in server startup. " + this.getString(this.unsatisfiedList)));
    }

    private ArrayList<String> retrieveUnsatisfiedComponentsList(String command) throws IOException {
        this.writeInputCommand(command);
        try {
            this.readResponse();
        }
        catch (SocketTimeoutException e) {
            log.error((Object)("Socket timeout Exception " + e));
        }
        return this.arrList;
    }

    private void writeInputCommand(String value) throws UnsupportedEncodingException {
        this.out = new PrintStream(this.telnet.getOutputStream(), true, "UTF-8");
        this.out.println(value);
        this.out.flush();
        log.info((Object)value);
    }

    private void readResponse() throws IOException {
        String inputLine;
        InputStream in = this.telnet.getInputStream();
        BufferedReader inBuff = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        while ((inputLine = inBuff.readLine()) != null) {
            if (!inputLine.contains("Unsatisfied")) continue;
            this.arrList.add(inputLine);
            log.info((Object)inputLine);
        }
        inBuff.close();
        this.out.close();
    }

    private void disconnect() {
        try {
            this.telnet.disconnect();
        }
        catch (IOException e) {
            log.error((Object)("Error occurred while telnet disconnection " + e));
        }
    }

    private String getString(ArrayList<String> list) {
        if (list != null && list.size() > 0) {
            return list.toString();
        }
        return "";
    }
}

