/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.stats;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APIThrottlingTier;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.test.utils.thrift.DASThriftTestServer;
import org.wso2.am.integration.test.utils.thrift.StreamDefinitions;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIInvocationStatPublisherTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(APIInvocationStatPublisherTestCase.class);
    private final String API_NAME = "APIInvocationStatPublisherAPIName";
    private final String API_CONTEXT = "APIInvocationStatPublisherContext";
    private final String DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION = "1.0.0";
    private final String APP_NAME = "APIInvocationStatPublisherApp";
    private final String TIER_COLLECTION = "Unlimited";
    private static final DASThriftTestServer thriftTestServer = new DASThriftTestServer();
    private final int thriftServerListenPort = 7614;
    private final long WAIT_TIME = 60000L;
    private String publisherURLHttps;
    private String storeURLHttp;
    private APICreationRequestBean apiCreationRequestBean;
    private List<APIResourceBean> resList;
    private String endpointUrl;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String consumerKey;
    private String accessToken;
    private ServerConfigurationManager serverConfigurationManager;

    @Factory(dataProvider="userModeDataProvider")
    public APIInvocationStatPublisherTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.publisherURLHttps = this.publisherUrls.getWebAppURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttps);
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            thriftTestServer.addStreamDefinition(StreamDefinitions.getStreamDefinitionRequest(), -1234);
            thriftTestServer.addStreamDefinition(StreamDefinitions.getStreamDefinitionResponse(), -1234);
            thriftTestServer.addStreamDefinition(StreamDefinitions.getStreamDefinitionExecutionTime(), -1234);
            thriftTestServer.addStreamDefinition(StreamDefinitions.getStreamDefinitionWorkflow(), -1234);
            thriftTestServer.start(7614);
            this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
            this.serverConfigurationManager.applyConfiguration(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "stats" + File.separator + "api-manager.xml"));
        }
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
    }

    @Test(groups={"wso2.am"}, description="Sample API creation")
    public void testAPICreation() throws Exception {
        String providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("APIInvocationStatPublisherAPIName", "APIInvocationStatPublisherContext", "1.0.0", providerName, new URL(this.endpointUrl));
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTiersCollection("Unlimited");
        this.resList = new ArrayList<APIResourceBean>();
        APIResourceBean res1 = new APIResourceBean("GET", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType(), "Plus", "/add");
        this.resList.add(res1);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        HttpResponse serviceResponse = this.apiPublisher.addAPI(this.apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIInvocationStatPublisherAPIName", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APIInvocationStatPublisherAPIName", "1.0.0", "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Test API invocation", dependsOnMethods={"testAPICreation"})
    public void testApiInvocationAndEventTest() throws Exception {
        thriftTestServer.clearTables();
        HttpResponse serviceResponse = this.apiStore.addApplication("APIInvocationStatPublisherApp", APIThrottlingTier.UNLIMITED.getState(), "", "this-is-test");
        this.verifyResponse(serviceResponse);
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("APIInvocationStatPublisherAPIName", this.user.getUserName());
        subscriptionRequest.setApplicationName("APIInvocationStatPublisherApp");
        subscriptionRequest.setTier("Unlimited");
        serviceResponse = this.apiStore.subscribe(subscriptionRequest);
        this.verifyResponse(serviceResponse);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("APIInvocationStatPublisherApp");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        this.accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        this.consumerKey = response.getJSONObject("data").getJSONObject("key").get("consumerKey").toString();
        Assert.assertNotNull((Object)("Access Token not found " + responseString), (String)this.accessToken);
        this.requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        String invokeURL = this.getAPIInvocationURLHttp("APIInvocationStatPublisherContext", "1.0.0");
        serviceResponse = HTTPSClientUtils.doGet((String)(invokeURL + "/add?x=1&y=1"), this.requestHeaders);
        Assert.assertEquals((int)200, (int)serviceResponse.getResponseCode(), (String)"Error in response code");
        this.testRequestEvent();
        this.testResponseEvent();
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
        thriftTestServer.stop();
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.serverConfigurationManager.restoreToLastConfiguration();
        }
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    private void testRequestEvent() throws Exception {
        String userId;
        String resourcePath;
        String apiVersion;
        String context;
        List requestTable = null;
        long currentTime = System.currentTimeMillis();
        long waitTime = currentTime + 60000L;
        while (waitTime > System.currentTimeMillis() && ((requestTable = (List)thriftTestServer.getDataTables().get("org.wso2.apimgt.statistics.request:1.1.0")) == null || requestTable.isEmpty())) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((int)1, (int)requestTable.size(), (String)"Stat publisher published events not match");
        Map<String, Object> map = this.convertToMap(((Event)requestTable.get(0)).getPayloadData(), StreamDefinitions.getStreamDefinitionRequest());
        Assert.assertEquals((String)this.consumerKey, (String)map.get("consumerKey").toString(), (String)"Wrong consumer key is received");
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            context = "/APIInvocationStatPublisherContext/1.0.0";
            apiVersion = this.user.getUserName() + "--" + "APIInvocationStatPublisherAPIName" + ":v" + "1.0.0";
            resourcePath = "/add?x=1&y=1";
            userId = this.user.getUserName() + "@" + this.user.getUserDomain();
        } else {
            context = "/t/" + this.user.getUserDomain() + "/" + "APIInvocationStatPublisherContext" + "/" + "1.0.0";
            apiVersion = this.user.getUserName().replace("@", "-AT-") + "--" + "APIInvocationStatPublisherAPIName" + ":v" + "1.0.0";
            resourcePath = "/APIInvocationStatPublisherContext/1.0.0/add?x=1&y=1";
            userId = this.user.getUserName();
        }
        Assert.assertEquals((String)context, (String)map.get("context").toString(), (String)"Wrong context received");
        Assert.assertEquals((String)apiVersion, (String)map.get("api_version").toString(), (String)"Wrong api_version received");
        Assert.assertEquals((String)"APIInvocationStatPublisherAPIName", (String)map.get("api").toString(), (String)"Wrong api name received");
        Assert.assertEquals((String)resourcePath, (String)map.get("resourcePath").toString(), (String)"Wrong resourcePath received");
        Assert.assertEquals((String)"/add", (String)map.get("resourceTemplate").toString(), (String)"Wrong resourceTemplate received");
        Assert.assertEquals((String)"GET", (String)map.get("method").toString(), (String)"Wrong http method method received");
        Assert.assertEquals((String)"1.0.0", (String)map.get("version").toString(), (String)"Wrong version received");
        Assert.assertEquals((int)1, (int)Integer.parseInt(map.get("request").toString()), (String)"Wrong request count received");
        Assert.assertEquals((String)userId, (String)map.get("userId").toString(), (String)"Wrong userId received");
        Assert.assertEquals((String)this.user.getUserDomain(), (String)map.get("tenantDomain").toString(), (String)"Wrong tenant domain received");
        Assert.assertEquals((String)this.user.getUserName(), (String)map.get("apiPublisher").toString(), (String)"Wrong apiPublisher received");
        Assert.assertEquals((String)"APIInvocationStatPublisherApp", (String)map.get("applicationName").toString(), (String)"Wrong applicationName received");
        Assert.assertEquals((String)"Unlimited", (String)map.get("tier").toString(), (String)"Wrong subscribe tier received");
        Assert.assertEquals((String)"false", (String)map.get("throttledOut").toString(), (String)"Wrong throttledOut state received");
    }

    private void testResponseEvent() throws Exception {
        String username;
        String resourcePath;
        String apiVersion;
        String context;
        List responseTable = null;
        long currentTime = System.currentTimeMillis();
        long waitTime = currentTime + 60000L;
        while (waitTime > System.currentTimeMillis() && ((responseTable = (List)thriftTestServer.getDataTables().get("org.wso2.apimgt.statistics.response:1.1.0")) == null || responseTable.isEmpty())) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((int)1, (int)responseTable.size(), (String)"Stat publisher published events not match");
        Map<String, Object> map = this.convertToMap(((Event)responseTable.get(0)).getPayloadData(), StreamDefinitions.getStreamDefinitionResponse());
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            context = "/APIInvocationStatPublisherContext/1.0.0";
            apiVersion = this.user.getUserName() + "--" + "APIInvocationStatPublisherAPIName" + ":v" + "1.0.0";
            resourcePath = "/add?x=1&y=1";
            username = this.user.getUserName() + "@" + this.user.getUserDomain();
        } else {
            context = "/t/" + this.user.getUserDomain() + "/" + "APIInvocationStatPublisherContext" + "/" + "1.0.0";
            apiVersion = this.user.getUserName().replace("@", "-AT-") + "--" + "APIInvocationStatPublisherAPIName" + ":v" + "1.0.0";
            resourcePath = "/APIInvocationStatPublisherContext/1.0.0/add?x=1&y=1";
            username = this.user.getUserName();
        }
        Assert.assertEquals((String)this.consumerKey, (String)map.get("consumerKey").toString(), (String)"Wrong consumer key is received");
        Assert.assertEquals((String)context, (String)map.get("context").toString(), (String)"Wrong context received");
        Assert.assertEquals((String)apiVersion, (String)map.get("api_version").toString(), (String)"Wrong api_version received");
        Assert.assertEquals((String)"APIInvocationStatPublisherAPIName", (String)map.get("api").toString(), (String)"Wrong api name received");
        Assert.assertEquals((String)resourcePath, (String)map.get("resourcePath").toString(), (String)"Wrong resourcePath received");
        Assert.assertEquals((String)"/add", (String)map.get("resourceTemplate").toString(), (String)"Wrong resourceTemplate received");
        Assert.assertEquals((String)"GET", (String)map.get("method").toString(), (String)"Wrong http method method received");
        Assert.assertEquals((String)"1.0.0", (String)map.get("version").toString(), (String)"Wrong version received");
        Assert.assertEquals((int)1, (int)Integer.parseInt(map.get("response").toString()), (String)"Wrong request count received");
        Assert.assertEquals((String)username, (String)map.get("username").toString(), (String)"Wrong userId received");
        Assert.assertEquals((String)this.user.getUserDomain(), (String)map.get("tenantDomain").toString(), (String)"Wrong tenant domain received");
        Assert.assertEquals((String)this.user.getUserName(), (String)map.get("apiPublisher").toString(), (String)"Wrong apiPublisher received");
        Assert.assertEquals((String)"APIInvocationStatPublisherApp", (String)map.get("applicationName").toString(), (String)"Wrong applicationName received");
        Assert.assertEquals((String)"200", (String)map.get("responseCode").toString(), (String)"Wrong throttledOut state received");
        Assert.assertEquals((String)this.endpointUrl, (String)map.get("destination").toString(), (String)"Wrong destination url received");
    }

    private Map<String, Object> convertToMap(Object[] result, String stream) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONArray payloadData = new JSONObject(stream).getJSONArray("payloadData");
        Assert.assertEquals((int)result.length, (int)payloadData.length(), (String)"attributes counts are not equal");
        for (int i = 0; i < result.length; ++i) {
            String key = payloadData.getJSONObject(i).getString("name");
            map.put(key, result[i]);
        }
        return map;
    }
}

