/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.stats;

import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APIThrottlingTier;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.analytics.spark.admin.stub.AnalyticsProcessorAdminServiceStub;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIMANAGER4731StoreStatisticsWhenTokenEncryptedTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(APIMANAGER4731StoreStatisticsWhenTokenEncryptedTestCase.class);
    private final String API_NAME = "APIInvocationStatPublisherAPIName";
    private final String API_CONTEXT = "APIInvocationStatPublisherContext";
    private final String DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION = "1.0.0";
    private final String APP_NAME = "APIInvocationStatPublisherApp";
    private final String TIER_COLLECTION = "Unlimited";
    private final long WAIT_TIME = 300000L;
    private final String APIM_CONFIG_XML = "api-manager.xml";
    private final String IDENTITY_CONFIG_XML = "identity.xml";
    private final String DAS_USERNAME = "admin";
    private final String DAS_PASSWORD = "admin";
    private final String ANALYTICS_SCRIPT_NAME = "APIM_STAT_SCRIPT";
    private final String DAS_ANALYTICS_PROCESSOR_SERVICE_URL = "https://localhost:9446/services/AnalyticsProcessorAdminService";
    private final String API_STORE_STAT_URL = "/store/site/blocks/stats/perAppAPICount/ajax/stats.jag";
    private String publisherURLHttps;
    private String storeURLHttp;
    private APICreationRequestBean apiCreationRequestBean;
    private List<APIResourceBean> resList;
    private String endpointUrl;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private ServerConfigurationManager serverConfigurationManager;

    @Factory(dataProvider="userModeDataProvider")
    public APIMANAGER4731StoreStatisticsWhenTokenEncryptedTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.publisherURLHttps = this.publisherUrls.getWebAppURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttps);
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            String carbonHome = System.getProperty("carbon.home");
            String artifactsLocation = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "configFiles" + File.separator + "token_encryption" + File.separator;
            String apimConfigArtifactLocation = this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "stats" + File.separator + "tokenEncryptionEnabled" + File.separator + "api-manager.xml";
            String identityConfigArtifactLocation = artifactsLocation + "identity.xml";
            String apimRepositoryConfigLocation = carbonHome + File.separator + "repository" + File.separator + "conf" + File.separator + "api-manager.xml";
            String identityRepositoryConfigLocation = carbonHome + File.separator + "repository" + File.separator + "conf" + File.separator + "identity" + File.separator + "identity.xml";
            File apimConfSourceFile = new File(apimConfigArtifactLocation);
            File apimConfTargetFile = new File(apimRepositoryConfigLocation);
            File identityConfSourceFile = new File(identityConfigArtifactLocation);
            File identityConfTargetFile = new File(identityRepositoryConfigLocation);
            this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
            this.serverConfigurationManager.applyConfigurationWithoutRestart(apimConfSourceFile, apimConfTargetFile, true);
            this.log.info((Object)("api-manager.xml configuration file copy from :" + apimConfigArtifactLocation + " to :" + apimRepositoryConfigLocation));
            this.serverConfigurationManager.applyConfigurationWithoutRestart(identityConfSourceFile, identityConfTargetFile, true);
            this.log.info((Object)("identity.xml configuration file copy from :" + identityConfigArtifactLocation + " to :" + identityRepositoryConfigLocation));
            this.serverConfigurationManager.restartGracefully();
        }
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
    }

    @Test(groups={"wso2.am"}, description="Sample API creation")
    public void testAPICreation() throws Exception {
        String providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("APIInvocationStatPublisherAPIName", "APIInvocationStatPublisherContext", "1.0.0", providerName, new URL(this.endpointUrl));
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTiersCollection("Unlimited");
        this.resList = new ArrayList<APIResourceBean>();
        APIResourceBean res1 = new APIResourceBean("GET", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType(), "Plus", "/add");
        this.resList.add(res1);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        HttpResponse serviceResponse = this.apiPublisher.addAPI(this.apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIInvocationStatPublisherAPIName", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APIInvocationStatPublisherAPIName", "1.0.0", "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Test API invocation", dependsOnMethods={"testAPICreation"})
    public void testApiInvocationAndStatLoadingTest() throws Exception {
        HttpResponse serviceResponse = this.apiStore.addApplication("APIInvocationStatPublisherApp", APIThrottlingTier.UNLIMITED.getState(), "", "this-is-test");
        this.verifyResponse(serviceResponse);
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("APIInvocationStatPublisherAPIName", this.user.getUserName());
        subscriptionRequest.setApplicationName("APIInvocationStatPublisherApp");
        subscriptionRequest.setTier("Unlimited");
        serviceResponse = this.apiStore.subscribe(subscriptionRequest);
        this.verifyResponse(serviceResponse);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("APIInvocationStatPublisherApp");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        Assert.assertNotNull((Object)("Access Token not found " + responseString), (String)accessToken);
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        String invokeURL = this.getAPIInvocationURLHttp("APIInvocationStatPublisherContext", "1.0.0");
        serviceResponse = HTTPSClientUtils.doGet((String)(invokeURL + "/add?x=1&y=1"), this.requestHeaders);
        Assert.assertEquals((int)200, (int)serviceResponse.getResponseCode(), (String)"Error in response code");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Cookie", this.apiStore.getSession());
        this.executeScript();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Calendar calender = Calendar.getInstance();
        calender.set(5, calender.get(5) - 1);
        String fromDate = dateFormat.format(calender.getTime());
        calender.set(5, calender.get(5) + 2);
        String toDate = dateFormat.format(calender.getTime());
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        urlParameters.add(new BasicNameValuePair("action", "getProviderAPIUsage"));
        urlParameters.add(new BasicNameValuePair("currentLocation", "/store/site/pages/statistics.jag"));
        urlParameters.add(new BasicNameValuePair("fromDate", fromDate));
        urlParameters.add(new BasicNameValuePair("toDate", toDate));
        String url = this.backEndServerUrl.getWebAppURLHttp() + "/store/site/blocks/stats/perAppAPICount/ajax/stats.jag";
        HttpResponse res = HTTPSClientUtils.doPost((String)url, headers, urlParameters);
        this.verifyResponse(res);
        Assert.assertTrue((boolean)res.getData().contains("APIInvocationStatPublisherAPIName"), (String)"Store Statistics data not contain expected api name");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.serverConfigurationManager.restoreToLastConfiguration();
        }
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    private void executeScript() throws Exception {
        AnalyticsProcessorAdminServiceStub stub = new AnalyticsProcessorAdminServiceStub("https://localhost:9446/services/AnalyticsProcessorAdminService");
        ServiceClient client = stub._getServiceClient();
        Options client_options = client.getOptions();
        HttpTransportProperties.Authenticator authenticator = new HttpTransportProperties.Authenticator();
        authenticator.setUsername("admin");
        authenticator.setPassword("admin");
        authenticator.setPreemptiveAuthentication(true);
        client_options.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)authenticator);
        client.setOptions(client_options);
        long currentTime = System.currentTimeMillis();
        long waitTime = currentTime + 300000L;
        while (waitTime > System.currentTimeMillis()) {
            if (!stub.isAnalyticsTaskExecuting("APIM_STAT_SCRIPT") && !stub.isAnalyticsScriptExecuting("APIM_STAT_SCRIPT")) {
                AnalyticsProcessorAdminServiceStub.AnalyticsQueryResultDto[] results = stub.executeScript("APIM_STAT_SCRIPT");
                break;
            }
            Thread.sleep(30000L);
        }
    }
}

