/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.stats;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

public class UnsecureAPIWithStatsTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(UnsecureAPIWithStatsTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private static final String API_NAME = "UnsecureAPI";
    private static final String API_VERSION = "1.0.0";
    private ServerConfigurationManager serverManager;
    private static final String APIM_CONFIG_XML = "api-manager.xml";
    private static final String DATASOURCE_XML = "master-datasources.xml";
    private static String apiProvider;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        apiProvider = this.publisherContext.getSuperTenant().getContextUser().getUserName();
        String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        String carbonHome = System.getProperty("carbon.home");
        String artifactsLocation = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "configFiles" + File.separator + "stats" + File.separator;
        String apimConfigArtifactLocation = artifactsLocation + APIM_CONFIG_XML;
        String apimRepositoryConfigLocation = carbonHome + File.separator + "repository" + File.separator + "conf" + File.separator + APIM_CONFIG_XML;
        String masterDatasourceLocation = artifactsLocation + DATASOURCE_XML;
        String masterDatasourceConfigLocation = carbonHome + File.separator + "repository" + File.separator + "conf" + File.separator + "datasources" + File.separator + DATASOURCE_XML;
        File apimConfSourceFile = new File(apimConfigArtifactLocation);
        File apimConfTargetFile = new File(apimRepositoryConfigLocation);
        File dsConfSourceFile = new File(masterDatasourceLocation);
        File dsConfTargetFile = new File(masterDatasourceConfigLocation);
        this.serverManager = new ServerConfigurationManager(this.gatewayContextMgt);
        this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "dummy_api.xml", this.gatewayContextMgt, gatewaySessionCookie);
        this.serverManager.applyConfigurationWithoutRestart(apimConfSourceFile, apimConfTargetFile, true);
        log.info((Object)("api-manager.xml configuration file copied from :" + apimConfigArtifactLocation + " to :" + apimRepositoryConfigLocation));
        this.serverManager.applyConfigurationWithoutRestart(dsConfSourceFile, dsConfTargetFile, true);
        log.info((Object)("master-datasources.xml configuration file copied from :" + masterDatasourceLocation + " to :" + masterDatasourceConfigLocation));
        this.serverManager.restartGracefully();
        super.init();
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
    }

    @Test(groups={"wso2.am"}, description="Check if analytics work for non-secured APIs.")
    public void testUnsecureAPIWithStats() {
        String apiContext = "analyticsapi";
        String endpointUrl = this.gatewayUrlsWrk.getWebAppURLNhttp() + "response";
        APIRequest apiRequest = null;
        try {
            apiRequest = new APIRequest(API_NAME, apiContext, new URL(endpointUrl));
        }
        catch (MalformedURLException e) {
            log.error((Object)("Invalid URL " + endpointUrl), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (APIManagerIntegrationTestException e) {
            log.error((Object)"Integration Test error occurred ", (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        apiRequest.setVersion(API_VERSION);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        try {
            this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
            this.apiPublisher.addAPI(apiRequest);
            APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(API_NAME, apiProvider, APILifeCycleState.PUBLISHED);
            this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
            String modifiedResource = "{\"paths\":{ \"/*\":{\"put\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"None\",\"x-throttling-tier\":\"Unlimited\" },\"post\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"None\",\"x-throttling-tier\":\"Unlimited\",\"x-scope\":\"admin_scope\"},\"get\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"None\",\"x-throttling-tier\":\"Unlimited\",\"x-scope\":\"user_scope\"},\"delete\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"None\",\"x-throttling-tier\":\"Unlimited\"},\"options\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"None\",\"x-throttling-tier\":\"Unlimited\"}}},\"swagger\":\"2.0\",\"info\":{\"title\":\"UnsecureAPI\",\"version\":\"1.0.0\"},\"x-wso2-security\":{\"apim\":{\"x-wso2-scopes\":[{\"name\":\"admin_scope\",\"description\":\"\",\"key\":\"admin_scope\",\"roles\":\"admin\"},{\"name\":\"user_scope\",\"description\":\"\",\"key\":\"user_scope\",\"roles\":\"admin,subscriber\"}]}}}";
            this.apiPublisher.updateResourceOfAPI(apiProvider, API_NAME, API_VERSION, modifiedResource);
            String apiInvocationUrl = this.gatewayContextMgt.getContextTenant().getDomain().equals("carbon.super") ? this.gatewayUrlsWrk.getWebAppURLNhttp() + apiContext + "/" + API_VERSION : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextMgt.getContextTenant().getDomain() + "/" + apiContext + "/" + API_VERSION;
            HttpResponse directResponse = HttpRequestUtil.doGet((String)endpointUrl, new HashMap());
            HttpResponse httpResponse = HttpRequestUtil.doGet((String)apiInvocationUrl, new HashMap());
            Assert.assertEquals((String)httpResponse.getData(), (String)directResponse.getData(), (String)"Un-secure API test failed since the response from the direct back-end did not match with the response from the server");
        }
        catch (APIManagerIntegrationTestException e) {
            log.error((Object)"Error occurred while executing Test", (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error occurred while getting credentials from the publisher/store context ", (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (IOException e) {
            log.error((Object)"IO error occurred when doing an http request");
            Assert.assertTrue((boolean)false);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        if (this.apiPublisher != null) {
            this.apiPublisher.deleteAPI(API_NAME, API_VERSION, apiProvider);
        }
        super.cleanUp();
        this.serverManager.restoreToLastConfiguration();
        log.info((Object)"Restored configuration and restarted gracefully...");
    }
}

