/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.throttling;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIThrottlingTestCase
extends APIManagerLifecycleBaseTest {
    private ServerConfigurationManager serverConfigurationManager;
    private UserManagementClient userManagementClient1;
    private static final Log log = LogFactory.getLog(APIThrottlingTestCase.class);
    private String publisherURLHttp;
    private String storeURLHttp;
    private final String INTERNAL_ROLE_SUBSCRIBER = "Internal/subscriber";
    private String apiName = "APIThrottleAPI";
    private String apiContext = "api_throttle";
    private String tags = "token, throttling";
    private String description = "This is test API created by API manager integration test";
    private String providerName;
    private String apiVersion = "1.0.0";
    private String applicationName = "APIThrottle-application";
    private String backendURL;
    String subscriberUser = "subscriberUser2";
    String subscriberUserWithTenantDomain;
    String password = "password@123";

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.subscriberUserWithTenantDomain = this.subscriberUser + "@" + this.user.getUserDomain();
        this.publisherURLHttp = this.getPublisherURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
            this.subscriberUserWithTenantDomain = this.subscriberUser;
            String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
            this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "api_throttle_backend.xml", this.gatewayContextMgt, gatewaySessionCookie);
            this.waitForAPIDeploymentSync(this.user.getUserName(), this.apiName, this.apiVersion, "\"isApiExists\":true");
            ServerConfigurationManager serverConfigManagerForTenant = new ServerConfigurationManager(this.superTenantKeyManagerContext);
            serverConfigManagerForTenant.restartGracefully();
            super.init(this.userMode);
        }
        this.backendURL = this.getSuperTenantAPIInvocationURLHttp("api_throttle_backend", "1.0");
        this.providerName = this.user.getUserName();
    }

    @Test(groups={"wso2.am"}, description="API Throttling Test", enabled=true)
    public void testAPIThrottling_1() throws Exception {
        this.publishAndInvokeAPI(this.apiName, this.apiVersion, this.apiContext, this.description, this.backendURL, this.tags, this.providerName);
    }

    private void publishAndInvokeAPI(String apiName, String apiVersion, String apiContext, String description, String endpointURL, String tags, String providerName) throws APIManagerIntegrationTestException, XPathExpressionException, IOException, JSONException {
        APIPublisherRestClient apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiName, apiContext, apiVersion, this.user.getUserName(), new URL(this.backendURL));
        apiCreationRequestBean.setTiersCollection("Silver");
        ArrayList<APIResourceBean> resList = new ArrayList<APIResourceBean>();
        APIResourceBean res = new APIResourceBean("GET", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION.getAuthType(), "Basic", "test");
        resList.add(res);
        apiCreationRequestBean.setResourceBeanList(resList);
        HttpResponse serviceResponse = apiPublisher.addAPI(apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        this.waitForAPIDeploymentSync(this.user.getUserName(), apiName, apiVersion, "\"isApiExists\":true");
        APIStoreRestClient apiStore = new APIStoreRestClient(this.storeURLHttp);
        apiStore.login(this.user.getUserName(), this.user.getPassword());
        serviceResponse = apiStore.addApplication(this.applicationName, "50PerMin", "", "this-is-test");
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(apiName, this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        this.waitForAPIDeploymentSync(this.user.getUserName(), apiName, apiVersion, "\"isApiExists\":true");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(apiName, this.user.getUserName());
        subscriptionRequest.setApplicationName(this.applicationName);
        subscriptionRequest.setTier("Silver");
        serviceResponse = apiStore.subscribe(subscriptionRequest);
        this.verifyResponse(serviceResponse);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(this.applicationName);
        String responseString = apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        Assert.assertNotNull((Object)("Access Token not found " + responseString), (String)accessToken);
        String invokeURL = this.getAPIInvocationURLHttps(apiContext);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        log.info((Object)("=============================== Headers : " + requestHeaders));
        log.info((Object)("=============================== invokeURL : " + invokeURL));
        serviceResponse = HTTPSClientUtils.doGet((String)(invokeURL + "/1.0.0/test"), requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.checkThrottling(accessToken, invokeURL, requestHeaders);
    }

    private void checkThrottling(String accessToken, String invokeURL, Map<String, String> requestHeaders) {
        int limit = 4;
        int numberOfIterations = 4;
        for (int count = 0; count < numberOfIterations; ++count) {
            try {
                log.info((Object)(" =================================== Number of time API Invoked : " + count));
                if (count == limit) {
                    Thread.sleep(10000L);
                }
                HttpResponse serviceResponse = this.callAPI(accessToken, invokeURL, requestHeaders);
                if (count == limit) {
                    Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)429, (String)"Response code is not as expected");
                    continue;
                }
                Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
                continue;
            }
            catch (Exception ex) {
                log.error((Object)("Error occurred while calling API : " + ex));
                break;
            }
        }
    }

    private HttpResponse callAPI(String accessToken, String invokeURL, Map<String, String> requestHeaders) throws Exception {
        HttpResponse serviceResponse = HTTPSClientUtils.doGet((String)(invokeURL + "/1.0.0/test"), requestHeaders);
        return serviceResponse;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public APIThrottlingTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
        if (this.userManagementClient1 != null) {
            this.userManagementClient1.deleteRole("Internal/subscriber");
            this.userManagementClient1.deleteUser(this.subscriberUser);
        }
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.serverConfigurationManager.restoreToLastConfiguration();
        }
    }
}

