/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.throttling;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIThrottlingTierRequest;
import org.wso2.am.integration.test.utils.clients.AdminDashboardRestClient;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APITierManagementTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(APITierManagementTestCase.class);
    private AdminDashboardRestClient adminDashboard;
    private String tierName = "SampleTier";

    @Factory(dataProvider="userModeDataProvider")
    public APITierManagementTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String storeURLHttp = this.getStoreURLHttp();
        this.adminDashboard = new AdminDashboardRestClient(storeURLHttp);
        this.adminDashboard.login(this.user.getUserName(), this.user.getPassword());
    }

    @Test(groups={"wso2.am"}, description="Add tier through admin-dashboard")
    public void addTierTestCase() throws Exception {
        APIThrottlingTierRequest tierRequest = new APIThrottlingTierRequest(this.tierName, "5", "Sample Tier", "120", "true", "FREE");
        tierRequest.setAction("addTier");
        HttpResponse addTierResponse = this.adminDashboard.addTier(tierRequest);
        this.verifyResponse(addTierResponse);
        String getTiersResponse = this.adminDashboard.getAllTiers().getData();
        this.log.info((Object)getTiersResponse);
        Assert.assertTrue((boolean)getTiersResponse.contains(this.tierName), (String)"Added tier not found");
    }

    @Test(groups={"wso2.am"}, description="Delete tier through admin-dashboard")
    public void deleteTierTestCase() throws Exception {
        HttpResponse addTierResponse = this.adminDashboard.deleteTier(this.tierName);
        this.verifyResponse(addTierResponse);
        String getTiersResponse = this.adminDashboard.getAllTiers().getData();
        this.log.info((Object)getTiersResponse);
        Assert.assertTrue((!getTiersResponse.contentEquals(this.tierName) ? 1 : 0) != 0, (String)"Tier not deleted");
    }
}

