/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.throttling;

import java.io.File;
import java.net.URL;
import javax.activation.DataHandler;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.registry.ResourceAdminServiceClient;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class ThrottlingTestCase
extends APIMIntegrationBaseTest {
    private String gatewaySessionCookie;

    @Factory(dataProvider="userModeDataProvider")
    public ThrottlingTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        String throttlingSynapseConfFile = this.gatewayContextMgt.getContextTenant().getDomain().equals("carbon.super") ? "throttling-api-synapse.xml" : "throttling-api-synapse-tenant.xml";
        this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "throttling" + File.separator + throttlingSynapseConfFile, this.gatewayContextMgt, this.gatewaySessionCookie);
    }

    @Test(groups={"wso2.am"}, description="Token API Test other")
    public void throttlingTestCase() throws Exception {
        ResourceAdminServiceClient resourceAdminServiceStub = new ResourceAdminServiceClient(this.publisherContext.getContextUrls().getBackEndUrl(), this.gatewaySessionCookie);
        resourceAdminServiceStub.addCollection("/_system/config/", "proxy", "", "Contains test proxy tests files");
        Assert.assertTrue((boolean)resourceAdminServiceStub.addResource("/_system/governance/apimgt/applicationdata/test-tiers.xml", "application/xml", "xml files", new DataHandler(new URL("file:///" + this.getAMResourceLocation() + File.separator + "configFiles/throttling/" + "throttle-policy.xml"))), (String)"Adding Resource failed");
        Thread.sleep(2000L);
        String gatewayUrl = this.getAPIInvocationURLHttp("stockquote/test/");
        HttpResponse response = HttpRequestUtil.sendGetRequest((String)gatewayUrl, null);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatch did not receive 200");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

