/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.token;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.webapp.WebAppAdminClient;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.generic.TestConfigurationProvider;
import org.wso2.am.integration.test.utils.webapp.WebAppDeploymentUtil;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM34InvokeAPIWithSandboxTokenTestCase
extends APIMIntegrationBaseTest {
    private final String apiNameTest1 = "APIM34SandBoxTest1API";
    private final String apiNameTest2 = "APIM34SandBoxTest2API";
    private final String apiNameTest3 = "APIM34SandBoxTest3API";
    private final String apiNameTest4 = "APIM34SandBoxTest4API";
    private final String apiNameTest5 = "APIM34SandBoxTest5API";
    private final String apiVersion = "1.0.0";
    private final String apiDescription = "This is Test API Created by API Manager Integration Test";
    private String apiTag = "tag34-1, tag34-2, tag34-3";
    private String applicationNameTest1 = "APIM34InvokeAPIWithSandboxTokenTest1";
    private String applicationNameTest2 = "APIM34InvokeAPIWithSandboxTokenTest2";
    private String applicationNameTest3 = "APIM34InvokeAPIWithSandboxTokenTest3";
    private String applicationNameTest4 = "APIM34InvokeAPIWithSandboxTokenTest4";
    private String applicationNameTest5 = "APIM34InvokeAPIWithSandboxTokenTest5";
    private String sandboxEndpointResponse = "HelloWSO2 from File 1";
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String apiProviderName;
    private String apiProductionEndPointUrl;
    private String apiSandBoxEndPointUrl;
    private APIIdentifier apiIdentifierPublisherTest1;
    private APIIdentifier apiIdentifierPublisherTest2;
    private APIIdentifier apiIdentifierPublisherTest3;
    private APIIdentifier apiIdentifierPublisherTest4;
    private APIIdentifier apiIdentifierPublisherTest5;
    private List<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();

    @Factory(dataProvider="userModeDataProvider")
    public APIM34InvokeAPIWithSandboxTokenTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String productionWebAppName = "jaxrs_basic";
        String SanBoxWebAppName = "name-check1";
        String apiSandBoxEndpointPostfixUrl = "name-check1/";
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        String sourcePathProd = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + productionWebAppName + ".war";
        String sourcePathSand = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + SanBoxWebAppName + ".war";
        String sessionId = this.createSession(this.gatewayContextWrk);
        WebAppAdminClient webAppAdminClient = new WebAppAdminClient(this.gatewayContextWrk.getContextUrls().getBackEndUrl(), sessionId);
        webAppAdminClient.uploadWarFile(sourcePathProd);
        webAppAdminClient.uploadWarFile(sourcePathSand);
        boolean isWebAppDeployProd = WebAppDeploymentUtil.isWebApplicationDeployed((String)this.gatewayContextWrk.getContextUrls().getBackEndUrl(), (String)sessionId, (String)productionWebAppName);
        Assert.assertTrue((boolean)isWebAppDeployProd, (String)(productionWebAppName + " is not deployed"));
        boolean isWebAppDeploySand = WebAppDeploymentUtil.isWebApplicationDeployed((String)this.gatewayContextWrk.getContextUrls().getBackEndUrl(), (String)sessionId, (String)SanBoxWebAppName);
        Assert.assertTrue((boolean)isWebAppDeploySand, (String)(SanBoxWebAppName + " is not deployed"));
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.apiProductionEndPointUrl = this.getGatewayURLHttp() + apiProductionEndpointPostfixUrl;
        this.apiSandBoxEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiSandBoxEndpointPostfixUrl;
        this.apiProviderName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        this.apiIdentifierPublisherTest1 = new APIIdentifier(this.apiProviderName, "APIM34SandBoxTest1API", "1.0.0");
        this.apiIdentifierPublisherTest2 = new APIIdentifier(this.apiProviderName, "APIM34SandBoxTest2API", "1.0.0");
        this.apiIdentifierPublisherTest3 = new APIIdentifier(this.apiProviderName, "APIM34SandBoxTest3API", "1.0.0");
        this.apiIdentifierPublisherTest4 = new APIIdentifier(this.apiProviderName, "APIM34SandBoxTest4API", "1.0.0");
        this.apiIdentifierPublisherTest5 = new APIIdentifier(this.apiProviderName, "APIM34SandBoxTest5API", "1.0.0");
    }

    @Test(groups={"wso2.am"}, description="Published an API with valid Production endpoint and Sandbox endpoint then invoke API from Sandbox token")
    public void testInvokeAPIFromSandboxTokenWhenProvideBothEndPoints() throws Exception {
        String apiContextTest1 = "apim34SandBoxTest1API";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM34SandBoxTest1API", apiContextTest1, "1.0.0", this.apiProviderName, new URL(this.apiProductionEndPointUrl), new URL(this.apiSandBoxEndPointUrl));
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        this.resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "name"));
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM34SandBoxTest1APIis not created as expected");
        Assert.assertTrue((boolean)apiCreationResponse.getData().contains("\"error\" : false"), (String)"APIM34SandBoxTest1APIis not created as expected");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIM34SandBoxTest1API", this.apiProviderName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        List publisherAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisher.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierPublisherTest1, (List)publisherAPIList), (String)"APIM34SandBoxTest1APIis not visible in API Publisher.");
        List storeAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getAllPublishedAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierPublisherTest1, (List)storeAPIList), (String)"APIM34SandBoxTest1APIis not visible in API Store.");
        this.apiStore.addApplication(this.applicationNameTest1, "Gold", "", "");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("APIM34SandBoxTest1API", this.apiProviderName);
        subscriptionRequest.setApplicationName(this.applicationNameTest1);
        HttpResponse subscribeApiResponse = this.apiStore.subscribe(subscriptionRequest);
        Assert.assertEquals((int)subscribeApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM34SandBoxTest1APIis not Subscribed");
        Assert.assertTrue((boolean)subscribeApiResponse.getData().contains("\"error\" : false"), (String)"APIM34SandBoxTest1APIis not Subscribed");
        APPKeyRequestGenerator generateAppKeyRequestSandBox = new APPKeyRequestGenerator(this.applicationNameTest1);
        generateAppKeyRequestSandBox.setKeyType("SANDBOX");
        String responseSandBox = this.apiStore.generateApplicationKey(generateAppKeyRequestSandBox).getData();
        JSONObject jsonObject = new JSONObject(responseSandBox);
        String sandboxAccessToken = jsonObject.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + sandboxAccessToken);
        Thread.sleep(2000L);
        HttpResponse sandBoxResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(apiContextTest1 + "/" + "1.0.0") + "/name"), requestHeaders);
        Assert.assertEquals((int)sandBoxResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation from sandbox token");
        Assert.assertTrue((boolean)sandBoxResponse.getData().contains(this.sandboxEndpointResponse), (String)"Response code mismatched when api invocation from sandbox token");
    }

    @Test(groups={"wso2.am"}, description="Published an API only with valid Sandbox endpoint and invoke API from Sandbox token")
    public void testInvokeAPIFromSandboxTokenWhenProvideOnlySandboxEndPoint() throws Exception {
        String apiContextTest2 = "apim34SandBoxTest2API";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM34SandBoxTest2API", apiContextTest2, "1.0.0", this.apiProviderName, null, new URL(this.apiSandBoxEndPointUrl));
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        this.resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "name"));
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM34SandBoxTest2APIis not created as expected");
        Assert.assertTrue((boolean)apiCreationResponse.getData().contains("\"error\" : false"), (String)"APIM34SandBoxTest2APIis not created as expected");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIM34SandBoxTest2API", this.apiProviderName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        List publisherAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisher.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierPublisherTest2, (List)publisherAPIList), (String)"Published Api is visible in API Publisher.");
        List storeAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getAllPublishedAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierPublisherTest2, (List)storeAPIList), (String)"Published Api is visible in API Store.");
        this.apiStore.addApplication(this.applicationNameTest2, "Gold", "", "");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("APIM34SandBoxTest2API", this.apiProviderName);
        subscriptionRequest.setApplicationName(this.applicationNameTest2);
        HttpResponse subscribeApiResponse = this.apiStore.subscribe(subscriptionRequest);
        Assert.assertEquals((int)subscribeApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM34SandBoxTest2APIis not Subscribed");
        Assert.assertTrue((boolean)subscribeApiResponse.getData().contains("\"error\" : false"), (String)"APIM34SandBoxTest2APIis not Subscribed");
        APPKeyRequestGenerator generateAppKeyRequestSandBox = new APPKeyRequestGenerator(this.applicationNameTest2);
        generateAppKeyRequestSandBox.setKeyType("SANDBOX");
        String responseSandBox = this.apiStore.generateApplicationKey(generateAppKeyRequestSandBox).getData();
        JSONObject jsonObject = new JSONObject(responseSandBox);
        String sandboxAccessToken = jsonObject.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + sandboxAccessToken);
        Thread.sleep(2000L);
        HttpResponse sandBoxResponse = HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + apiContextTest2 + "/" + "1.0.0" + "/name"), requestHeaders);
        Assert.assertEquals((int)sandBoxResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation from sandbox token");
        Assert.assertTrue((boolean)sandBoxResponse.getData().contains(this.sandboxEndpointResponse), (String)"Response data mismatched when api invocation from sandbox token");
    }

    @Test(groups={"wso2.am"}, description="Published an API only with valid Production endpoint and trying to invoke API from Sandbox token")
    public void testInvokeAPIFromSandboxTokenWhenProvideOnlyProductionEndPoint() throws Exception {
        String apiContextTest3 = "apim34SandBoxTest3API";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM34SandBoxTest3API", apiContextTest3, "1.0.0", this.apiProviderName, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM34SandBoxTest3APIis not created as expected");
        Assert.assertTrue((boolean)apiCreationResponse.getData().contains("\"error\" : false"), (String)"APIM34SandBoxTest3APIis not created as expected");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIM34SandBoxTest3API", this.apiProviderName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        List publisherAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisher.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierPublisherTest3, (List)publisherAPIList), (String)"Published Api is visible in API Publisher.");
        List storeAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getAllPublishedAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierPublisherTest3, (List)storeAPIList), (String)"Published Api is visible in API Store.");
        this.apiStore.addApplication(this.applicationNameTest3, "Gold", "", "");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("APIM34SandBoxTest3API", this.apiProviderName);
        subscriptionRequest.setApplicationName(this.applicationNameTest3);
        HttpResponse subscribeApiResponse = this.apiStore.subscribe(subscriptionRequest);
        Assert.assertEquals((int)subscribeApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM34SandBoxTest3APIis not Subscribed");
        Assert.assertTrue((boolean)subscribeApiResponse.getData().contains("\"error\" : false"), (String)"APIM34SandBoxTest3APIis not Subscribed");
        APPKeyRequestGenerator generateAppKeyRequestSandBox = new APPKeyRequestGenerator(this.applicationNameTest3);
        generateAppKeyRequestSandBox.setKeyType("SANDBOX");
        String responseSandBox = this.apiStore.generateApplicationKey(generateAppKeyRequestSandBox).getData();
        JSONObject jsonObject = new JSONObject(responseSandBox);
        String sandboxAccessToken = jsonObject.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + sandboxAccessToken);
        Thread.sleep(2000L);
        HttpResponse sandBoxResponse = HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + apiContextTest3 + "/" + "1.0.0"), requestHeaders);
        Assert.assertEquals((int)sandBoxResponse.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Response code mismatched when api invocation from incorrect token");
        Assert.assertTrue((boolean)sandBoxResponse.getData().contains("Sandbox key offered to the API with no sandbox endpoint"), (String)"API which is created only with Production endpoint can be invoke from SandBox Key");
    }

    @Test(groups={"wso2.am"}, description="Published an API only with valid Sandbox Endpoint and invoke API from Production token")
    public void testInvokeAPIFromProductionTokenWhenProvideOnlySandboxEndPoint() throws Exception {
        String apiContextTest4 = "apim34SandBoxTest4API";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM34SandBoxTest4API", apiContextTest4, "1.0.0", this.apiProviderName, null, new URL(this.apiSandBoxEndPointUrl));
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        this.resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "name"));
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM34SandBoxTest4APIis not created as expected");
        Assert.assertTrue((boolean)apiCreationResponse.getData().contains("\"error\" : false"), (String)"APIM34SandBoxTest4APIis not created as expected");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIM34SandBoxTest4API", this.apiProviderName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        List publisherAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisher.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierPublisherTest4, (List)publisherAPIList), (String)"Published Api is visible in API Publisher.");
        List storeAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getAllPublishedAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierPublisherTest4, (List)storeAPIList), (String)"Published Api is visible in API Store.");
        this.apiStore.addApplication(this.applicationNameTest4, "Gold", "", "");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("APIM34SandBoxTest4API", this.apiProviderName);
        subscriptionRequest.setApplicationName(this.applicationNameTest4);
        HttpResponse subscribeApiResponse = this.apiStore.subscribe(subscriptionRequest);
        Assert.assertEquals((int)subscribeApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM34SandBoxTest4APIis not Subscribed");
        Assert.assertTrue((boolean)subscribeApiResponse.getData().contains("\"error\" : false"), (String)"APIM34SandBoxTest4APIis not Subscribed");
        APPKeyRequestGenerator generateAppKeyRequestSandBox = new APPKeyRequestGenerator(this.applicationNameTest4);
        String responseSandBox = this.apiStore.generateApplicationKey(generateAppKeyRequestSandBox).getData();
        JSONObject jsonObject = new JSONObject(responseSandBox);
        String sandboxAccessToken = jsonObject.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + sandboxAccessToken);
        requestHeaders.put("accept", "text/xml");
        Thread.sleep(2000L);
        HttpResponse sandBoxResponse = HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + apiContextTest4 + "/" + "1.0.0" + "/name"), requestHeaders);
        Assert.assertEquals((int)sandBoxResponse.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Response code mismatched when api invocation from incorrect token");
        Assert.assertTrue((boolean)sandBoxResponse.getData().contains("Production key offered to the API with no production endpoint"), (String)"API which is created only with sandbox endpoint can be invoke from production Key");
    }

    @Test(groups={"wso2.am"}, description="Published an API with valid Production endpoint and Sandbox endpoint then invoke API from Production and Sandbox token")
    public void testInvokeAPIFromSandboxAndProductionTokenWhenProvideBothEndPoints() throws Exception {
        String apiContextTest5 = "apim34SandBoxTest5API";
        String productionEndpointResponse = "<Customer><id>123</id><name>John</name></Customer>";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM34SandBoxTest5API", apiContextTest5, "1.0.0", this.apiProviderName, new URL(this.apiProductionEndPointUrl), new URL(this.apiSandBoxEndPointUrl));
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        this.resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "name"));
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM34SandBoxTest5APIis not created as expected");
        Assert.assertTrue((boolean)apiCreationResponse.getData().contains("\"error\" : false"), (String)"APIM34SandBoxTest5APIis not created as expected");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIM34SandBoxTest5API", this.apiProviderName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        List publisherAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisher.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierPublisherTest5, (List)publisherAPIList), (String)"Published Api is visible in API Publisher.");
        List storeAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getAllPublishedAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierPublisherTest5, (List)storeAPIList), (String)"Published Api is visible in API Store.");
        this.apiStore.addApplication(this.applicationNameTest5, "Gold", "", "");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("APIM34SandBoxTest5API", this.apiProviderName);
        subscriptionRequest.setApplicationName(this.applicationNameTest5);
        HttpResponse subscribeApiResponse = this.apiStore.subscribe(subscriptionRequest);
        Assert.assertEquals((int)subscribeApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM34SandBoxTest5APIis not Subscribed");
        Assert.assertTrue((boolean)subscribeApiResponse.getData().contains("\"error\" : false"), (String)"APIM34SandBoxTest5APIis not Subscribed");
        APPKeyRequestGenerator generateAppKeyRequestProduction = new APPKeyRequestGenerator(this.applicationNameTest5);
        APPKeyRequestGenerator generateAppKeyRequestSandBox = new APPKeyRequestGenerator(this.applicationNameTest5);
        generateAppKeyRequestSandBox.setKeyType("SANDBOX");
        String responseProduction = this.apiStore.generateApplicationKey(generateAppKeyRequestProduction).getData();
        JSONObject jsonObjectProduction = new JSONObject(responseProduction);
        String productionAccessToken = jsonObjectProduction.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> productionRequestHeaders = new HashMap<String, String>();
        productionRequestHeaders.put("Authorization", "Bearer " + productionAccessToken);
        productionRequestHeaders.put("accept", "text/xml");
        String responseSandBox = this.apiStore.generateApplicationKey(generateAppKeyRequestSandBox).getData();
        JSONObject jsonObjectSandBox = new JSONObject(responseSandBox);
        String sandboxAccessToken = jsonObjectSandBox.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> sandboxRequestHeaders = new HashMap<String, String>();
        sandboxRequestHeaders.put("Authorization", "Bearer " + sandboxAccessToken);
        Thread.sleep(2000L);
        HttpResponse productionResponse = HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + apiContextTest5 + "/" + "1.0.0"), productionRequestHeaders);
        Assert.assertEquals((int)productionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation from Production Token");
        Assert.assertTrue((boolean)productionResponse.getData().contains(productionEndpointResponse), (String)"Response data mismatched when api invocation from Production Token");
        HttpResponse sandBoxResponse = HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + apiContextTest5 + "/" + "1.0.0" + "/name"), sandboxRequestHeaders);
        Assert.assertEquals((int)sandBoxResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation From SandBox Token");
        Assert.assertTrue((boolean)sandBoxResponse.getData().contains(this.sandboxEndpointResponse), (String)"Response data mismatched when api invocation from Sanbox Token");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.apiStore.removeAPISubscriptionByName("APIM34SandBoxTest1API", "1.0.0", this.apiProviderName, this.applicationNameTest1);
        this.apiStore.removeAPISubscriptionByName("APIM34SandBoxTest2API", "1.0.0", this.apiProviderName, this.applicationNameTest2);
        this.apiStore.removeAPISubscriptionByName("APIM34SandBoxTest3API", "1.0.0", this.apiProviderName, this.applicationNameTest3);
        this.apiStore.removeAPISubscriptionByName("APIM34SandBoxTest4API", "1.0.0", this.apiProviderName, this.applicationNameTest4);
        this.apiStore.removeAPISubscriptionByName("APIM34SandBoxTest5API", "1.0.0", this.apiProviderName, this.applicationNameTest5);
        this.apiStore.removeApplication(this.applicationNameTest1);
        this.apiStore.removeApplication(this.applicationNameTest2);
        this.apiStore.removeApplication(this.applicationNameTest3);
        this.apiStore.removeApplication(this.applicationNameTest4);
        this.apiStore.removeApplication(this.applicationNameTest5);
        this.apiPublisher.deleteAPI("APIM34SandBoxTest1API", "1.0.0", this.apiProviderName);
        this.apiPublisher.deleteAPI("APIM34SandBoxTest2API", "1.0.0", this.apiProviderName);
        this.apiPublisher.deleteAPI("APIM34SandBoxTest3API", "1.0.0", this.apiProviderName);
        this.apiPublisher.deleteAPI("APIM34SandBoxTest4API", "1.0.0", this.apiProviderName);
        this.apiPublisher.deleteAPI("APIM34SandBoxTest5API", "1.0.0", this.apiProviderName);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }
}

