/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.token;

import java.net.URL;
import java.util.HashMap;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class OpenIDTokenAPITestCase
extends APIMIntegrationBaseTest {
    private APIStoreRestClient apiStore;
    private String consumerKey;
    private String consumerSecret;
    private String userAccessToken;

    @Factory(dataProvider="userModeDataProvider")
    public OpenIDTokenAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.addApplication("OpenIDTokenTestAPIApplication", "50PerMin", "", "this-is-test");
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("OpenIDTokenTestAPIApplication");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        this.consumerKey = response.getJSONObject("data").getJSONObject("key").getString("consumerKey");
        this.consumerSecret = response.getJSONObject("data").getJSONObject("key").getString("consumerSecret");
    }

    @Test(groups={"wso2.am"}, description="Token API Test sample")
    public void testGenerateAccessTokenWithOpenIdScope() throws Exception {
        String requestBody = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope=openid";
        URL tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttps() + "token");
        JSONObject accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, requestBody, tokenEndpointURL).getData());
        this.userAccessToken = accessTokenGenerationResponse.getString("access_token");
        String scope = accessTokenGenerationResponse.getString("scope");
        Assert.assertTrue((boolean)scope.contains("openid"), (String)"Response data mismatched, openid scope test failed due to error in response");
    }

    @Test(groups={"wso2.am"}, description="Token API Test sample", dependsOnMethods={"testGenerateAccessTokenWithOpenIdScope"})
    public void testCallUserInfoApiWithOpenIdAccessToken() throws Exception {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + this.userAccessToken);
        HttpResponse userInfoResponse = HTTPSClientUtils.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + "userinfo?schema=openid"), requestHeaders);
        Assert.assertEquals((int)userInfoResponse.getResponseCode(), (int)200, (String)"Response code mismatched");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

