/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.token;

import java.net.URL;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class RefreshTokenTestCase
extends APIMIntegrationBaseTest {
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private ServerConfigurationManager serverConfigurationManager;
    private static String backEndEndpointUrl;
    private static final String APPLICATION_NAME = "RefreshTokenTestAPI-Application";

    @Factory(dataProvider="userModeDataProvider")
    public RefreshTokenTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        backEndEndpointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        this.serverConfigurationManager = new ServerConfigurationManager(new AutomationContext("APIM", "gateway-wrk", TestUserMode.SUPER_TENANT_ADMIN));
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiStore = new APIStoreRestClient(storeURLHttp);
    }

    @Test(groups={"wso2.am"}, description="Test Refresh token functionality")
    public void testRefreshTokenAPITestCase() throws Exception {
        String apiName = "RefreshTokenTestAPI";
        String apiContext = "refreshTokenTestAPI";
        String tags = "sample, token, media";
        String description = "This is test API create by API manager integration test";
        String apiVersion = "1.0.0";
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(backEndEndpointUrl));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(apiVersion);
        apiRequest.setSandbox(backEndEndpointUrl);
        apiRequest.setProvider(this.user.getUserName());
        this.apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(apiName, this.user.getUserName(), APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.apiStore.addApplication(APPLICATION_NAME, "50PerMin", "", "this-is-test");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(apiName, this.storeContext.getContextTenant().getContextUser().getUserName());
        subscriptionRequest.setTier("Gold");
        subscriptionRequest.setApplicationName(APPLICATION_NAME);
        this.apiStore.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(APPLICATION_NAME);
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String consumerKey = response.getJSONObject("data").getJSONObject("key").getString("consumerKey");
        String consumerSecret = response.getJSONObject("data").getJSONObject("key").getString("consumerSecret");
        URL tokenEndpointURL = new URL(this.getGatewayURLNhttp() + "token");
        String subsAccessTokenPayload = APIMTestCaseUtils.getPayloadForPasswordGrant((String)this.storeContext.getContextTenant().getContextUser().getUserName(), (String)this.storeContext.getContextTenant().getContextUser().getPassword());
        JSONObject subsAccessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(consumerKey, consumerSecret, subsAccessTokenPayload, tokenEndpointURL).getData());
        String subsRefreshToken = subsAccessTokenGenerationResponse.getString("refresh_token");
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)subsRefreshToken), (String)"Refresh token of access token generated by subscriber is empty");
        String requestBody = APIMTestCaseUtils.getPayloadForPasswordGrant((String)this.user.getUserName(), (String)this.user.getPassword());
        JSONObject accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
        String userAccessToken = accessTokenGenerationResponse.getString("access_token");
        String refreshToken = accessTokenGenerationResponse.getString("refresh_token");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + userAccessToken);
        requestHeaders.put("accept", "text/xml");
        String apiUrl = this.getAPIInvocationURLHttp("refreshTokenTestAPI/1.0.0/customers/123");
        HttpResponse httpResponse = HttpRequestUtil.doGet((String)apiUrl, requestHeaders);
        Thread.sleep(5000L);
        httpResponse = HttpRequestUtil.doGet((String)apiUrl, requestHeaders);
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("John"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("<name>"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("<Customer>"), (String)"Response data mismatched");
        String getAccessTokenFromRefreshTokenRequestBody = "grant_type=refresh_token&refresh_token=" + refreshToken + "&scope=PRODUCTION";
        accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(consumerKey, consumerSecret, getAccessTokenFromRefreshTokenRequestBody, tokenEndpointURL).getData());
        userAccessToken = accessTokenGenerationResponse.getString("access_token");
        requestHeaders = new HashMap();
        requestHeaders.put("Authorization", "Bearer " + userAccessToken);
        requestHeaders.put("accept", "text/xml");
        httpResponse = HttpRequestUtil.doGet((String)apiUrl, requestHeaders);
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("John"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("<name"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)httpResponse.getData().contains("<Customer>"), (String)"Response data mismatched");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication(APPLICATION_NAME);
        super.cleanUp();
    }
}

