/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.token;

import java.net.URL;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class TokenAPITestCase
extends APIMIntegrationBaseTest {
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private static final Log log = LogFactory.getLog(TokenAPITestCase.class);

    @Factory(dataProvider="userModeDataProvider")
    public TokenAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.apiPublisher = new APIPublisherRestClient(this.getPublisherURLHttp());
        this.apiStore = new APIStoreRestClient(this.getStoreURLHttp());
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
    }

    @Test(groups={"wso2.am"}, description="Token API Test other")
    public void testTokenAPITestCase() throws Exception {
        String APIName = "TokenTestAPI";
        String APIContext = "tokenTestAPI";
        String tags = "youtube, token, media";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        String description = "This is test API create by API manager integration test";
        String providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url), new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setSandbox(url);
        apiRequest.setProvider(this.user.getUserName());
        this.apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        String gatewayUrl = this.getAPIInvocationURLHttp("tokenTestAPI/1.0.0/customers/123");
        this.apiStore.addApplication("TokenTestAPI-Application", "Unlimited", "", "this-is-test");
        String provider = this.storeContext.getContextTenant().getContextUser().getUserName();
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(APIName, provider);
        subscriptionRequest.setTier("Gold");
        subscriptionRequest.setApplicationName("TokenTestAPI-Application");
        this.apiStore.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequestSandBox = new APPKeyRequestGenerator("TokenTestAPI-Application");
        generateAppKeyRequestSandBox.setKeyType("SANDBOX");
        String responseStringSandBox = this.apiStore.generateApplicationKey(generateAppKeyRequestSandBox).getData();
        JSONObject responseSandBOX = new JSONObject(responseStringSandBox);
        String SANDbOXAccessToken = responseSandBOX.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeadersSandBox = new HashMap<String, String>();
        requestHeadersSandBox.put("Authorization", "Bearer " + SANDbOXAccessToken);
        HttpResponse youTubeResponseSandBox = HttpRequestUtil.doGet((String)gatewayUrl, requestHeadersSandBox);
        log.info((Object)("Response " + youTubeResponseSandBox));
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("TokenTestAPI-Application");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        String consumerKey = response.getJSONObject("data").getJSONObject("key").getString("consumerKey");
        String consumerSecret = response.getJSONObject("data").getJSONObject("key").getString("consumerSecret");
        Thread.sleep(2000L);
        String requestBody = "grant_type=password&username=" + this.user.getUserName() + "&password=admin&scope=PRODUCTION";
        URL tokenEndpointURL = new URL(this.getGatewayURLNhttp() + "token");
        JSONObject accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
        String userAccessToken = accessTokenGenerationResponse.getString("access_token");
        String refreshToken = accessTokenGenerationResponse.getString("refresh_token");
        log.info((Object)refreshToken);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + userAccessToken);
        requestHeaders.put("accept", "text/xml");
        Thread.sleep(2000L);
        HttpResponse youTubeResponse = HttpRequestUtil.doGet((String)gatewayUrl, requestHeaders);
        Assert.assertEquals((int)youTubeResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("John"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("<name"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("<Customer>"), (String)"Response data mismatched");
        requestHeaders.clear();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        HttpResponse youTubeResponseWithApplicationToken = HttpRequestUtil.doGet((String)gatewayUrl, requestHeaders);
        Assert.assertEquals((int)youTubeResponseWithApplicationToken.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Assert.assertTrue((boolean)youTubeResponseWithApplicationToken.getData().contains("John"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponseWithApplicationToken.getData().contains("<name>"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponseWithApplicationToken.getData().contains("<Customer>"), (String)"Response data mismatched");
        HttpResponse youTubeResponseWithApplicationTokenHttps = HttpRequestUtil.doGet((String)gatewayUrl, requestHeaders);
        log.info((Object)("Response " + youTubeResponseWithApplicationTokenHttps));
        Assert.assertEquals((int)youTubeResponseWithApplicationTokenHttps.getResponseCode(), (int)200, (String)"Response code mismatched");
        HttpResponse errorResponse = null;
        errorResponse = HttpRequestUtil.doGet((String)gatewayUrl, requestHeaders);
        log.info((Object)("Error response " + errorResponse));
        this.apiPublisher.revokeAccessToken(accessToken, consumerKey, providerName);
        requestHeaders.clear();
        requestHeaders.put("Authorization", "Bearer this-is-incorrect-token");
        requestHeaders.put("accept", "text/xml");
        errorResponse = HttpRequestUtil.doGet((String)gatewayUrl, requestHeaders);
        Assert.assertEquals((int)errorResponse.getResponseCode(), (int)401, (String)"Response code mismatched while token API test case");
        try {
            errorResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp("tokenTestAPI/1.0.0/most_popular"), requestHeaders);
            log.info((Object)("Error Response " + errorResponse));
        }
        catch (Exception e) {
            // empty catch block
        }
        Assert.assertEquals((int)errorResponse.getResponseCode(), (int)401, (String)"Response code mismatched while token API test case");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication("TokenTestAPI-Application");
        super.cleanUp();
    }
}

