/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.ApplicationKeyBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIInvocationWithSimilarResourcesAndDifferentVerbsTestCase
extends APIManagerLifecycleBaseTest {
    private static final String API_NAME = "MultiVerbSimilarResourceAPI";
    private static final String API_CONTEXT = "multiVerbSimilarResourceAPI";
    private static final String API_END_POINT_POSTFIX_URL = "multiVSR/";
    private static final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private static final String API_VERSION_1_0_0 = "1.0.0";
    private static final String RESPONSE_GET = "<response><value>Received GET /comp/cartes*</value></response>";
    private static final String RESPONSE_POST = "<response><value>Received POST /comp/cartes/op*</value></response>";
    private static final String API_ENDPOINT_RESOURCE = "/comp/cartes/op/123";
    private String APPLICATION_NAME = "MultiVerbSimilarResourceApp";
    private APIPublisherRestClient apiPublisherClientUser1;
    private String apiEndPointUrl;
    private APIStoreRestClient apiStoreClientUser1;
    private String providerName;
    private APIIdentifier apiIdentifier;
    private HashMap<String, String> requestHeaders;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLNhttp() + API_END_POINT_POSTFIX_URL;
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStoreClientUser1.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.requestHeaders = new HashMap();
        String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "dummy-api-multiResourceSameVerb.xml", this.gatewayContextMgt, gatewaySessionCookie);
    }

    @Test(groups={"wso2.am"}, description="Invoke all resources and verbs that are valid")
    public void testInvokeAllResources() throws Exception {
        this.apiStoreClientUser1.addApplication(this.APPLICATION_NAME, "Unlimited", "", "");
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(API_NAME, API_CONTEXT, API_VERSION_1_0_0, this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setDescription(API_DESCRIPTION);
        apiCreationRequestBean.setVisibility("public");
        ArrayList<APIResourceBean> apiResourceBeansList = new ArrayList<APIResourceBean>();
        APIResourceBean apiResourceBeanGET = new APIResourceBean("GET", "Application & Application User", "Unlimited", "/comp/cartes*");
        APIResourceBean apiResourceBeanPOST = new APIResourceBean("POST", "Application & Application User", "Unlimited", "/comp/cartes/op*");
        apiResourceBeansList.add(apiResourceBeanGET);
        apiResourceBeansList.add(apiResourceBeanPOST);
        apiCreationRequestBean.setResourceBeanList(apiResourceBeansList);
        this.apiIdentifier = new APIIdentifier(this.providerName, API_NAME, API_VERSION_1_0_0);
        this.createPublishAndSubscribeToAPI(this.apiIdentifier, apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, this.APPLICATION_NAME);
        ApplicationKeyBean applicationKeyBean = this.generateApplicationKeys(this.apiStoreClientUser1, this.APPLICATION_NAME);
        String accessToken = applicationKeyBean.getAccessToken();
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        HttpResponse httpResponseGet = HttpRequestUtil.doGet((String)(this.getGatewayURLNhttp() + API_CONTEXT + "/" + API_VERSION_1_0_0 + API_ENDPOINT_RESOURCE), this.requestHeaders);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request for /comp/cartes/op/123");
        Assert.assertTrue((boolean)httpResponseGet.getData().contains(RESPONSE_GET), (String)("Response Data not match for GET request for/comp/cartes/op/123 Expected value :\"<response><value>Received GET /comp/cartes*</value></response>\" not contains in response data:\"" + httpResponseGet.getData() + "\""));
        HttpResponse httpResponsePost = HttpRequestUtil.doPost((URL)new URL(this.getGatewayURLNhttp() + API_CONTEXT + "/" + API_VERSION_1_0_0 + API_ENDPOINT_RESOURCE), (String)"", this.requestHeaders);
        Assert.assertEquals((int)httpResponsePost.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for POST request for /comp/cartes/op/123");
        Assert.assertTrue((boolean)httpResponsePost.getData().contains(RESPONSE_POST), (String)("Response Data not match for POST request for auth type Application & Application User. Expected value :\"<response><value>Received GET /comp/cartes*</value></response>\" not contains in response data:\"" + httpResponsePost.getData() + "\""));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws APIManagerIntegrationTestException {
        this.apiStoreClientUser1.removeApplication(this.APPLICATION_NAME);
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
    }
}

