/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIPublishingAndVisibilityInStoreTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "APIPublishingAndVisibilityInStoreTest";
    private final String API_CONTEXT = "APIPublishingAndVisibilityInStore";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "APIPublishingAndVisibilityInStoreTestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifier;
    private String providerName;
    private APICreationRequestBean apiCreationRequestBean;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException, MalformedURLException {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("APIPublishingAndVisibilityInStoreTest", "APIPublishingAndVisibilityInStore", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiIdentifier = new APIIdentifier(this.providerName, "APIPublishingAndVisibilityInStoreTest", "1.0.0");
        this.apiStoreClientUser1.addApplication("APIPublishingAndVisibilityInStoreTestCase", "Unlimited", "", "");
    }

    @Test(groups={"wso2.am"}, description="Create a API and  check its availability in Publisher.")
    public void testAvailabilityOfAPIInPublisher() throws APIManagerIntegrationTestException {
        HttpResponse createAPIResponse = this.apiPublisherClientUser1.addAPI(this.apiCreationRequestBean);
        Assert.assertEquals((int)createAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Create API Response Code is invalid." + this.getAPIIdentifierString(this.apiIdentifier)));
        Assert.assertEquals((String)this.getValueFromJSON(createAPIResponse, "error"), (String)"false", (String)("Error in API Creation in " + this.getAPIIdentifierString(this.apiIdentifier) + "Response Data:" + createAPIResponse.getData()));
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisherClientUser1.getApi("APIPublishingAndVisibilityInStoreTest", this.providerName, "1.0.0"));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiPublisherAPIIdentifierList), (String)("Added Api is not available in APi Publisher. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Check the visibility of API in Store before the API publish. it should not be available in store.", dependsOnMethods={"testAvailabilityOfAPIInPublisher"})
    public void testVisibilityOfAPIInStoreBeforePublishing() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientUser1.getAPI());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("Api is visible in API Store before publish." + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the API publishing action. Response HTTP message should contains API status change from  CREATED to PUBLISHED", dependsOnMethods={"testVisibilityOfAPIInStoreBeforePublishing"})
    public void testAPIPublishing() throws APIManagerIntegrationTestException, XPathExpressionException {
        HttpResponse publishAPIResponse = this.apiPublisherClientUser1.changeAPILifeCycleStatusToPublish(this.apiIdentifier, false);
        Assert.assertEquals((int)publishAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("API publish Response code is invalid " + this.getAPIIdentifierString(this.apiIdentifier)));
        Assert.assertTrue((boolean)this.verifyAPIStatusChange(publishAPIResponse, APILifeCycleState.CREATED, APILifeCycleState.PUBLISHED), (String)("API status Change is invalid in" + this.getAPIIdentifierString(this.apiIdentifier) + "Response Data:" + publishAPIResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in the store after API publish.", dependsOnMethods={"testAPIPublishing"})
    public void testVisibilityOfAPIInStoreAfterPublishing() throws APIManagerIntegrationTestException {
        this.waitForAPIDeploymentSync(this.apiCreationRequestBean.getProvider(), this.apiCreationRequestBean.getName(), "1.0.0", "\"isApiExists\":true");
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientUser1.getAPI());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("Api is not visible in API Store after publish. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.apiStoreClientUser1.removeApplication("APIPublishingAndVisibilityInStoreTestCase");
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
        super.cleanUp();
    }
}

