/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APITagVisibilityByRoleTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(APITagVisibilityByRoleTestCase.class);
    private APIStoreRestClient apiStore;
    private String storeURLHttp;
    private String publisherURLHttp;
    private APIPublisherRestClient apiPublisher;
    private URL tagListUrl;
    private UserManagementClient userManagementClient1;
    private APIRequest apiRequestPublic;
    private APIRequest apiRequestRestricted;
    private String endpointUrl;
    private String apiNamePublic = "APITagVisibilityByRoleTestCaseAPIName1";
    private String APIContextPublic = "APITagVisibilityByRoleTestCaseContext1";
    private String apiNameRestricted = "APITagVisibilityByRoleTestCaseAPIName2";
    private String APIContextRestricted = "APITagVisibilityByRoleTestCaseContext2";
    private String tagsPublic = "APITagVisibilityPublicTag";
    private String tagsRestricted = "APITagVisibilityRestrictedTag";
    private String description = "This is test API create by APIM APITagVisibilityByRoleTestCase";
    private String APIVersion = "1.0.0";
    private String allowedUser = "APITagVisibilityByRoleUser";
    private char[] allowedUserPass = "password@123".toCharArray();
    private String role = "APITagVisibilityRole1";
    private String[] permissions = new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"};
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private static final long WAIT_TIME = 45000L;

    @Factory(dataProvider="userModeDataProvider")
    public APITagVisibilityByRoleTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.publisherURLHttp = this.getPublisherURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api/add";
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.createSession(this.keyManagerContext));
        this.userManagementClient1.addRole(this.role, null, this.permissions);
        this.userManagementClient1.addUser(this.allowedUser, String.valueOf(this.allowedUserPass), new String[]{this.role}, null);
        this.tagListUrl = new URL(this.getStoreURLHttp() + "store/site/blocks/tag/tag-cloud/ajax/list.jag");
    }

    @Test(groups={"wso2.am"}, description="Create and publish two apis with public and role based visibility")
    public void testAPICreationWithVisibility() throws Exception {
        String providerName = this.user.getUserName();
        this.apiRequestPublic = new APIRequest(this.apiNamePublic, this.APIContextPublic, new URL(this.endpointUrl));
        this.apiRequestPublic.setTags(this.tagsPublic);
        this.apiRequestPublic.setDescription(this.description);
        this.apiRequestPublic.setVersion(this.APIVersion);
        this.apiRequestPublic.setProvider(providerName);
        this.apiRequestRestricted = new APIRequest(this.apiNameRestricted, this.APIContextRestricted, new URL(this.endpointUrl));
        this.apiRequestRestricted.setTags(this.tagsRestricted);
        this.apiRequestRestricted.setDescription(this.description);
        this.apiRequestRestricted.setVersion(this.APIVersion);
        this.apiRequestRestricted.setProvider(providerName);
        this.apiRequestRestricted.setVisibility("restricted");
        this.apiRequestRestricted.setRoles(this.role);
        HttpResponse serviceResponse = this.apiPublisher.addAPI(this.apiRequestPublic);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(this.apiNamePublic, this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        serviceResponse = this.apiPublisher.addAPI(this.apiRequestRestricted);
        this.verifyResponse(serviceResponse);
        updateRequest = new APILifeCycleStateRequest(this.apiNameRestricted, this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
    }

    @Test(groups={"wso2.am"}, description="Test the API tag visibility as a anonymous user", dependsOnMethods={"testAPICreationWithVisibility"})
    public void testAPITagVisibilityAnonymousUser() throws Exception {
        this.requestHeaders.clear();
        String tenant = this.user.getUserDomain();
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        urlParameters.add(new BasicNameValuePair("action", "getAllTags"));
        urlParameters.add(new BasicNameValuePair("tenant", tenant));
        UrlEncodedFormEntity content = new UrlEncodedFormEntity(urlParameters);
        String contentString = EntityUtils.toString((HttpEntity)content);
        this.watForTagsAvailableOnSearchApi(this.tagsRestricted);
        HttpResponse serviceResponse = HttpRequestUtil.doPost((URL)this.tagListUrl, (String)contentString, this.requestHeaders);
        Assert.assertTrue((boolean)serviceResponse.getData().contains(this.tagsPublic), (String)"Public visibility tag is not available for anonymous user");
        Assert.assertFalse((boolean)serviceResponse.getData().contains(this.tagsRestricted), (String)"Restricted visibility tag is available for anonymous user");
    }

    @Test(groups={"wso2.am"}, description="Test the API tag visibility as a authorised user", dependsOnMethods={"testAPITagVisibilityAnonymousUser"})
    public void testAPITagVisibilityAuthorisedUser() throws Exception {
        String tenant = this.user.getUserDomain();
        String currentUser = this.allowedUser;
        if ("wso2.com".equals(tenant)) {
            currentUser = currentUser + '@' + tenant;
        }
        HttpResponse response = this.apiStore.login(currentUser, String.valueOf(this.allowedUserPass));
        String cookie = (String)response.getHeaders().get("Set-Cookie");
        this.requestHeaders.put("Cookie", cookie);
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        urlParameters.add(new BasicNameValuePair("action", "getAllTags"));
        urlParameters.add(new BasicNameValuePair("tenant", tenant));
        UrlEncodedFormEntity content = new UrlEncodedFormEntity(urlParameters);
        String contentString = EntityUtils.toString((HttpEntity)content);
        Thread.sleep(5000L);
        HttpResponse serviceResponse = HttpRequestUtil.doPost((URL)this.tagListUrl, (String)contentString, this.requestHeaders);
        Assert.assertTrue((boolean)serviceResponse.getData().contains(this.tagsPublic), (String)"Public visibility tag is not available for authorised user");
        Assert.assertTrue((boolean)serviceResponse.getData().contains(this.tagsRestricted), (String)"Restricted visibility tag is not available for authorised user");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiPublisher.deleteAPI(this.apiNamePublic, this.APIVersion, this.user.getUserName());
        this.apiPublisher.deleteAPI(this.apiNameRestricted, this.APIVersion, this.user.getUserName());
        this.userManagementClient1.deleteRole(this.role);
        this.userManagementClient1.deleteUser(this.allowedUser);
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    public void watForTagsAvailableOnSearchApi(String tag) throws Exception {
        long waitTime = System.currentTimeMillis() + 45000L;
        while (waitTime > System.currentTimeMillis()) {
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            urlParameters.add(new BasicNameValuePair("action", "getAllTags"));
            urlParameters.add(new BasicNameValuePair("tenant", this.user.getUserDomain()));
            UrlEncodedFormEntity content = new UrlEncodedFormEntity(urlParameters);
            String contentString = EntityUtils.toString((HttpEntity)content);
            HashMap requestHeaders = new HashMap();
            HttpResponse response = HttpRequestUtil.doPost((URL)this.tagListUrl, (String)contentString, requestHeaders);
            this.verifyResponse(response);
            this.log.info((Object)("WAIT for availability of tags : " + tag + " found on Store tag cloud"));
            if (response == null) continue;
            this.log.info((Object)("Data: " + response.getData()));
            if (response.getData().contains(tag)) {
                this.log.info((Object)("Tag :" + tag + " found"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

