/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class AccessibilityOfDeprecatedOldAPIAndPublishedCopyAPITestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "DeprecatedAPITest";
    private final String API_CONTEXT = "DeprecatedAPI";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_END_POINT_METHOD = "/customers/123";
    private final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String API_VERSION_2_0_0 = "2.0.0";
    private final String APPLICATION_NAME = "AccessibilityOfDeprecatedOldAPIAndPublishedCopyAPITestCase";
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifierAPI1Version1;
    private APIIdentifier apiIdentifierAPI1Version2;
    private String providerName;
    private APICreationRequestBean apiCreationRequestBean;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private APIStoreRestClient apiStoreClientUser2;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException, MalformedURLException {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("DeprecatedAPITest", "DeprecatedAPI", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiIdentifierAPI1Version1 = new APIIdentifier(this.providerName, "DeprecatedAPITest", "1.0.0");
        this.apiIdentifierAPI1Version2 = new APIIdentifier(this.providerName, "DeprecatedAPITest", "2.0.0");
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser2 = new APIStoreRestClient(storeURLHttp);
        this.apiStoreClientUser2.login(((User)this.storeContext.getContextTenant().getTenantUserList().get(0)).getUserName(), ((User)this.storeContext.getContextTenant().getTenantUserList().get(0)).getPassword());
        this.apiStoreClientUser1.addApplication("AccessibilityOfDeprecatedOldAPIAndPublishedCopyAPITestCase", "Unlimited", "", "");
    }

    @Test(groups={"wso2.am"}, description="Test subscribe of old API version before deprecate the old version")
    public void testSubscribeOldVersionBeforeDeprecate() throws APIManagerIntegrationTestException {
        this.createAndPublishAPI(this.apiIdentifierAPI1Version1, this.apiCreationRequestBean, this.apiPublisherClientUser1, false);
        this.copyAndPublishCopiedAPI(this.apiIdentifierAPI1Version1, "2.0.0", this.apiPublisherClientUser1, false);
        HttpResponse oldVersionSubscribeResponse = this.subscribeToAPI(this.apiIdentifierAPI1Version1, "AccessibilityOfDeprecatedOldAPIAndPublishedCopyAPITestCase", this.apiStoreClientUser1);
        Assert.assertEquals((int)oldVersionSubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version request not successful " + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1)));
        Assert.assertEquals((String)this.getValueFromJSON(oldVersionSubscribeResponse, "error"), (String)"false", (String)("Error in subscribe of old API version" + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1) + "Response Data:" + oldVersionSubscribeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test subscribe of new API version before deprecate the old version", dependsOnMethods={"testSubscribeOldVersionBeforeDeprecate"})
    public void testSubscribeNewVersion() throws APIManagerIntegrationTestException {
        HttpResponse newVersionSubscribeResponse = this.subscribeToAPI(this.apiIdentifierAPI1Version2, "AccessibilityOfDeprecatedOldAPIAndPublishedCopyAPITestCase", this.apiStoreClientUser1);
        Assert.assertEquals((int)newVersionSubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version request not successful " + this.getAPIIdentifierString(this.apiIdentifierAPI1Version2)));
        Assert.assertEquals((String)this.getValueFromJSON(newVersionSubscribeResponse, "error"), (String)"false", (String)("Error in subscribe of old API version" + this.getAPIIdentifierString(this.apiIdentifierAPI1Version2) + "Response Data:" + newVersionSubscribeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test deprecate old api version", dependsOnMethods={"testSubscribeNewVersion"})
    public void testDeprecateOldVersion() throws APIManagerIntegrationTestException {
        APILifeCycleStateRequest deprecatedUpdateRequest = new APILifeCycleStateRequest("DeprecatedAPITest", this.providerName, APILifeCycleState.DEPRECATED);
        deprecatedUpdateRequest.setVersion("1.0.0");
        HttpResponse deprecateAPIResponse = this.apiPublisherClientUser1.changeAPILifeCycleStatus(deprecatedUpdateRequest);
        Assert.assertEquals((int)deprecateAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("API deprecate Response code is invalid " + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1)));
        Assert.assertTrue((boolean)this.verifyAPIStatusChange(deprecateAPIResponse, APILifeCycleState.PUBLISHED, APILifeCycleState.DEPRECATED), (String)("API deprecate status Change is invalid in" + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1) + "Response Data:" + deprecateAPIResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in the store after API deprecate.", dependsOnMethods={"testDeprecateOldVersion"})
    public void testVisibilityOfOldAPIInStoreAfterDeprecate() throws APIManagerIntegrationTestException, IOException, XPathExpressionException {
        this.waitForAPIDeploymentSync(this.user.getUserName(), this.apiIdentifierAPI1Version1.getApiName(), this.apiIdentifierAPI1Version1.getVersion(), "\"isApiExists\":true");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "DeprecatedAPITest", "2.0.0", "\"isApiExists\":true");
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientUser1.getAPI());
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in the store after API deprecate.", dependsOnMethods={"testVisibilityOfOldAPIInStoreAfterDeprecate"})
    public void testVisibilityOfNewAPIInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientUser1.getAPI());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierAPI1Version2, (List)apiStoreAPIIdentifierList), (String)("New API version is not visible in API Store after deprecate the old version." + this.getAPIIdentifierString(this.apiIdentifierAPI1Version2)));
    }

    @Test(groups={"wso2.am"}, description="Test the subscription of deprecated API version.", dependsOnMethods={"testVisibilityOfNewAPIInStore"})
    public void testSubscribeOldVersionAfterDeprecate() throws APIManagerIntegrationTestException {
        HttpResponse oldVersionSubscribeResponse = this.subscribeToAPI(this.apiIdentifierAPI1Version1, "AccessibilityOfDeprecatedOldAPIAndPublishedCopyAPITestCase", this.apiStoreClientUser2);
        Assert.assertEquals((int)oldVersionSubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version  after deprecate response code is invalid." + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1)));
        Assert.assertEquals((String)this.getValueFromJSON(oldVersionSubscribeResponse, "error"), (String)"true", (String)("Subscribe of old API version  after deprecate success, which should fail." + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1) + "Response Data:" + oldVersionSubscribeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test the invocation of both deprecated old and  publish new API versions", dependsOnMethods={"testSubscribeOldVersionAfterDeprecate"})
    public void testAccessibilityOfDeprecateOldAPIAndPublishedCopyAPI() throws Exception {
        String accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, "AccessibilityOfDeprecatedOldAPIAndPublishedCopyAPITestCase").getAccessToken();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("DeprecatedAPI", "1.0.0") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)"Response data mismatched");
        HttpResponse newVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("DeprecatedAPI", "2.0.0") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)newVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched");
        Assert.assertTrue((boolean)newVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)"Response data mismatched");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws APIManagerIntegrationTestException {
        this.apiStoreClientUser1.removeApplication("AccessibilityOfDeprecatedOldAPIAndPublishedCopyAPITestCase");
        this.deleteAPI(this.apiIdentifierAPI1Version1, this.apiPublisherClientUser1);
        this.deleteAPI(this.apiIdentifierAPI1Version2, this.apiPublisherClientUser1);
    }
}

