/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class AddEditRemoveRESTResourceTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String INVOKABLE_API_CONTEXT = "1.0.0/api";
    private final String RESPONSE_GET = "<id>123</id><name>John</name></Customer>";
    private final String RESPONSE_POST = "Tom";
    private final String API_GET_ENDPOINT_METHOD = "/customers/123";
    private final String API_POST_ENDPOINT_METHOD = "/customers/name/";
    private final String INVALID_URL = "/invalid";
    private final String INVALID_RESOURCE_INVOCATION = "No matching resource found for given API Request";
    private String apiEndPointUrl;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private String providerName;
    private String postEndPointURL;
    private HashMap<String, String> requestHeadersGet;
    private HashMap<String, String> requestHeadersPost;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException, RemoteException, MalformedURLException {
        super.init();
        this.postEndPointURL = this.getAPIInvocationURLHttp("1.0.0/api") + "/customers/name/";
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.requestHeadersGet = new HashMap();
        this.requestHeadersGet.put("accept", "text/xml");
        this.requestHeadersPost = new HashMap();
        this.requestHeadersPost.put("accept", "text/plain");
        this.requestHeadersPost.put("Content-Type", "text/plain");
    }

    @Test(groups={"webapp"}, description="Test the invocation of GET resource")
    public void testInvokeGETResource() throws Exception {
        String accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, "ApplicationTest").getAccessToken();
        System.setProperty("ApplicationTest-accessToken", accessToken);
        this.requestHeadersGet.put("Authorization", "Bearer " + accessToken);
        this.requestHeadersPost.put("Authorization", "Bearer " + accessToken);
        HttpResponse httpResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("1.0.0/api") + "/customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        Assert.assertTrue((boolean)httpResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response Data not match for GET request. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponse.getData() + "\""));
    }

    @Test(groups={"webapp"}, description="Test the invocation of POST resource, before adding a POSt resource", dependsOnMethods={"testInvokeGETResource"})
    public void testInvokePOSTResourceBeforeAddingPOSTResource() throws APIManagerIntegrationTestException, MalformedURLException {
        String exceptionMessage = "";
        try {
            HttpRequestUtil.doPost((URL)new URL(this.postEndPointURL), (String)"id=25", this.requestHeadersPost);
        }
        catch (AutomationFrameworkException e) {
            exceptionMessage = e.getMessage();
        }
        finally {
            Assert.assertTrue((boolean)exceptionMessage.contains("Server returned HTTP response code: 405"), (String)("Not Return IOException with 405 when accessing a POST resource which is not define yet. " + exceptionMessage));
            Assert.assertTrue((boolean)exceptionMessage.contains("1.0.0/api"), (String)("API Context is not in error message " + exceptionMessage));
        }
    }

    @Test(groups={"webapp"}, description="Test the invocation of POST and GET resource, after adding a POST resource", dependsOnMethods={"testInvokePOSTResourceBeforeAddingPOSTResource"})
    public void testInvokePOSTAndGETResourceAfterAddingPOSTResource() throws Exception {
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APITest", "{version}/api", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        ArrayList<APIResourceBean> apiResourceBeansList = new ArrayList<APIResourceBean>();
        APIResourceBean apiResourceBeanGET = new APIResourceBean("GET", "Application & Application User", "Unlimited", "/*");
        APIResourceBean apiResourceBeanPOST = new APIResourceBean("POST", "Application & Application User", "Unlimited", "/*");
        apiResourceBeansList.add(apiResourceBeanGET);
        apiResourceBeansList.add(apiResourceBeanPOST);
        apiCreationRequestBean.setResourceBeanList(apiResourceBeansList);
        HttpResponse updateAPIHTTPResponse = this.apiPublisherClientUser1.updateAPI(apiCreationRequestBean);
        Assert.assertEquals((int)updateAPIHTTPResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Update APi with new Resource information fail");
        Assert.assertEquals((String)this.getValueFromJSON(updateAPIHTTPResponse, "error"), (String)"false", (String)"Update APi with new Resource information fail");
        this.waitForAPIDeployment();
        HttpResponse httpResponseGet = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("1.0.0/api") + "/customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request after update the api with  both GET and POST resource");
        Assert.assertTrue((boolean)httpResponseGet.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response Data not match for GET request after update the api with  both GET and POST resource. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponseGet.getData() + "\""));
        HttpResponse httpResponsePOST = HttpRequestUtil.doPost((URL)new URL(this.getAPIInvocationURLHttp("1.0.0/api") + "/customers/name/"), (String)"id=25", this.requestHeadersPost);
        Assert.assertEquals((int)httpResponsePOST.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation of  POST resource fail after update the api with  both GET and POST resource");
        Assert.assertTrue((boolean)httpResponsePOST.getData().contains("Tom"), (String)("Invocation of  POST resource fail after update the api with both GET and POST resource. Expected value :\"Tom\" not contains in response data:\"" + httpResponsePOST.getData() + "\""));
    }

    @Test(groups={"webapp"}, description="Test the invocation of POST and GET resource, after adding a URL pattern", dependsOnMethods={"testInvokePOSTAndGETResourceAfterAddingPOSTResource"})
    public void testInvokePOSTAndGetResourceAfterAddingURLPattern() throws Exception {
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APITest", "{version}/api", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        apiCreationRequestBean.setVisibility("public");
        ArrayList<APIResourceBean> apiResourceBeansList = new ArrayList<APIResourceBean>();
        APIResourceBean apiResourceBeanGET = new APIResourceBean("GET", "Application & Application User", "Unlimited", "/customers/{id}");
        APIResourceBean apiResourceBeanPOST = new APIResourceBean("POST", "Application & Application User", "Unlimited", "/customers/name");
        apiResourceBeansList.add(apiResourceBeanGET);
        apiResourceBeansList.add(apiResourceBeanPOST);
        apiCreationRequestBean.setResourceBeanList(apiResourceBeansList);
        HttpResponse updateAPIHTTPResponse = this.apiPublisherClientUser1.updateAPI(apiCreationRequestBean);
        this.waitForAPIDeployment();
        Assert.assertEquals((int)updateAPIHTTPResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Update APi with new Resource information fail");
        Assert.assertEquals((String)this.getValueFromJSON(updateAPIHTTPResponse, "error"), (String)"false", (String)"Update APi with new Resource information fail");
        HttpResponse httpResponseGet = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("1.0.0/api") + "/customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request after update the api with  URLPattern");
        Assert.assertTrue((boolean)httpResponseGet.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response Data not match for GET request after update the api with  URLPattern. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponseGet.getData() + "\""));
        HttpResponse httpResponseGetInvalidUrl = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("1.0.0/api") + "/customers/123" + "/invalid"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGetInvalidUrl.getResponseCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)"Invocation is not forbidden when try to invoke GET resource  via invalid url pattern");
        Assert.assertTrue((boolean)httpResponseGetInvalidUrl.getData().contains("No matching resource found for given API Request"), (String)("Invocation is not forbidden when try to invoke GET resource  via invalid url pattern. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponseGetInvalidUrl.getData() + "\""));
        HttpResponse httpResponsePOST = HttpRequestUtil.doPost((URL)new URL(this.getAPIInvocationURLHttp("1.0.0/api") + "/customers/name/"), (String)"id=25", this.requestHeadersPost);
        Assert.assertEquals((int)httpResponsePOST.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation of  POST resource fail after update the api with  URLPattern");
        Assert.assertTrue((boolean)httpResponsePOST.getData().contains("Tom"), (String)("Invocation of  POST resource fail after update the api with  URLPattern. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponsePOST.getData() + "\""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"webapp"}, description="Test the invocation of POST and GET resource, after Remove POST resource", dependsOnMethods={"testInvokePOSTAndGetResourceAfterAddingURLPattern"})
    public void testInvokeGETAndPOSTResourceAfterRemovePOSTResource() throws Exception {
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APITest", "{version}/api", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        apiCreationRequestBean.setVisibility("public");
        ArrayList<APIResourceBean> apiResourceBeansList = new ArrayList<APIResourceBean>();
        APIResourceBean apiResourceBeanGET = new APIResourceBean("GET", "Application & Application User", "Unlimited", "/*");
        apiResourceBeansList.add(apiResourceBeanGET);
        apiCreationRequestBean.setResourceBeanList(apiResourceBeansList);
        HttpResponse updateAPIHTTPResponse = this.apiPublisherClientUser1.updateAPI(apiCreationRequestBean);
        Assert.assertEquals((int)updateAPIHTTPResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Update APi with new Resource information fail");
        Assert.assertEquals((String)this.getValueFromJSON(updateAPIHTTPResponse, "error"), (String)"false", (String)"Update APi with new Resource information fail");
        this.waitForAPIDeployment();
        HttpResponse httpResponseGet = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("1.0.0/api") + "/customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request after remove the POST resource from api");
        Assert.assertTrue((boolean)httpResponseGet.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response Data not match for GET request after remove the POST resource from api. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponseGet.getData() + "\""));
        String exceptionMessage = "";
        try {
            HttpRequestUtil.doPost((URL)new URL(this.postEndPointURL), (String)"id=25", this.requestHeadersPost);
        }
        catch (Exception e) {
            exceptionMessage = e.getMessage();
        }
        finally {
            Assert.assertTrue((boolean)exceptionMessage.contains("Server returned HTTP response code: 405"), (String)("Not Return IOException with 405 when accessing a POST resource after deleting the POST resource from API. " + exceptionMessage));
            Assert.assertTrue((boolean)exceptionMessage.contains("1.0.0/api"), (String)("API Context is not in error message " + exceptionMessage));
        }
    }
}

