/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.File;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.mediation.SynapseConfigAdminClient;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.common.FileManager;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.LogViewerClient;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;
import org.wso2.carbon.logging.view.stub.LogViewerLogViewerException;
import org.wso2.carbon.logging.view.stub.types.carbon.LogEvent;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class AddNewHandlerAndInvokeAPITestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(AddNewHandlerAndInvokeAPITestCase.class);
    private static final String API_NAME = "AddNewHandlerAndInvokeAPITest";
    private static final String API_CONTEXT = "AddNewHandlerAndInvokeAPI";
    private static final String API_TAGS = "testTag1, testTag2, testTag3";
    private static final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private static final String API_VERSION_1_0_0 = "1.0.0";
    private static final String APPLICATION_NAME = "AddNewHandlerAndInvokeAPI";
    private static final String RESPONSE_GET = "I was at CustomAPIAuthenticationHandler";
    private static final String EXPECTED_HANDLER_LOG_OUTPUT = "I am at CustomAPIAuthenticationHandler:CustomAuthKey 123456789";
    private static final String API_GET_ENDPOINT_METHOD = "/handler";
    private static final String CUSTOM_AUTHORIZATION = "CustomAuthKey 123456789";
    private static final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private static final String CUSTOM_AUTH_HANDLER_JAR = "CustomAPIAuthenticationHandler-1.0.0.jar";
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private String providerName;
    private String newSynapseConfig;
    private APIIdentifier apiIdentifier;
    private SynapseConfigAdminClient synapseConfigAdminClient;
    private String gatewaySession;
    private String apiEndPointUrl;
    private ServerConfigurationManager serverConfigurationManager;
    private String customHandlerTargetPath;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        String synapseConfigArtifactsPath = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + "synapseconfig.xml";
        this.newSynapseConfig = this.readFile(synapseConfigArtifactsPath);
        String customHandlerSourcePath = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + CUSTOM_AUTH_HANDLER_JAR;
        this.customHandlerTargetPath = CARBON_HOME + File.separator + "repository" + File.separator + "components" + File.separator + "lib";
        FileManager.copyResourceToFileSystem((String)customHandlerSourcePath, (String)this.customHandlerTargetPath, (String)CUSTOM_AUTH_HANDLER_JAR);
        this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
        String log4jPropertiesFile = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + "log4j.properties";
        String log4jPropertiesTargetLocation = CARBON_HOME + File.separator + "repository" + File.separator + "conf" + File.separator + "log4j.properties";
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(log4jPropertiesFile), new File(log4jPropertiesTargetLocation), true);
        this.serverConfigurationManager.restartGracefully();
        super.init();
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStoreClientUser1.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.gatewaySession = this.createSession(this.gatewayContextMgt);
        this.synapseConfigAdminClient = new SynapseConfigAdminClient(this.gatewayContextMgt.getContextUrls().getBackEndUrl(), this.gatewaySession);
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + API_END_POINT_POSTFIX_URL;
    }

    @Test(groups={"wso2.am"}, description="Invoke the APi and check the  API request is going through the new handler.")
    public void testAPIInvocationHitsTheNewHandler() throws Exception, XMLStreamException, LogViewerLogViewerException {
        this.apiStoreClientUser1.addApplication("AddNewHandlerAndInvokeAPI", "Gold", "", "");
        this.apiIdentifier = new APIIdentifier(this.providerName, API_NAME, API_VERSION_1_0_0);
        this.apiIdentifier.setTier("Gold");
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(API_NAME, "AddNewHandlerAndInvokeAPI", API_VERSION_1_0_0, this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags(API_TAGS);
        apiCreationRequestBean.setDescription(API_DESCRIPTION);
        this.createPublishAndSubscribeToAPI(this.apiIdentifier, apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, "AddNewHandlerAndInvokeAPI");
        this.synapseConfigAdminClient.updateConfiguration(this.newSynapseConfig);
        long startTime = System.currentTimeMillis();
        long maxWaitTimeForConfigPersist = 60000L;
        while (!this.synapseConfigAdminClient.getConfiguration().contains("<handler class=\"org.test.apim.coustom.handler.CustomAPIAuthenticationHandler\"/>") && System.currentTimeMillis() - startTime < maxWaitTimeForConfigPersist) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.warn((Object)"InterruptedException occurs while sleeping 500 milliseconds");
            }
        }
        HashMap<String, String> requestHeadersGet = new HashMap<String, String>();
        requestHeadersGet.put("Content-Type", "text/plain");
        String accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, "AddNewHandlerAndInvokeAPI").getAccessToken();
        requestHeadersGet.put("Authorization", "Bearer " + accessToken);
        requestHeadersGet.put("CustomAuthorization", CUSTOM_AUTHORIZATION);
        LogViewerClient logViewerClient = new LogViewerClient(this.gatewayUrlsWrk.getWebAppURLHttps() + "services/", this.gatewaySession);
        logViewerClient.clearLogs();
        HttpResponse httpResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("AddNewHandlerAndInvokeAPI", API_VERSION_1_0_0) + "/" + API_GET_ENDPOINT_METHOD), requestHeadersGet);
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        Assert.assertTrue((boolean)httpResponse.getData().contains(RESPONSE_GET), (String)("Response Data not match for GET request. Expected value :\"I was at CustomAPIAuthenticationHandler\" not contains in response data:\"" + httpResponse.getData() + "\""));
        LogEvent[] logEvents = logViewerClient.getAllRemoteSystemLogs();
        boolean isNewHandlerCalled = false;
        for (LogEvent logEvent : logEvents) {
            if (!logEvent.getMessage().contains(EXPECTED_HANDLER_LOG_OUTPUT)) continue;
            isNewHandlerCalled = true;
            break;
        }
        Assert.assertTrue((boolean)isNewHandlerCalled, (String)"API Request not went through the new handler");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws APIManagerIntegrationTestException, XMLStreamException, RemoteException {
        this.apiStoreClientUser1.removeApplication("AddNewHandlerAndInvokeAPI");
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
        FileManager.deleteFile((String)(this.customHandlerTargetPath + File.separator + CUSTOM_AUTH_HANDLER_JAR));
    }
}

