/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.File;
import java.net.URL;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.webapp.WebAppAdminClient;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.webapp.WebAppDeploymentUtil;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class AddNewMediationAndInvokeAPITestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "AddNewMediationAndInvokeAPITest";
    private final String API_CONTEXT = "AddNewMediationAndInvokeAPI";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_END_POINT_POSTFIX_URL = "CxfRestService-1.0.0-SNAPSHOT/rest/employeeservices/10/";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "AddNewMediationAndInvokeAPI";
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private APICreationRequestBean apiCreationRequestBean;
    private APIIdentifier apiIdentifier;
    private String accessToken;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        String apiEndPointUrl = this.getGatewayURLHttp() + "CxfRestService-1.0.0-SNAPSHOT/rest/employeeservices/10/";
        String providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("AddNewMediationAndInvokeAPITest", "AddNewMediationAndInvokeAPI", "1.0.0", providerName, new URL(apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiIdentifier = new APIIdentifier(providerName, "AddNewMediationAndInvokeAPITest", "1.0.0");
        this.apiIdentifier.setTier("Gold");
        this.apiStoreClientUser1.addApplication("AddNewMediationAndInvokeAPI", "50PerMin", "", "");
        String sessionId = this.createSession(this.gatewayContextMgt);
        this.deployArrService(this.gatewayContextMgt.getContextUrls().getBackEndUrl(), sessionId);
        boolean isWebAppDeployed = WebAppDeploymentUtil.isWebApplicationDeployed((String)this.gatewayContextMgt.getContextUrls().getBackEndUrl(), (String)sessionId, (String)"CxfRestService-1.0.0-SNAPSHOT");
        Assert.assertTrue((boolean)isWebAppDeployed, (String)"Web Application Not Deployed Correctly.");
        this.accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, "AddNewMediationAndInvokeAPI").getAccessToken();
    }

    @Test(groups={"wso2.am"}, description="Invoke the API before adding the log mediation")
    public void testAPIInvocationBeforeAddingNewMediation() throws Exception {
        this.createPublishAndSubscribeToAPI(this.apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, "AddNewMediationAndInvokeAPI");
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet request = new HttpGet(this.getAPIInvocationURLHttp("AddNewMediationAndInvokeAPI", "1.0.0"));
        request.setHeader("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = client.execute((HttpUriRequest)request);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        Assert.assertEquals((String)response.getHeaders("Content-Type")[0].getValue(), (String)"application/xml");
    }

    @Test(groups={"wso2.am"}, description="Invoke the API after adding the log mediation", dependsOnMethods={"testAPIInvocationBeforeAddingNewMediation"})
    public void testAPIInvocationAfterAddingNewMediation() throws Exception {
        this.apiCreationRequestBean.setOutSequence("xml_to_json_out_message");
        this.apiPublisherClientUser1.updateAPI(this.apiCreationRequestBean);
        this.waitForAPIDeployment();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet request = new HttpGet(this.getAPIInvocationURLHttp("AddNewMediationAndInvokeAPI", "1.0.0"));
        request.setHeader("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = client.execute((HttpUriRequest)request);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        Assert.assertEquals((String)response.getHeaders("Content-Type")[0].getValue(), (String)"application/json; charset=UTF-8");
    }

    @Test(groups={"wso2.am"}, description="IInvoke the API after removing the log mediation", dependsOnMethods={"testAPIInvocationAfterAddingNewMediation"})
    public void testAPIInvocationBeforeRemovingNewMediation() throws Exception {
        this.apiCreationRequestBean.setOutSequence("");
        this.apiPublisherClientUser1.updateAPI(this.apiCreationRequestBean);
        this.waitForAPIDeployment();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet request = new HttpGet(this.getAPIInvocationURLHttp("AddNewMediationAndInvokeAPI", "1.0.0"));
        request.setHeader("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = client.execute((HttpUriRequest)request);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        Assert.assertEquals((String)response.getHeaders("Content-Type")[0].getValue(), (String)"application/xml");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws APIManagerIntegrationTestException {
        this.apiStoreClientUser1.removeApplication("AddNewMediationAndInvokeAPI");
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
    }

    public void deployArrService(String backEndUrl, String sessionCookie) throws Exception {
        String filePath = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "sequence" + File.separator + "CxfRestService-1.0.0-SNAPSHOT.war";
        WebAppAdminClient webAppAdminClient = new WebAppAdminClient(backEndUrl, sessionCookie);
        webAppAdminClient.uploadWarFile(filePath);
    }
}

