/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class ChangeResourceTierAndTestInvokingTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "ChangeResourceTierAndTestInvokingTest" + (int)(Math.random() * 100.0 + 1.0);
    private final String API_CONTEXT = "ChangeResourceTierAndTestInvoking" + (int)(Math.random() * 50.0 + 1.0);
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_END_POINT_METHOD = "customers/123";
    private final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "ChangeResourceTierAndTestInvokingTestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private APIIdentifier apiIdentifier;
    private Map<String, String> requestHeaders;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private APICreationRequestBean apiCreationRequestBean;
    private boolean isInitialised = false;

    public void initialize() throws Exception {
        if (!this.isInitialised) {
            super.init();
            this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
            this.providerName = this.user.getUserName();
            this.apiCreationRequestBean = new APICreationRequestBean(this.API_NAME, this.API_CONTEXT, "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
            this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
            this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
            String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
            String storeURLHttp = this.storeUrls.getWebAppURLHttp();
            this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
            this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
            this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
            this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
            this.apiIdentifier = new APIIdentifier(this.providerName, this.API_NAME, "1.0.0");
            this.isInitialised = true;
        }
    }

    @Test(groups={"wso2.am"}, description="test  the  throttling of a API. API Tier :Gold, Application Tier: GOLD, Resource Tier: Unlimited.")
    public void testInvokingWithAPIGoldTierApplicationGoldResourceUnlimited() throws Exception {
        long currentTime;
        this.initialize();
        this.apiStoreClientUser1.addApplication("ChangeResourceTierAndTestInvokingTestCase", "Unlimited", "", "");
        APIIdentifier apiIdentifier = new APIIdentifier(this.providerName, this.API_NAME, "1.0.0");
        apiIdentifier.setTier("Gold");
        this.createPublishAndSubscribeToAPI(apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, "ChangeResourceTierAndTestInvokingTestCase");
        this.waitForAPIDeploymentSync(apiIdentifier.getProviderName(), this.API_NAME, apiIdentifier.getVersion(), "\"isApiExists\":true");
        String accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, "ChangeResourceTierAndTestInvokingTestCase").getAccessToken();
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "text/xml");
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        long startTime = System.currentTimeMillis();
        for (int invocationCount = 1; invocationCount <= 20; ++invocationCount) {
            currentTime = System.currentTimeMillis();
            HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(this.API_CONTEXT, "1.0.0") + "/" + "customers/123"), this.requestHeaders);
            Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Response code mismatched. Invocation attempt:" + invocationCount + " failed  during :" + (currentTime - startTime) + " milliseconds under Gold API , Gold Application level tier" + " and Unlimited Resource tier"));
            Assert.assertTrue((boolean)invokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched. Invocation attempt:" + invocationCount + " failed  during :" + (currentTime - startTime) + " milliseconds under Gold API , Gold Application level tier" + "  and Unlimited Resource tier"));
        }
        currentTime = System.currentTimeMillis();
        HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(this.API_CONTEXT, "1.0.0") + "/" + "customers/123"), this.requestHeaders);
        if (this.executionMode.equalsIgnoreCase(String.valueOf(ExecutionEnvironment.PLATFORM))) {
            do {
                invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(this.API_CONTEXT, "1.0.0") + "/" + "customers/123"), this.requestHeaders);
                System.out.println("response code XXXXX " + invokeResponse.getResponseCode());
            } while (invokeResponse.getResponseCode() != 429);
        }
        Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)429, (String)("Response code mismatched. Invocation attempt:21 passed  during :" + (currentTime - startTime) + " milliseconds under Gold API , " + "Gold Application level tier and Unlimited Resource tier."));
        Assert.assertTrue((boolean)invokeResponse.getData().contains("<amt:code>900800</amt:code><amt:message>Message throttled out</amt:message><amt:description>You have exceeded your quota</amt:description>"), (String)("Response data mismatched. Invocation attempt:21 passed  during :" + (currentTime - startTime) + " milliseconds under Gold API , " + "Gold Application level tier and Unlimited Resource tier."));
    }

    @Test(groups={"wso2.am"}, description="test  the  throttling of a API. API Tier :Gold, Application Tier: GOLD, Resource Tier: Plus.", dependsOnMethods={"testInvokingWithAPIGoldTierApplicationGoldResourceUnlimited"})
    public void testInvokingWithAPIGoldTierApplicationGoldResourceSilver() throws Exception {
        long currentTime;
        this.initialize();
        Thread.sleep(65000L);
        String swagger = " {\"paths\":{\"/*\":{\"get\":{\"x-auth-type\":\"Application \",\"x-throttling-tier\":\"Plus\",\"responses\":{\"200\":\"{}\"}}}},\"swagger\":\"2.0\",\"x-wso2-security\":{\"apim\":{\"x-wso2-scopes\":[]}},\"info\":{\"licence\":{},\"title\":\"" + this.API_NAME + "\",\"description\":" + "\"This is test API create by API manager integration test\",\"contact\":{\"email\":null,\"name\":null}," + "\"version\":\"" + "1.0.0" + "\"}}";
        this.apiPublisherClientUser1.updateResourceOfAPI(this.providerName, this.API_NAME, "1.0.0", swagger);
        this.waitForAPIDeploymentSync(this.providerName, this.API_NAME, "1.0.0", "\"isApiExists\":true");
        this.apiStoreClientUser1.waitForSwaggerDocument(this.user.getUserName(), this.API_NAME, "1.0.0", "Plus", this.executionMode);
        long startTime = System.currentTimeMillis();
        for (int invocationCount = 1; invocationCount <= 5; ++invocationCount) {
            currentTime = System.currentTimeMillis();
            HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(this.API_CONTEXT, "1.0.0") + "/" + "customers/123"), this.requestHeaders);
            Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Response code mismatched. Invocation attempt:" + invocationCount + " failed  during :" + (currentTime - startTime) + " milliseconds under Gold API  and Gold Application level tier" + "  and Plus Resource tier"));
            Assert.assertTrue((boolean)invokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched. Invocation attempt:" + invocationCount + " failed  during :" + (currentTime - startTime) + " milliseconds under Gold API and Gold Application level tier" + " and Plus Resource tier"));
        }
        currentTime = System.currentTimeMillis();
        HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(this.API_CONTEXT, "1.0.0") + "/" + "customers/123"), this.requestHeaders);
        if (this.executionMode.equalsIgnoreCase(String.valueOf(ExecutionEnvironment.PLATFORM))) {
            do {
                invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(this.API_CONTEXT, "1.0.0") + "/" + "customers/123"), this.requestHeaders);
                System.out.println("response code XXXXX " + invokeResponse.getResponseCode());
            } while (invokeResponse.getResponseCode() != 429);
        }
        Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)429, (String)("Response code mismatched. Invocation attempt:6 passed  during :" + (currentTime - startTime) + " milliseconds under Gold API  and Gold" + " Application level tier and Plus Resource tier"));
        Assert.assertTrue((boolean)invokeResponse.getData().contains("<amt:code>900802</amt:code><amt:message>Message throttled out</amt:message><amt:description>You have exceeded your quota</amt:description>"), (String)("Response data mismatched. Invocation attempt:6 passed  during :" + (currentTime - startTime) + " milliseconds under Gold API  and Gold " + "Application level tier and Plus Resource tier"));
    }

    @Test(groups={"wso2.am"}, description="test  the  throttling of a API. API Tier :Gold, Application Tier: GOLD, Resource Tier: Gold.", dependsOnMethods={"testInvokingWithAPIGoldTierApplicationGoldResourceSilver"})
    public void testInvokingWithAPIGoldTierApplicationGoldResourceGold() throws Exception {
        long currentTime;
        this.initialize();
        Thread.sleep(65000L);
        String swagger = " {\"paths\":{\"/*\":{\"get\":{\"x-auth-type\":\"Application \",\"x-throttling-tier\":\"Ultimate\",\"responses\":{\"200\":\"{}\"}}}},\"swagger\":\"2.0\",\"x-wso2-security\":{\"apim\":{\"x-wso2-scopes\":[]}},\"info\":{\"licence\":{},\"title\":\"" + this.API_NAME + "\",\"description\":" + "\"This is test API create by API manager integration test\",\"contact\":{\"email\":null,\"name\":null}," + "\"version\":\"" + "1.0.0" + "\"}}";
        this.apiPublisherClientUser1.updateResourceOfAPI(this.providerName, this.API_NAME, "1.0.0", swagger);
        this.apiStoreClientUser1.waitForSwaggerDocument(this.user.getUserName(), this.API_NAME, "1.0.0", "Ultimate", this.executionMode);
        this.waitForAPIDeploymentSync(this.user.getUserName(), this.API_NAME, "1.0.0", "\"isApiExists\":true");
        long startTime = System.currentTimeMillis();
        for (int invocationCount = 1; invocationCount <= 20; ++invocationCount) {
            currentTime = System.currentTimeMillis();
            HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(this.API_CONTEXT, "1.0.0") + "/" + "customers/123"), this.requestHeaders);
            Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Response code mismatched. Invocation attempt:" + invocationCount + " failed  during :" + (currentTime - startTime) + " milliseconds under Gold API  and Gold Application level tier" + " and Ultimate Resource tier"));
            Assert.assertTrue((boolean)invokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched. Invocation attempt:" + invocationCount + " failed  during :" + (currentTime - startTime) + " milliseconds under Gold API and Gold  Application level tier" + " and Ultimate Resource tier"));
        }
        currentTime = System.currentTimeMillis();
        HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(this.API_CONTEXT, "1.0.0") + "/" + "customers/123"), this.requestHeaders);
        if (this.executionMode.equalsIgnoreCase(String.valueOf(ExecutionEnvironment.PLATFORM))) {
            do {
                invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(this.API_CONTEXT, "1.0.0") + "/" + "customers/123"), this.requestHeaders);
                System.out.println("response code XXXXX " + invokeResponse.getResponseCode());
            } while (invokeResponse.getResponseCode() != 429);
        }
        Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)429, (String)("Response code mismatched. Invocation attempt:21 passed  during :" + (currentTime - startTime) + " milliseconds under Gold API  and Gold " + "Application level tier and Ultimate Resource tier"));
        Assert.assertTrue((boolean)invokeResponse.getData().contains("<amt:code>900802</amt:code><amt:message>Message throttled out</amt:message><amt:description>You have exceeded your quota</amt:description>"), (String)("Response data mismatched. Invocation attempt:21 passed  during :" + (currentTime - startTime) + " milliseconds under Gold API  and Gold " + "Application level tier and Ultimate Resource tier"));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.apiStoreClientUser1.removeApplication("ChangeResourceTierAndTestInvokingTestCase");
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
    }
}

