/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.File;
import java.net.URL;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.lifecycle.LifeCycleAdminClient;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.common.FileManager;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.AuthenticatorClient;

public class CustomLifeCycleTestCase
extends APIManagerLifecycleBaseTest {
    private static final String API_NAME = "APICustomLifecycleTestApi";
    String publisherURLHttp;
    private LifeCycleAdminClient lifeCycleAdminClient;
    private String customizedAPILifecyclePath = FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "AM" + File.separator + "configFiles" + File.separator + "customLifecycleTest" + File.separator + "APILifeCycle.xml";
    private String originalLifeCycleContent;
    private APICreationRequestBean apiCreationRequestBean;
    private APIIdentifier apiIdentifier;
    private String apiEndPointUrl = "http://foo.com";
    private AuthenticatorClient loginClient;
    private String backendUrl;
    private APIPublisherRestClient apiPublisherClient;
    private String apiLifeCycleName = "APILifeCycle";

    @BeforeClass
    public void initialize() throws Exception {
        super.init();
        this.backendUrl = this.gatewayContextMgt.getContextUrls().getBackEndUrl();
        this.loginClient = new AuthenticatorClient(this.backendUrl);
        String session = this.loginClient.login("admin", "admin", "localhost");
        this.lifeCycleAdminClient = new LifeCycleAdminClient(this.backendUrl, session);
        this.originalLifeCycleContent = this.lifeCycleAdminClient.getLifecycleConfiguration(this.apiLifeCycleName);
        String customizedAPILifecycleContent = FileManager.readFile((String)this.customizedAPILifecyclePath);
        this.lifeCycleAdminClient.editLifeCycle(this.apiLifeCycleName, customizedAPILifecycleContent);
        this.apiCreationRequestBean = new APICreationRequestBean(API_NAME, "{version}/api", "1.0.0", this.user.getUserName(), new URL(this.apiEndPointUrl));
        this.apiIdentifier = new APIIdentifier(this.user.getUserName(), API_NAME, "1.0.0");
        this.publisherURLHttp = this.getPublisherURLHttp();
        this.apiPublisherClient = new APIPublisherRestClient(this.publisherURLHttp);
        this.apiPublisherClient.login(this.user.getUserName(), this.user.getPassword());
    }

    @Test(groups={"wso2.am"}, description="Check custom life cycle state.")
    public void testCustomLifeCycle() throws APIManagerIntegrationTestException {
        this.createAndPublishAPI(this.apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClient, false);
        APILifeCycleStateRequest apiLifeCycleStatusChangeRequest = new APILifeCycleStateRequest(API_NAME, this.user.getUserName(), APILifeCycleState.PROMOTE);
        apiLifeCycleStatusChangeRequest.setVersion(this.apiIdentifier.getVersion());
        HttpResponse publishAPIResponse = this.apiPublisherClient.changeAPILifeCycleStatus(apiLifeCycleStatusChangeRequest);
        Boolean statusChangeSuccess = this.verifyAPIStatusChange(publishAPIResponse, APILifeCycleState.PUBLISHED, APILifeCycleState.PROMOTED);
        Assert.assertTrue((boolean)statusChangeSuccess, (String)"API status Change is not successful");
    }

    @AfterClass
    public void cleanupArtifacts() throws Exception {
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClient);
        this.lifeCycleAdminClient.editLifeCycle(this.apiLifeCycleName, this.originalLifeCycleContent);
        this.loginClient.logOut();
        this.apiPublisherClient.logout();
    }
}

