/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class InvokeAPIUsingOldThrottlingWithWSClient
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "ChangeAPITierAndTestInvokingTest";
    private final String API_CONTEXT = "ChangeAPITierAndTestInvoking";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_END_POINT_METHOD = "customers/123";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "ChangeAPITierAndTestInvokingTestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String applicationNameGold;
    private Map<String, String> requestHeadersGoldTier;
    private APIIdentifier apiIdentifier;
    private String providerName;
    private APICreationRequestBean apiCreationRequestBean;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private ServerConfigurationManager serverConfigurationManager;
    protected AutomationContext superTenantKeyManagerContext;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.superTenantKeyManagerContext = new AutomationContext("APIM", "keyManager", TestUserMode.SUPER_TENANT_ADMIN);
        this.serverConfigurationManager = new ServerConfigurationManager(this.superTenantKeyManagerContext);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "apiManagerXmlWithoutAdvancedThrottlingUsingWSClient" + File.separator + "api-manager.xml"));
        this.serverConfigurationManager.restartGracefully();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiIdentifier = new APIIdentifier(this.providerName, "ChangeAPITierAndTestInvokingTest", "1.0.0");
    }

    @Test(groups={"wso2.am"}, description="test  invocation of  api using old throttle and ws client")
    public void testInvokingAPIWithOldThrottleUsingWSClient() throws Exception {
        this.applicationNameGold = "ChangeAPITierAndTestInvokingTestCaseGold";
        this.apiStoreClientUser1.addApplication(this.applicationNameGold, "Unlimited", "", "");
        this.apiCreationRequestBean = new APICreationRequestBean("ChangeAPITierAndTestInvokingTest", "ChangeAPITierAndTestInvoking", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTier("Gold");
        this.createPublishAndSubscribeToAPI(this.apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, this.applicationNameGold);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeAPITierAndTestInvokingTest", "1.0.0", "\"isApiExists\":true");
        String accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, this.applicationNameGold).getAccessToken();
        this.requestHeadersGoldTier = new HashMap<String, String>();
        this.requestHeadersGoldTier.put("Authorization", "Bearer " + accessToken);
        this.requestHeadersGoldTier.put("accept", "text/xml");
        HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeAPITierAndTestInvoking", "1.0.0") + "/" + "customers/123"), this.requestHeadersGoldTier);
        Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API Invocation failed");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.apiStoreClientUser1.removeApplication(this.applicationNameGold);
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
        this.serverConfigurationManager.restoreToLastConfiguration();
    }
}

