/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.application;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.identity.oauth.stub.OAuthAdminServiceIdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.stub.OAuthAdminServiceStub;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthConsumerAppDTO;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class AuthApplicationUpdateTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(AuthApplicationUpdateTestCase.class);
    private final String APP_NAME = "AuthApplicationUpdateApp";
    private final String APP_NAME_TO_UPDATE = "AuthApplicationNameToUpdateApp";
    private final String GRANT_TYPE_AUTHORIZATION_CODE = "authorization_code";
    private final String GRANT_TYPE_CLIENT_CREDENTIALS = "client_credentials";
    private final String GRANT_TYPE_PASSWORD = "password";
    private final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    private final String GRANT_TYPE_IMPLICIT = "implicit";
    private final String APP_DESCRIPTION = "description";
    private final String APP_CALLBACK_URL = "http://wso2.com/";
    private final String UPDATE_APP_CALLBACK_URL = "https://www.google.lk/";
    private final String API_VERSION = "1.0.0";
    private final String API_NAME = "AuthApplicationUpdateAPIName";
    private final String API_CONTEXT = "AuthApplicationUpdateContext";
    private String storeURLHttp;
    private APIStoreRestClient apiStore;
    private String consumerKey;
    private String publisherURLHttps;

    @Factory(dataProvider="userModeDataProvider")
    public AuthApplicationUpdateTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.storeURLHttp = this.getStoreURLHttp();
        this.publisherURLHttps = this.publisherUrls.getWebAppURLHttp();
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttps);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
    }

    @Test(groups={"wso2.am"}, description="Sample Application creation")
    public void testApplicationCreation() throws Exception {
        this.apiStore.addApplication("AuthApplicationUpdateApp", "50PerMin", "http://wso2.com/", "description");
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("AuthApplicationUpdateApp");
        HttpResponse response = this.apiStore.generateApplicationKey(generateAppKeyRequest);
        this.verifyResponse(response);
        String responseString = response.getData();
        this.consumerKey = this.getConsumerKey(responseString);
        Assert.assertNotNull((Object)this.consumerKey);
        OAuthConsumerAppDTO authApp = this.getAuthAppDetails(this.consumerKey);
        String grantTypes = authApp.getGrantTypes();
        Assert.assertTrue((boolean)grantTypes.contains("authorization_code"));
        Assert.assertTrue((boolean)grantTypes.contains("client_credentials"));
        Assert.assertTrue((boolean)grantTypes.contains("password"));
        Assert.assertTrue((boolean)grantTypes.contains("refresh_token"));
        Assert.assertTrue((boolean)grantTypes.contains("implicit"));
    }

    @Test(groups={"wso2.am"}, description="Sample Auth Application update", dependsOnMethods={"testApplicationCreation"})
    public void testApplicationUpdate() throws Exception {
        String application = "AuthApplicationUpdateApp";
        String keyType = "PRODUCTION";
        String authorizedDomains = "ALL";
        String retryAfterFailure = String.valueOf(false);
        String jsonParams = "{\"grant_types\":\"urn:ietf:params:oauth:grant-type:saml2-bearer,iwa:ntlm\"}";
        String callbackUrl = "https://www.google.lk/";
        HttpResponse response = this.apiStore.updateClientApplication(application, keyType, authorizedDomains, retryAfterFailure, jsonParams, callbackUrl);
        this.verifyResponse(response);
    }

    @Test(groups={"wso2.am"}, description="Sample Auth Application Properties check", dependsOnMethods={"testApplicationUpdate"})
    public void testApplicationGrantTypeAfterUpdate() throws Exception {
        OAuthConsumerAppDTO authApp = this.getAuthAppDetails(this.consumerKey);
        String grantTypes = authApp.getGrantTypes();
        Assert.assertNotNull((Object)grantTypes);
        Assert.assertFalse((boolean)grantTypes.contains("authorization_code"));
        Assert.assertFalse((boolean)grantTypes.contains("client_credentials"));
        Assert.assertFalse((boolean)grantTypes.contains("password"));
        Assert.assertFalse((boolean)grantTypes.contains("refresh_token"));
        Assert.assertFalse((boolean)grantTypes.contains("implicit"));
        Assert.assertEquals((String)authApp.getCallbackUrl(), (String)"https://www.google.lk/");
    }

    @Test(groups={"wso2.am"}, description="Test Application name update after key generate", dependsOnMethods={"testApplicationGrantTypeAfterUpdate"})
    public void testApplicationNameUpdateAfterKeyGeneration() throws Exception {
        String tierCollection = "Unlimited";
        String endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("AuthApplicationUpdateAPIName", "AuthApplicationUpdateContext", "1.0.0", this.user.getUserName(), new URL(endpointUrl));
        apiCreationRequestBean.setTiersCollection(tierCollection);
        ArrayList<APIResourceBean> resList = new ArrayList<APIResourceBean>();
        APIResourceBean res1 = new APIResourceBean("GET", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType(), "Plus", "/add");
        resList.add(res1);
        apiCreationRequestBean.setResourceBeanList(resList);
        HttpResponse serviceResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("AuthApplicationUpdateAPIName", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("AuthApplicationUpdateAPIName", this.user.getUserName());
        subscriptionRequest.setApplicationName("AuthApplicationUpdateApp");
        subscriptionRequest.setTier("Unlimited");
        serviceResponse = this.apiStore.subscribe(subscriptionRequest);
        this.verifyResponse(serviceResponse);
        HttpResponse response = this.apiStore.updateApplication("AuthApplicationUpdateApp", "AuthApplicationNameToUpdateApp", "https://www.google.lk/", "description", "50PerMin");
        this.verifyResponse(response);
    }

    @Test(groups={"wso2.am"}, description="Test Subscription after Application name update", dependsOnMethods={"testApplicationNameUpdateAfterKeyGeneration"})
    public void testSubscriptionAfterApplicationNameUpdate() throws Exception {
        HttpResponse response = this.apiStore.getAllSubscriptionsOfApplication("AuthApplicationNameToUpdateApp");
        this.verifyResponse(response);
        Assert.assertTrue((boolean)response.getData().contains("AuthApplicationUpdateAPIName"), (String)"Subscribe API not included after App name updated");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication("AuthApplicationNameToUpdateApp");
        this.apiPublisher.deleteAPI("AuthApplicationUpdateAPIName", "1.0.0", this.user.getUserName());
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    private String getConsumerKey(String response) {
        Pattern pattern = Pattern.compile("\"consumerKey\" : \"(\\w|\\d)+\"");
        Matcher matcher = pattern.matcher(response);
        String key = null;
        if (matcher.find()) {
            key = matcher.group(0).split(":")[1].trim().replace("\"", "");
        }
        return key;
    }

    private OAuthConsumerAppDTO getAuthAppDetails(String consumerKey) throws RemoteException, XPathExpressionException, OAuthAdminServiceIdentityOAuthAdminException {
        OAuthAdminServiceStub stub = new OAuthAdminServiceStub(this.getKeyManagerURLHttps() + "services/OAuthAdminService");
        ServiceClient client = stub._getServiceClient();
        Options client_options = client.getOptions();
        HttpTransportProperties.Authenticator authenticator = new HttpTransportProperties.Authenticator();
        authenticator.setUsername(this.user.getUserName());
        authenticator.setPassword(this.user.getPassword());
        authenticator.setPreemptiveAuthentication(true);
        client_options.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)authenticator);
        client.setOptions(client_options);
        return stub.getOAuthApplicationData(consumerKey);
    }
}

