/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.application;

import java.rmi.RemoteException;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.identity.oauth.stub.OAuthAdminServiceStub;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;

public class CAPIMGT12CallBackURLOverwriteTestCase
extends APIMIntegrationBaseTest {
    private APIStoreRestClient apiStore;
    private String publisherURLHttp;
    private String storeURLHttp;
    String consumerKeyUser1App;
    String consumerKeyUser2App;
    private static final String TEST_USER_1 = "TestUser1001";
    private static final String TEST_USER_2 = "TestUser2002";
    private static final String TEST_USER_1_PASSWORD = "12345";
    private static final String TEST_USER_2_PASSWORD = "12345";
    private static final String USER_1_TEST_APPLICATION = "TestApplication";
    private static final String USER_2_TEST_APPLICATION = "TestApplication";
    private static final String USER_1_TEST_APP_INITIAL_CBU = "www.user1-app-initial-callback-url.com";
    private static final String USER_2_TEST_APP_INITIAL_CBU = "www.user2-app-initial-callback-url.com";
    private static final String USER_2_TEST_APP_UPDATED_CBU = "www.user2-app-updated-callback-url.com";
    private static final Log log = LogFactory.getLog(CAPIMGT12CallBackURLOverwriteTestCase.class);

    @BeforeClass(alwaysRun=true)
    public void init() throws APIManagerIntegrationTestException {
        super.init();
        try {
            this.userManagementClient.addUser(TEST_USER_1, "12345", new String[]{"admin"}, "manager");
            this.userManagementClient.addUser(TEST_USER_2, "12345", new String[]{"admin"}, "manager");
        }
        catch (UserAdminUserAdminException e) {
            log.error((Object)"Error while creating the test users");
            Assert.fail((String)e.getMessage());
        }
        catch (RemoteException e) {
            log.error((Object)"Error while creating the test users");
            Assert.fail((String)e.getMessage());
        }
        this.publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
    }

    @Test(groups={"wso2.am"}, description="Application call back url update and overwriting test case")
    public void callBackUrlUpdateTestCase() throws Exception {
        this.addAppsAndGenerateKeys();
        String jsonParams = "{\"grant_types\":\"urn:ietf:params:oauth:grant-type:saml2-bearer,iwa:ntlm\"}";
        this.apiStore.updateClientApplication("TestApplication", "PRODUCTION", "ALL", String.valueOf(false), jsonParams, USER_2_TEST_APP_UPDATED_CBU);
        OAuthAdminServiceStub oAuthAdminServiceStub = new OAuthAdminServiceStub(this.getKeyManagerURLHttps() + "services/OAuthAdminService");
        ServiceClient client = oAuthAdminServiceStub._getServiceClient();
        Options client_options = client.getOptions();
        HttpTransportProperties.Authenticator authenticator = new HttpTransportProperties.Authenticator();
        authenticator.setUsername("admin");
        authenticator.setPassword("admin");
        authenticator.setPreemptiveAuthentication(true);
        client_options.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)authenticator);
        client.setOptions(client_options);
        String finalCallbackUrlUser1App = oAuthAdminServiceStub.getOAuthApplicationData(this.consumerKeyUser1App).getCallbackUrl();
        String finalCallbackUrlUser2App = oAuthAdminServiceStub.getOAuthApplicationData(this.consumerKeyUser2App).getCallbackUrl();
        Assert.assertEquals((String)finalCallbackUrlUser1App, (String)USER_1_TEST_APP_INITIAL_CBU, (String)"Call back URL of the first user's application has been overwritten due to the update of the call back URL of second user's application.");
        Assert.assertNotEquals((Object)finalCallbackUrlUser1App, (Object)finalCallbackUrlUser2App, (String)"Call back URL of the first user's application has been overwritten due to the update of the call back URL of second user's application.");
    }

    public void addAppsAndGenerateKeys() throws Exception {
        this.apiStore.login(TEST_USER_1, "12345");
        this.apiStore.addApplication("TestApplication", "Unlimited", "", "This-is-sample-application");
        APPKeyRequestGenerator generateAppKeyRequest1 = new APPKeyRequestGenerator("TestApplication");
        generateAppKeyRequest1.setCallbackUrl(USER_1_TEST_APP_INITIAL_CBU);
        String responseString1 = this.apiStore.generateApplicationKey(generateAppKeyRequest1).getData();
        JSONObject jsonObject1 = new JSONObject(responseString1);
        this.consumerKeyUser1App = ((JSONObject)((JSONObject)jsonObject1.get("data")).get("key")).getString("consumerKey");
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiStore.login(TEST_USER_2, "12345");
        this.apiStore.addApplication("TestApplication", "Unlimited", "", "This-is-sample-application");
        APPKeyRequestGenerator generateAppKeyRequest2 = new APPKeyRequestGenerator("TestApplication");
        generateAppKeyRequest2.setCallbackUrl(USER_2_TEST_APP_INITIAL_CBU);
        String responseString2 = this.apiStore.generateApplicationKey(generateAppKeyRequest2).getData();
        JSONObject jsonObject2 = new JSONObject(responseString2);
        this.consumerKeyUser2App = ((JSONObject)((JSONObject)jsonObject2.get("data")).get("key")).getString("consumerKey");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

