/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.header;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class CORSAccessControlAllowCredentialsHeaderTestCase
extends APIManagerLifecycleBaseTest {
    private String publisherURLHttp;
    private APIPublisherRestClient apiPublisher;
    private static final String API_NAME_1 = "CorsACACHeadersTestAPI_1";
    private static final String API_NAME_2 = "CorsACACHeadersTestAPI_2";
    private static final String APPLICATION_NAME_1 = "CorsACACApp_1";
    private static final String APPLICATION_NAME_2 = "CorsACACApp_2";
    private static final String API_CONTEXT_1 = "corsACACHeadersTestAPI_1";
    private static final String API_CONTEXT_2 = "corsACACHeadersTestAPI_2";
    private static final String API_VERSION = "1.0.0";
    private static final String TAGS = "ACAC, cors, test";
    private static final String DESCRIPTION = "This is test API create by API manager integration test";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER_VALUE_ALL = "*";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER_VALUE_LOCALHOST = "http://localhost";
    private static final String ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER = "Access-Control-Allow-Credentials";
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private APICreationRequestBean apiCreationRequestBean;
    private APIIdentifier apiIdentifier;
    private String accessToken;
    private ServerConfigurationManager serverConfigurationManager;
    Log log = LogFactory.getLog(CORSAccessControlAllowCredentialsHeaderTestCase.class);

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
            this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "dummy_api.xml", this.gatewayContextMgt, gatewaySessionCookie);
        }
        this.serverConfigurationManager = new ServerConfigurationManager(this.superTenantKeyManagerContext);
    }

    @Test(groups={"wso2.am"}, description="Checking Access-Control-Allow-Credentials header in response when Access-Control-Allow-Origin is '*'")
    public void CheckAccessControlAllowCredentialsHeadersWithAnyOrigin() throws Exception {
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "corsACACTest" + File.separator + "withOriginAny" + File.separator + "api-manager.xml"));
            this.serverConfigurationManager.restartGracefully();
            super.init();
        }
        this.accessToken = this.createPublishAndSubscribeToApi(this.user, API_NAME_1, API_CONTEXT_1, API_VERSION, APPLICATION_NAME_1);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(API_CONTEXT_1, API_VERSION));
        get.addHeader("Origin", ACCESS_CONTROL_ALLOW_ORIGIN_HEADER_VALUE_LOCALHOST);
        get.addHeader("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        ArrayList<Integer> responseCodes = new ArrayList<Integer>();
        responseCodes.add(HTTP_RESPONSE_CODE_OK);
        responseCodes.add(HTTP_RESPONSE_CODE_CREATED);
        Assert.assertTrue((boolean)responseCodes.contains(response.getStatusLine().getStatusCode()), (String)"Response code mismatch.");
        Header[] responseHeaders = response.getAllHeaders();
        this.log.info((Object)"Response Headers: CheckAccessControlAllowCredentialsHeadersWithAnyOrigin");
        for (Header header : responseHeaders) {
            this.log.info((Object)(header.getName() + " : " + header.getValue()));
        }
        Header header = this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_ORIGIN_HEADER);
        Assert.assertNotNull((Object)header, (String)"Access-Control-Allow-Origin header is not available in the response.");
        Assert.assertEquals((String)header.getValue(), (String)ACCESS_CONTROL_ALLOW_ORIGIN_HEADER_VALUE_ALL, (String)"Access-Control-Allow-Origin header value mismatch.");
        Assert.assertNull((Object)this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER), (String)"Access-Control-Allow-Credentials header is available in the response, but it should not be.");
    }

    @Test(groups={"wso2.am"}, description="Checking Access-Control-Allow-Credentials header in response when Access-Control-Allow-Origin is 'http://localhost'", dependsOnMethods={"CheckAccessControlAllowCredentialsHeadersWithAnyOrigin"})
    public void CheckAccessControlAllowCredentialsHeadersWithSpecificOrigin() throws Exception {
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "corsACACTest" + File.separator + "api-manager.xml"));
            this.serverConfigurationManager.restartGracefully();
            super.init();
        }
        this.accessToken = this.createPublishAndSubscribeToApi(this.user, API_NAME_2, API_CONTEXT_2, API_VERSION, APPLICATION_NAME_2);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(API_CONTEXT_2, API_VERSION));
        get.addHeader("Origin", ACCESS_CONTROL_ALLOW_ORIGIN_HEADER_VALUE_LOCALHOST);
        get.addHeader("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        ArrayList<Integer> responseCodes = new ArrayList<Integer>();
        responseCodes.add(HTTP_RESPONSE_CODE_OK);
        responseCodes.add(HTTP_RESPONSE_CODE_CREATED);
        Assert.assertTrue((boolean)responseCodes.contains(response.getStatusLine().getStatusCode()), (String)"Response code mismatch.");
        Header[] responseHeaders = response.getAllHeaders();
        this.log.info((Object)"Response Headers: CheckAccessControlAllowCredentialsHeadersWithAnyOrigin");
        for (Header header : responseHeaders) {
            this.log.info((Object)(header.getName() + " : " + header.getValue()));
        }
        Header header = this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_ORIGIN_HEADER);
        Assert.assertNotNull((Object)header, (String)"Access-Control-Allow-Origin header is not available in the response.");
        Assert.assertEquals((String)header.getValue(), (String)ACCESS_CONTROL_ALLOW_ORIGIN_HEADER_VALUE_LOCALHOST, (String)"Access-Control-Allow-Origin header value mismatch.");
        Assert.assertNotNull((Object)this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER), (String)"Access-Control-Allow-Credentials header is not available in the response.");
    }

    private String createPublishAndSubscribeToApi(User user, String apiName, String apiContext, String apiVersion, String appName) throws APIManagerIntegrationTestException, XPathExpressionException, MalformedURLException {
        this.publisherURLHttp = this.getPublisherURLHttp();
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        this.apiPublisher.login(user.getUserName(), user.getPassword());
        String providerName = user.getUserName();
        URL endpointUrl = new URL(this.getSuperTenantAPIInvocationURLHttp("response", API_VERSION));
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "/*"));
        this.apiCreationRequestBean = new APICreationRequestBean(apiName, apiContext, apiVersion, providerName, endpointUrl, resourceBeanList);
        this.apiCreationRequestBean.setTags(TAGS);
        this.apiCreationRequestBean.setDescription(DESCRIPTION);
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(user.getUserName(), user.getPassword());
        this.apiStoreClientUser1.login(user.getUserName(), user.getPassword());
        this.apiIdentifier = new APIIdentifier(providerName, apiName, apiVersion);
        this.apiIdentifier.setTier("Gold");
        this.apiStoreClientUser1.addApplication(appName, "50PerMin", "", "");
        this.createPublishAndSubscribeToAPI(this.apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, appName);
        return this.generateApplicationKeys(this.apiStoreClientUser1, appName).getAccessToken();
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "corsACACTest" + File.separator + "original" + File.separator + "api-manager.xml"));
            this.serverConfigurationManager.restartGracefully();
        }
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public CORSAccessControlAllowCredentialsHeaderTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }
}

