/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.header.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class SimpleSocketServer
extends Thread {
    private int port;
    private String expectedOutput;
    private ServerSocket serverSocket;

    public SimpleSocketServer(int port, String expectedOutput) {
        this.port = port;
        this.expectedOutput = expectedOutput;
    }

    @Override
    public void run() {
        try {
            this.serverSocket = new ServerSocket(this.port);
            System.err.println("Server starting on port : " + this.port);
            while (true) {
                String s;
                Socket clientSocket = this.serverSocket.accept();
                System.err.println("Client connected");
                BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(clientSocket.getOutputStream()));
                while ((s = in.readLine()) != null) {
                    System.out.println(s);
                    if (!s.isEmpty()) continue;
                }
                out.write(this.expectedOutput);
                System.err.println("connection terminated");
                out.close();
                in.close();
                clientSocket.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void shutdown() {
        if (this.serverSocket != null && !this.serverSocket.isClosed()) {
            try {
                System.err.println("Server shutting down");
                this.serverSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

