/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.hostobject;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.utils.FileManipulator;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class HostObjectTestCase
extends APIMIntegrationBaseTest {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private final String hostObjectTestApplicationName = "HostObjectTestAPI-Application";

    @Factory(dataProvider="userModeDataProvider")
    public HostObjectTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiStore = new APIStoreRestClient(storeURLHttp);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication("HostObjectTestAPI-Application");
        super.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"wso2.am"}, description="API Life cycle test case")
    public void testHostObjectTestCase() throws Exception {
        String fileStore;
        String filePublisher;
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
        String APIName = "HostObjectTestAPI";
        String APIContext = "HostObjectTestAPIAPIContext";
        String tags = "youtube, video, media";
        String url = "http://gdata.youtube.com/feeds/api/standardfeeds";
        String description = "This is test API create by API manager integration test";
        String providerName = this.user.getUserName();
        String APIVersion = "1.0.0";
        if (this.publisherContext.getContextTenant().getDomain().equals("carbon.super")) {
            filePublisher = "testPublisher.jag";
            fileStore = "testStore.jag";
        } else {
            filePublisher = "testPublisherTenant.jag";
            fileStore = "testStoreTenant.jag";
        }
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setProvider(providerName);
        this.apiPublisher.addAPI(apiRequest);
        APIBean apiBean = APIMTestCaseUtils.getAPIBeanFromHttpResponse((HttpResponse)this.apiPublisher.getAPI(APIName, providerName));
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertEquals((String)apiBean.getId().getApiName(), (String)APIName, (String)"API Name mismatch");
        Assert.assertTrue((boolean)apiBean.getContext().contains(APIContext), (String)"API context mismatch");
        Assert.assertEquals((String)apiBean.getId().getVersion(), (String)APIVersion, (String)"API version mismatch");
        Assert.assertEquals((String)apiBean.getId().getProviderName(), (String)providerName, (String)"Provider Name mismatch");
        for (String tag : apiBean.getTags()) {
            Assert.assertTrue((boolean)tags.contains(tag), (String)"API tag data mismatched");
        }
        Assert.assertEquals((String)apiBean.getDescription(), (String)description, (String)"API description mismatch");
        this.apiStore.addApplication("HostObjectTestAPI-Application", "Unlimited", "", "this-is-test");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(APIName, providerName);
        subscriptionRequest.setApplicationName("HostObjectTestAPI-Application");
        this.apiStore.subscribe(subscriptionRequest);
        this.apiPublisher.addDocument(APIName, APIVersion, providerName, "Doc-Name", "How To", "Inline", "url-no-need", "summary", "", "", "");
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("HostObjectTestAPI-Application");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        Assert.assertNotNull((Object)accessToken, (String)"Access Token cannot be Null");
        String sourcePath = this.computeSourcePath(filePublisher);
        String destinationPath = this.computeDestPath(filePublisher);
        this.copySampleFile(sourcePath, destinationPath);
        sourcePath = this.computeSourcePath(fileStore);
        destinationPath = this.computeDestPath(fileStore);
        this.copySampleFile(sourcePath, destinationPath);
        String finalOutputPublisher = null;
        Thread.sleep(10000L);
        int deploymentDelayInMilliseconds = 90000;
        long startTime = System.currentTimeMillis();
        try {
            String[] responseArrayFromPublisher = new String[35];
            boolean isPublisherResponse = false;
            while (System.currentTimeMillis() - startTime < (long)deploymentDelayInMilliseconds && !isPublisherResponse) {
                String inputLine;
                Thread.sleep(500L);
                URL jaggeryURL = new URL(this.publisherUrls.getWebAppURLHttp() + "testapp/" + filePublisher);
                URLConnection jaggeryServerConnection = jaggeryURL.openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(jaggeryServerConnection.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    finalOutputPublisher = inputLine;
                }
                if (null != finalOutputPublisher) {
                    responseArrayFromPublisher = finalOutputPublisher.split("==");
                    isPublisherResponse = responseArrayFromPublisher[30].contains("HostObjectTestAPI");
                }
                in.close();
            }
            this.log.info(finalOutputPublisher);
            this.validatePublisherResponseArray(responseArrayFromPublisher);
        }
        catch (IOException e) {
            this.log.error((Object)"Error while invoking test application to test publisher host object");
        }
        finally {
            Assert.assertNotNull(finalOutputPublisher, (String)"Result cannot be null");
        }
        String finalOutputStore = null;
        try {
            String[] responseArrayFromStore = new String[27];
            boolean isStoreResponse = false;
            startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < (long)deploymentDelayInMilliseconds && !isStoreResponse) {
                String inputLine;
                Thread.sleep(500L);
                URL jaggeryURL = new URL(this.storeUrls.getWebAppURLHttp() + "testapp/" + fileStore);
                URLConnection jaggeryServerConnection = jaggeryURL.openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(jaggeryServerConnection.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    finalOutputStore = inputLine;
                }
                if (null != finalOutputStore) {
                    responseArrayFromStore = finalOutputStore.split("==");
                    isStoreResponse = responseArrayFromStore[9].contains("HostObjectTestAPI");
                }
                in.close();
            }
            this.log.info(finalOutputStore);
            this.validateStoreResponseArray(responseArrayFromStore);
        }
        catch (IOException e) {
            this.log.error((Object)"Error while invoking test application to test publisher host object");
        }
        finally {
            Assert.assertNotNull(finalOutputStore, (String)"Result cannot be null");
        }
    }

    @Test(groups={"wso2.am"}, description="Test application object")
    public void testApplication() {
    }

    @Test(groups={"wso2.am"}, description="Test application operations")
    public void testApplicationOperations() {
    }

    @Test(groups={"wso2.am"}, description="Test application operations")
    public void testAPIProvider() {
    }

    private boolean validateStoreResponseArray(String[] array) throws XPathExpressionException {
        Assert.assertTrue((boolean)array[1].contains("false"), (String)"Error while getting status of billing system from API store host object (isBillingEnabled)");
        Assert.assertTrue((boolean)array[2].contains("https"), (String)"Error while getting https url from API store host object (getHTTPsURL)");
        Assert.assertTrue((boolean)array[3].contains("services"), (String)"Error while getting auth service url from API store host object (getAuthServerURL)");
        Assert.assertTrue((boolean)array[4].contains("http"), (String)"Error while getting http url from API store host object (getHTTPURL)");
        Assert.assertTrue((boolean)array[5].contains("[]"), (String)"Error while getting denied tiers from API store host object (getDeniedTiers)");
        Assert.assertTrue((boolean)array[6].contains("wso2.com"), (String)"Error while getting active tenant domains from API store host object (getActiveTenantDomains)");
        Assert.assertTrue((boolean)array[7].contains("false"), (String)"Error while getting status of self sign in from API store host object (isSelfSignupEnabled)");
        Assert.assertTrue((boolean)array[8].contains("fieldName"), (String)"Error while getting user fields from API store host object (getUserFields)");
        Assert.assertTrue((boolean)array[9].contains("HostObjectTestAPI"), (String)"Error while search Paginated APIs By Type from API store host object (searchPaginatedAPIsByType)");
        Assert.assertTrue((boolean)array[10].contains("HostObjectTestAPI"), (String)"Error while search Paginated APIs By Type with pattern * from API store host object (searchPaginatedAPIsByType)");
        Assert.assertTrue((boolean)array[11].contains("HostObjectTestAPI"), (String)"Error while getting paginated APIs with tag from API store host object (getPaginatedAPIsWithTag)");
        Assert.assertTrue((boolean)array[12].contains("HostObjectTestAPI"), (String)"Error while rating API from API store host object (rateAPI)");
        Assert.assertTrue((boolean)array[13].contains("newRating"), (String)"Error while removing rating from API store host object (removeAPIRating)");
        Assert.assertTrue((boolean)array[14].contains("apis"), (String)"Error while getting Paginated , published APIs from API store host object (getAllPaginatedPublishedAPIs)");
        Assert.assertTrue((boolean)array[15].contains("HostObjectTestAPI"), (String)"Error while getting APIs With Tag from API store host object (getAPIsWithTag)");
        Assert.assertTrue((boolean)array[16].contains("HostObjectTestAPI"), (String)"Error while getting all published APIs from API store host object (getAllPublishedAPIs)");
        Assert.assertTrue((boolean)array[17].contains("true"), (String)"Error while checking user in the system from API store host object (isUserExists)");
        Assert.assertTrue((boolean)array[18].contains("HostObjectTestAPI"), (String)"Error while getting API from API store host object (getAPI)");
        Assert.assertTrue((boolean)array[19].contains("true"), (String)"Error while checking subscription state from API store host object (isSubscribed)");
        Assert.assertTrue((boolean)array[21].contains("true"), (String)"Error while checking user permission from API store host object (hasUserPermissions)");
        Assert.assertTrue((boolean)array[22].contains("true"), (String)"Error while checking Subscribe Permission from API store host object (hasSubscribePermission)");
        Assert.assertTrue((boolean)array[23].contains("true"), (String)"Error while update Application Tier from API store host object (updateApplicationTier)");
        Assert.assertTrue((boolean)array[24].contains("true"), (String)"Error while update Application from API store host object (updateApplication)");
        Assert.assertTrue((boolean)array[25].contains("200"), (String)"Error while validate WF Permission from API store host object (validateWFPermission)");
        Assert.assertTrue((boolean)array[26].contains("false"), (String)"Error while getting state of Email Username from API store host object (isEnableEmailUsername)");
        return true;
    }

    private boolean validatePublisherResponseArray(String[] array) {
        Assert.assertTrue((boolean)array[1].contains("true"), (String)"Error while validating roles from API store host object (validateRoles)");
        Assert.assertTrue((boolean)array[2].contains("success"), (String)"Error while checking url validity from API store host object (isURLValid)");
        Assert.assertTrue((boolean)array[3].contains("HostObjectTestAPI"), (String)"Error while getting APIs by provider from API store host object (getAPIsByProvider)");
        Assert.assertTrue((boolean)array[4].contains("HostObjectTestAPI"), (String)"Error while getting subscribed APIs from API store host object (getSubscribedAPIs)");
        Assert.assertTrue((boolean)array[5].contains("HostObjectTestAPI"), (String)"Error while getting API from API store host object (getAPI)");
        Assert.assertTrue((boolean)array[6].contains("Bronze"), (String)"Error while getting tier permission from API store host object (getTierPermissions)");
        Assert.assertTrue((boolean)array[7].contains("Bronze"), (String)"Error while getting tiers from API store host object (getTiers)");
        Assert.assertTrue((boolean)array[8].contains("HostObjectTestAPI"), (String)"Error while getting all APIs By Type from API store host object (getAllAPIs)");
        Assert.assertTrue((boolean)array[9].contains("HostObjectTestAPI"), (String)"Error while getting APIs By provider with pattern * from API store host object (getAPIsByProvider)");
        Assert.assertTrue((boolean)array[10].contains("subscribedDate"), (String)"Error while getting subscribers of API from API store host object (getSubscribersOfAPI)");
        Assert.assertTrue((boolean)array[11].contains("false"), (String)"Error while checking contexts from API store host object (isContextExist)");
        Assert.assertTrue((boolean)array[12].contains("HostObjectTestAPI"), (String)"Error while searching APIs from API store host object (searchAPIs)");
        Assert.assertTrue((boolean)array[13].contains("true"), (String)"Error while checking create permission from API store host object (hasCreatePermission)");
        Assert.assertTrue((boolean)array[14].contains("true"), (String)"Error while checking manage tier permission from API store host object (hasManageTierPermission)");
        Assert.assertTrue((boolean)array[15].contains("true"), (String)"Error while checking user permission from API store host object (hasUserPermissions)");
        Assert.assertTrue((boolean)array[16].contains("true"), (String)"Error while checking publisher permissions (hasPublishPermission)");
        Assert.assertTrue((boolean)array[17].contains("services"), (String)"Error while getting auth server url from API store host object (getAuthServerURL)");
        Assert.assertTrue((boolean)array[18].contains("log_in_message"), (String)"Error while getting in sequences from API store host object (getCustomInSequences)");
        Assert.assertTrue((boolean)array[19].contains("log_out_message"), (String)"Error while getting out sequences from API store host object (getCustomOutSequences)");
        Assert.assertTrue((boolean)array[20].contains("https"), (String)"Error while getting https url from API store host object (getHTTPsURL)");
        Assert.assertTrue((boolean)array[21].contains("true"), (String)"Error while checking gateway type from API store host object (isSynapseGateway)");
        Assert.assertTrue((boolean)array[22].contains("null"), (String)"Error while load Registry Of Tenant API store host object (loadRegistryOfTenant)");
        Assert.assertTrue((boolean)array[23].contains("false"), (String)"Error while checking API Older Versions from API store host object (isAPIOlderVersionExist)");
        Assert.assertTrue((boolean)array[24].contains("true"), (String)"Error while update Subscription Status from API store host object (updateSubscriptionStatus)");
        Assert.assertTrue((boolean)array[25].contains("true"), (String)"Error while update Tier Permissions from API store host object (updateTierPermissions)");
        Assert.assertTrue((boolean)array[26].contains("HostObjectTestAPI"), (String)"Error while searching APIs by Version from API store host object (searchAPIs)");
        Assert.assertTrue((boolean)array[27].contains("HostObjectTestAPI"), (String)"Error while searching APIs by Status from API store host object (searchAPIs)");
        Assert.assertTrue((boolean)array[28].contains("HostObjectTestAPI"), (String)"Error while search API by part of the API name (searchAPIs)");
        Assert.assertTrue((boolean)array[29].contains("HostObjectTestAPI"), (String)"Error while search API by uppercase API name (searchAPIs)");
        Assert.assertTrue((boolean)array[30].contains("HostObjectTestAPI"), (String)"Error while search API by lowercase API name (searchAPIs)");
        Assert.assertTrue((boolean)array[31].contains("HostObjectTestAPI"), (String)"Error while search API by provider (searchAPIs)");
        Assert.assertTrue((boolean)array[32].contains("HostObjectTestAPI"), (String)"Error while search API by part of the provider (searchAPIs)");
        Assert.assertTrue((!array[33].contains("HostObjectTestAPI") ? 1 : 0) != 0, (String)"Error while search API by invalid search key (searchAPIs)");
        Assert.assertTrue((boolean)array[34].contains("true"), (String)"Error while update Tier Permissions from API store host object (updateTierPermissions)");
        return true;
    }

    private void copySampleFile(String sourcePath, String destPath) {
        File sourceFile = new File(sourcePath);
        File destFile = new File(destPath);
        try {
            FileManipulator.copyFile((File)sourceFile, (File)destFile);
        }
        catch (IOException e) {
            this.log.error((Object)"Error while copying the other into Jaggery server", (Throwable)e);
        }
    }

    private String computeDestPath(String fileName) {
        String serverRoot = System.getProperty("carbon.home");
        String deploymentPath = serverRoot + "/repository/deployment/server/jaggeryapps/testapp";
        File depFile = new File(deploymentPath);
        if (!depFile.exists() && !depFile.mkdir()) {
            this.log.error((Object)("Error while creating the deployment folder : " + deploymentPath));
        }
        return deploymentPath + File.separator + fileName;
    }

    private String computeSourcePath(String fileName) {
        return this.getAMResourceLocation() + File.separator + "jaggery/" + fileName;
    }
}

