/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.jwt;

import java.io.File;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.apache.axis2.client.Stub;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.client.utils.AuthenticateStub;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.monitor.utils.WireMonitorServer;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;
import org.wso2.carbon.tenant.mgt.stub.TenantMgtAdminServiceExceptionException;
import org.wso2.carbon.tenant.mgt.stub.TenantMgtAdminServiceStub;
import org.wso2.carbon.tenant.mgt.stub.beans.xsd.TenantInfoBean;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class EmailUserNameJWTAssertionTestCase
extends APIMIntegrationBaseTest {
    private APIStoreRestClient apiStore;
    private String consumerKey;
    private String consumerSecret;
    private String userName;
    private String password;
    private static final Log log = LogFactory.getLog(EmailUserNameJWTAssertionTestCase.class);

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.userName = this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName();
        this.password = this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword();
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        String apiManagerXml = this.getAMResourceLocation() + File.separator + "configFiles/emailusernamejwttest/" + "api-manager.xml";
        String userMgtXml = this.getAMResourceLocation() + File.separator + "configFiles/emailusernamejwttest/" + "user-mgt.xml";
        ServerConfigurationManager serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
        serverConfigurationManager.applyConfigurationWithoutRestart(new File(apiManagerXml));
        serverConfigurationManager.applyConfiguration(new File(userMgtXml));
        APIPublisherRestClient apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        apiPublisher.login(this.userName, this.password);
        APIRequest apiRequest = new APIRequest("test", "test", new URL("http://localhost:6789"));
        apiRequest.setVisibility("public");
        apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("test", this.userName, APILifeCycleState.PUBLISHED);
        apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.apiStore.login(this.userName, this.password);
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("test", this.userName);
        this.apiStore.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("DefaultApplication");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        this.consumerKey = response.getJSONObject("data").getJSONObject("key").get("consumerKey").toString();
        this.consumerSecret = response.getJSONObject("data").getJSONObject("key").get("consumerSecret").toString();
    }

    @Test(groups={"wso2.am"}, description="username JWT-Token Generation test for super tenant")
    public void userNameInSuperTenantJWTTokenTestCase() throws Exception {
        String requestBody = "grant_type=password&username=" + this.userName + "&password=" + this.password;
        URL tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "token");
        JSONObject accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, requestBody, tokenEndpointURL).getData());
        String accessToken = accessTokenGenerationResponse.getString("access_token");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        Thread.sleep(2000L);
        WireMonitorServer wireServer = new WireMonitorServer(6789);
        wireServer.start();
        HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + "test/1.0.0/"), requestHeaders);
        String wireLog = wireServer.getCapturedMessage();
        if (wireLog.contains("JWT-Assertion: ")) {
            wireLog = wireLog.split("JWT-Assertion: ")[1];
            int firstDotSeparatorIndex = wireLog.indexOf(46);
            int secondSeparatorIndex = wireLog.indexOf(46, firstDotSeparatorIndex + 1);
            String JWTToken = wireLog.substring(firstDotSeparatorIndex + 1, secondSeparatorIndex);
            byte[] decodedJwt = Base64.decodeBase64((byte[])JWTToken.getBytes());
            JSONObject jsonObject = new JSONObject(new String(decodedJwt));
            Assert.assertEquals((Object)jsonObject.get("iss"), (Object)"wso2.org/products/am");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/subscriber"), (Object)"admin");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/applicationid"), (Object)"1");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/applicationname"), (Object)"DefaultApplication");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/applicationtier"), (Object)"Unlimited");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/apicontext"), (Object)"/test");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/version"), (Object)"1.0.0");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/tier"), (Object)"Gold");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/keytype"), (Object)"PRODUCTION");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/usertype"), (Object)"APPLICATION_USER");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/enduser"), (Object)"admin@carbon.super");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/enduserTenantId"), (Object)"-1234");
        }
    }

    @Test(groups={"wso2.am"}, description="email username JWT-Token Generation test for super tenant", dependsOnMethods={"userNameInSuperTenantJWTTokenTestCase"})
    public void emailUserNameInSuperTenantJWTTokenTestCase() throws Exception {
        String userName = "admin@wso2.com";
        String password = "admin123";
        this.userManagementClient.addUser(userName, password, new String[]{"Internal/subscriber"}, "admin2");
        String requestBody = "grant_type=password&username=" + userName + "@" + "carbon.super" + "&password=" + password;
        URL tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "token");
        JSONObject accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, requestBody, tokenEndpointURL).getData());
        String userAccessToken = accessTokenGenerationResponse.getString("access_token");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + userAccessToken);
        Thread.sleep(2000L);
        WireMonitorServer wireServer = new WireMonitorServer(6789);
        wireServer.start();
        HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + "test/1.0.0/"), requestHeaders);
        String wireLog = wireServer.getCapturedMessage();
        if (wireLog.contains("JWT-Assertion: ")) {
            wireLog = wireLog.split("JWT-Assertion: ")[1];
            int firstDotSeparatorIndex = wireLog.indexOf(46);
            int secondSeparatorIndex = wireLog.indexOf(46, firstDotSeparatorIndex + 1);
            String JWTToken = wireLog.substring(firstDotSeparatorIndex + 1, secondSeparatorIndex);
            byte[] decodedJwt = Base64.decodeBase64((byte[])JWTToken.getBytes());
            JSONObject jsonObject = new JSONObject(new String(decodedJwt));
            Assert.assertEquals((Object)jsonObject.get("iss"), (Object)"wso2.org/products/am");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/subscriber"), (Object)userName);
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/applicationid"), (Object)"1");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/applicationname"), (Object)"DefaultApplication");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/applicationtier"), (Object)"Unlimited");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/apicontext"), (Object)"/test");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/version"), (Object)"1.0.0");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/tier"), (Object)"Gold");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/keytype"), (Object)"PRODUCTION");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/usertype"), (Object)"APPLICATION_USER");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/enduser"), (Object)"admin@wso2.com@carbon.super");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/enduserTenantId"), (Object)"-1234");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/role"), (Object)"Internal/subscriber,Internal/everyone");
        }
    }

    @Test(groups={"wso2.am"}, description="username JWT-Token Generation test for  tenant")
    public void UserNameInTenantJWTTokenTestCase() throws Exception {
        String userName = "tenant";
        String password = "admin123";
        String domainName = "adc.com";
        String fullUserName = userName + "@" + domainName;
        boolean isSuccessful = this.createTenantWithEmailUserName(userName, password, domainName, this.keyManagerContext.getContextUrls().getBackEndUrl());
        Assert.assertEquals((boolean)isSuccessful, (boolean)true);
        UserManagementClient userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), fullUserName, password);
        userManagementClient1.addRemoveRolesOfUser(fullUserName, new String[]{"Internal/subscriber"}, null);
        String requestBody = "grant_type=password&username=" + fullUserName + "&password=" + password;
        URL tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "token");
        JSONObject accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, requestBody, tokenEndpointURL).getData());
        String userAccessToken = accessTokenGenerationResponse.getString("access_token");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + userAccessToken);
        Thread.sleep(2000L);
        WireMonitorServer wireServer = new WireMonitorServer(6789);
        wireServer.start();
        HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + "test/1.0.0/"), requestHeaders);
        String wireLog = wireServer.getCapturedMessage();
        if (wireLog.contains("JWT-Assertion: ")) {
            wireLog = wireLog.split("JWT-Assertion: ")[1];
            int firstDotSeparatorIndex = wireLog.indexOf(46);
            int secondSeparatorIndex = wireLog.indexOf(46, firstDotSeparatorIndex + 1);
            String JWTToken = wireLog.substring(firstDotSeparatorIndex + 1, secondSeparatorIndex);
            byte[] decodedJwt = Base64.decodeBase64((byte[])JWTToken.getBytes());
            JSONObject jsonObject = new JSONObject(new String(decodedJwt));
            Assert.assertEquals((Object)jsonObject.get("iss"), (Object)"wso2.org/products/am");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/subscriber"), (Object)"admin");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/applicationid"), (Object)"1");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/applicationname"), (Object)"DefaultApplication");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/applicationtier"), (Object)"Unlimited");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/apicontext"), (Object)"/test");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/version"), (Object)"1.0.0");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/tier"), (Object)"Gold");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/keytype"), (Object)"PRODUCTION");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/usertype"), (Object)"APPLICATION_USER");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/enduser"), (Object)"tenant@adc.com");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/givenname"), (Object)"admin");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/lastname"), (Object)"adminwso2automation");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/role"), (Object)"admin,Internal/subscriber,Internal/everyone");
        }
    }

    @Test(groups={"wso2.am"}, description="email username JWT-Token Generation test for  tenant")
    public void emailUserNameInTenantJWTTokenTestCase() throws Exception {
        String userNameWithEmail = "tenant@wso2.com";
        String password = "admin123";
        String domainName = "adc.com";
        String fullUserName = userNameWithEmail + "@" + domainName;
        UserManagementClient userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), "tenant@adc.com", "admin123");
        userManagementClient1.addUser(userNameWithEmail, password, new String[]{"Internal/subscriber"}, "abc");
        String requestBody = "grant_type=password&username=" + fullUserName + "&password=" + password;
        URL tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "token");
        JSONObject accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, requestBody, tokenEndpointURL).getData());
        String userAccessToken = accessTokenGenerationResponse.getString("access_token");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + userAccessToken);
        Thread.sleep(2000L);
        WireMonitorServer wireServer = new WireMonitorServer(6789);
        wireServer.start();
        HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + "test/1.0.0/"), requestHeaders);
        String wireLog = wireServer.getCapturedMessage();
        if (wireLog.contains("JWT-Assertion: ")) {
            wireLog = wireLog.split("JWT-Assertion: ")[1];
            int firstDotSeparatorIndex = wireLog.indexOf(46);
            int secondSeparatorIndex = wireLog.indexOf(46, firstDotSeparatorIndex + 1);
            String JWTToken = wireLog.substring(firstDotSeparatorIndex + 1, secondSeparatorIndex);
            byte[] decodedJwt = Base64.decodeBase64((byte[])JWTToken.getBytes());
            JSONObject jsonObject = new JSONObject(new String(decodedJwt));
            Assert.assertEquals((Object)jsonObject.get("iss"), (Object)"wso2.org/products/am");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/subscriber"), (Object)"admin");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/applicationid"), (Object)"1");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/applicationname"), (Object)"DefaultApplication");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/applicationtier"), (Object)"Unlimited");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/apicontext"), (Object)"/test");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/version"), (Object)"1.0.0");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/tier"), (Object)"Gold");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/keytype"), (Object)"PRODUCTION");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/usertype"), (Object)"APPLICATION_USER");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/enduser"), (Object)"tenant@wso2.com@adc.com");
            Assert.assertEquals((Object)jsonObject.get("http://wso2.org/claims/role"), (Object)"Internal/subscriber,Internal/everyone");
        }
    }

    private boolean createTenantWithEmailUserName(String userNameWithEmail, String pwd, String domainName, String backendUrl) {
        boolean isSuccess = false;
        try {
            String endPoint = backendUrl + "TenantMgtAdminService";
            TenantMgtAdminServiceStub tenantMgtAdminServiceStub = new TenantMgtAdminServiceStub(endPoint);
            AuthenticateStub.authenticateStub((String)"admin", (String)"admin", (Stub)tenantMgtAdminServiceStub);
            Date date = new Date();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            TenantInfoBean tenantInfoBean = new TenantInfoBean();
            tenantInfoBean.setActive(true);
            tenantInfoBean.setEmail("abc@fds.com");
            tenantInfoBean.setAdminPassword(pwd);
            tenantInfoBean.setAdmin(userNameWithEmail);
            tenantInfoBean.setTenantDomain(domainName);
            tenantInfoBean.setCreatedDate((Calendar)calendar);
            tenantInfoBean.setFirstname("admin");
            tenantInfoBean.setLastname("adminwso2automation");
            tenantInfoBean.setSuccessKey("true");
            tenantInfoBean.setUsagePlan("demo");
            TenantInfoBean tenantInfoBeanGet = tenantMgtAdminServiceStub.getTenant(domainName);
            if (!tenantInfoBeanGet.getActive() && tenantInfoBeanGet.getTenantId() != 0) {
                tenantMgtAdminServiceStub.activateTenant(domainName);
                log.info((Object)("Tenant domain " + domainName + " Activated successfully"));
            } else if (!tenantInfoBeanGet.getActive()) {
                tenantMgtAdminServiceStub.addTenant(tenantInfoBean);
                tenantMgtAdminServiceStub.activateTenant(domainName);
                log.info((Object)("Tenant domain " + domainName + " created and activated successfully"));
                isSuccess = true;
            } else {
                log.info((Object)("Tenant domain " + domainName + " already registered"));
            }
        }
        catch (RemoteException e) {
            log.error((Object)"RemoteException thrown while adding user/tenants : ", (Throwable)e);
        }
        catch (TenantMgtAdminServiceExceptionException e) {
            log.error((Object)"Error connecting to the TenantMgtAdminService : ", (Throwable)e);
        }
        return isSuccess;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

