/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.jwt;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.user.RemoteUserStoreManagerServiceClient;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class URLSafeJWTTestCase
extends APIMIntegrationBaseTest {
    private ServerConfigurationManager serverConfigurationManager;
    private UserManagementClient userManagementClient1;
    private static final Log log = LogFactory.getLog(URLSafeJWTTestCase.class);
    private String publisherURLHttp;
    private String storeURLHttp;
    private final String INTERNAL_ROLE_SUBSCRIBER = "Internal/subscriber";
    private final String ROLE_SUBSCRIBER = "subscriber";
    private final String JWT_ASSERTION_HEADER = "X-JWT-Assertion";
    private String apiName = "URLSafeJWTTokenTestAPI";
    private String apiContext = "urlSafeTokenTest";
    private String tags = "token, jwt";
    private String description = "This is test API created by API manager integration test";
    private String providerName;
    private String apiVersion = "1.0.0";
    private String applicationName = "URLSafeJWTTest-application";
    private String backendURL;
    String subscriberUser = "subscriberUser1";
    String subscriberUserWithTenantDomain;
    String password = "password@123";

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.subscriberUserWithTenantDomain = this.subscriberUser + "@" + this.user.getUserDomain();
        this.publisherURLHttp = this.getPublisherURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
            this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "tokenTest" + File.separator + "urlSafeTokenTest" + File.separator + "api-manager.xml"));
            this.serverConfigurationManager.applyConfiguration(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "tokenTest" + File.separator + "urlSafeTokenTest" + File.separator + "log4j.properties"));
            this.subscriberUserWithTenantDomain = this.subscriberUser;
            String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
            this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "jwt_backend.xml", this.gatewayContextMgt, gatewaySessionCookie);
        }
        this.backendURL = this.getSuperTenantAPIInvocationURLHttp("jwt_backend", "1.0");
        this.providerName = this.user.getUserName();
    }

    @Test(groups={"wso2.am"}, description="Enabling JWT Token generation, admin user claims", enabled=true)
    public void testEnableJWTAndClaims() throws Exception {
        RemoteUserStoreManagerServiceClient remoteUserStoreManagerServiceClient = new RemoteUserStoreManagerServiceClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.user.getUserName(), this.user.getPassword());
        String profile = "default";
        remoteUserStoreManagerServiceClient.setUserClaimValue(this.user.getUserNameWithoutDomain(), "http://wso2.org/claims/givenname", "first name", profile);
        remoteUserStoreManagerServiceClient.setUserClaimValue(this.user.getUserNameWithoutDomain(), "http://wso2.org/claims/lastname", "last name", profile);
        super.init(this.userMode);
        this.addAPI(this.apiName, this.apiVersion, this.apiContext, this.description, this.backendURL, this.tags, this.providerName);
        APIStoreRestClient apiStoreRestClient = new APIStoreRestClient(this.storeURLHttp);
        apiStoreRestClient.login(this.user.getUserName(), this.user.getPassword());
        apiStoreRestClient.addApplication(this.applicationName, "50PerMin", "", "this-is-test");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(this.apiName, this.user.getUserName());
        subscriptionRequest.setApplicationName(this.applicationName);
        apiStoreRestClient.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(this.applicationName);
        String responseString = apiStoreRestClient.generateApplicationKey(generateAppKeyRequest).getData();
        String accessToken = new JSONObject(responseString).getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
        get.addHeader("Authorization", "Bearer " + accessToken);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Header[] responseHeaders = response.getAllHeaders();
        Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTHeaderString = APIMTestCaseUtils.getDecodedURLSafeJWTHeader((String)jwtheader.getValue());
        if (decodedJWTHeaderString != null) {
            log.debug((Object)("Decoded JWT header String = " + decodedJWTHeaderString));
            JSONObject jsonHeaderObject = new JSONObject(decodedJWTHeaderString);
            Assert.assertEquals((String)jsonHeaderObject.getString("typ"), (String)"JWT");
            Assert.assertEquals((String)jsonHeaderObject.getString("alg"), (String)"RS256");
        }
        String decodedJWTString = APIMTestCaseUtils.getDecodedURLSafeJWT((String)jwtheader.getValue());
        log.debug((Object)("Decoded JWTString = " + decodedJWTString));
        JSONObject jsonObject = new JSONObject(decodedJWTString);
        this.checkDefaultUserClaims(jsonObject);
        String claim = jsonObject.getString("http://wso2.org/claims/givenname");
        AssertJUnit.assertTrue((String)("JWT claim givenname  not received" + claim), (boolean)claim.contains("first name"));
        claim = jsonObject.getString("http://wso2.org/claims/lastname");
        AssertJUnit.assertTrue((String)("JWT claim lastname  not received" + claim), (boolean)claim.contains("last name"));
        boolean bExceptionOccured = false;
        try {
            jsonObject.getString("http://wso2.org/claims/wrongclaim");
        }
        catch (JSONException e) {
            bExceptionOccured = true;
        }
        AssertJUnit.assertTrue((String)"JWT claim invalid  claim received", (boolean)bExceptionOccured);
    }

    @Test(groups={"wso2.am"}, description="JWT Token generation when JWT caching is enabled", enabled=true, dependsOnMethods={"testEnableJWTAndClaims"})
    public void testAPIAccessWhenJWTCachingEnabledTestCase() throws APIManagerIntegrationTestException, XPathExpressionException, IOException, JSONException, InterruptedException {
        String applicationName = "JWTTokenCacheTestApp";
        String apiName = "JWTTokenCacheTestAPI";
        String apiContext = "JWTTokenCacheTestAPI";
        String apiVersion = "1.0.0";
        String description = "JWTTokenCacheTestAPI description";
        String tags = "token,jwt,cache";
        int waitingSecs = 20;
        this.addAPI(apiName, apiVersion, apiContext, description, this.backendURL, tags, this.providerName);
        APIStoreRestClient apiStoreRestClient = new APIStoreRestClient(this.storeURLHttp);
        apiStoreRestClient.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        apiStoreRestClient.addApplication(applicationName, "50PerMin", "", "this-is-test");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(apiName, this.storeContext.getContextTenant().getContextUser().getUserName());
        subscriptionRequest.setApplicationName(applicationName);
        apiStoreRestClient.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(applicationName);
        String responseString = apiStoreRestClient.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        String url = this.getAPIInvocationURLHttp(apiContext, apiVersion);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse httpResponse = HttpRequestUtil.doGet((String)url, headers);
        AssertJUnit.assertEquals((String)("GET request failed for " + url), (int)200, (int)httpResponse.getResponseCode());
        log.info((Object)("Waiting " + waitingSecs + " sec(s) till claims local cache is invalidated"));
        Thread.sleep(waitingSecs * 1000);
        httpResponse = HttpRequestUtil.doGet((String)url, headers);
        AssertJUnit.assertEquals((String)("GET request failed for " + url + ". Most probably due to a failed invalidated cache access to retrieve JWT claims."), (int)200, (int)httpResponse.getResponseCode());
    }

    private void checkDefaultUserClaims(JSONObject jsonObject) throws JSONException {
        String claim = jsonObject.getString("iss");
        AssertJUnit.assertTrue((String)"JWT assertion is invalid", (boolean)claim.contains("wso2.org/products/am"));
        claim = jsonObject.getString("http://wso2.org/claims/subscriber");
        AssertJUnit.assertTrue((String)("JWT claim subscriber invalid. Received " + claim), (boolean)claim.contains(this.user.getUserName()));
        claim = jsonObject.getString("http://wso2.org/claims/applicationname");
        AssertJUnit.assertTrue((String)("JWT claim applicationname invalid. Received " + claim), (boolean)claim.contains(this.applicationName));
        claim = jsonObject.getString("http://wso2.org/claims/applicationtier");
        AssertJUnit.assertTrue((String)("JWT claim applicationtier invalid. Received " + claim), (boolean)claim.contains("50PerMin"));
        claim = jsonObject.getString("http://wso2.org/claims/apicontext");
        AssertJUnit.assertTrue((String)("JWT claim apicontext invalid. Received " + claim), (boolean)claim.contains("/" + this.apiContext + "/" + jsonObject.getString("http://wso2.org/claims/version")));
        claim = jsonObject.getString("http://wso2.org/claims/version");
        AssertJUnit.assertTrue((String)("JWT claim version invalid. Received " + claim), (boolean)claim.contains(this.apiVersion));
        claim = jsonObject.getString("http://wso2.org/claims/tier");
        AssertJUnit.assertTrue((String)("JWT claim tier invalid. Received " + claim), (boolean)claim.contains("Gold"));
        claim = jsonObject.getString("http://wso2.org/claims/keytype");
        AssertJUnit.assertTrue((String)("JWT claim keytype invalid. Received " + claim), (boolean)claim.contains("PRODUCTION"));
        claim = jsonObject.getString("http://wso2.org/claims/usertype");
        AssertJUnit.assertTrue((String)("JWT claim usertype invalid. Received " + claim), (boolean)claim.contains("APPLICATION"));
        JSONArray roleClaim = jsonObject.getJSONArray("http://wso2.org/claims/role");
        String roles = roleClaim.toString();
        AssertJUnit.assertTrue((String)("JWT claim role invalid. Received " + roles), (roles.contains("admin") && roles.contains("Internal/everyone") ? 1 : 0) != 0);
    }

    @Test(groups={"wso2.am"}, description="Enabling JWT Token generation, specific user claims", enabled=true, dependsOnMethods={"testAPIAccessWhenJWTCachingEnabledTestCase"})
    public void testSpecificUserJWTClaims() throws Exception {
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.user.getUserName(), this.user.getPassword());
        if (!this.userManagementClient1.roleNameExists("Internal/subscriber")) {
            this.userManagementClient1.addInternalRole("subscriber", new String[0], new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"});
        }
        if (this.userManagementClient1 != null && !this.userManagementClient1.userNameExists("Internal/subscriber", this.subscriberUser)) {
            this.userManagementClient1.addUser(this.subscriberUser, this.password, new String[]{"Internal/subscriber"}, null);
        }
        RemoteUserStoreManagerServiceClient remoteUserStoreManagerServiceClient = new RemoteUserStoreManagerServiceClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.user.getUserName(), this.user.getPassword());
        String profile = "default";
        remoteUserStoreManagerServiceClient.setUserClaimValue(this.subscriberUser, "http://wso2.org/claims/givenname", "subscriber given name", profile);
        remoteUserStoreManagerServiceClient.setUserClaimValue(this.subscriberUser, "http://wso2.org/claims/lastname", "subscriber last name", profile);
        super.init(this.userMode);
        this.waitForAPIDeploymentSync(this.providerName, this.apiName, this.apiVersion, "\"isApiExists\":true");
        APIStoreRestClient apiStoreRestClient = new APIStoreRestClient(this.storeURLHttp);
        apiStoreRestClient.login(this.subscriberUserWithTenantDomain, this.password);
        apiStoreRestClient.addApplication(this.applicationName, "50PerMin", "", "this-is-test");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(this.apiName, this.providerName);
        subscriptionRequest.setApplicationName(this.applicationName);
        apiStoreRestClient.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(this.applicationName);
        String responseString = apiStoreRestClient.generateApplicationKey(generateAppKeyRequest).getData();
        String accessToken = new JSONObject(responseString).getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
        get.addHeader("Authorization", "Bearer " + accessToken);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Header[] responseHeaders = response.getAllHeaders();
        Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTString = APIMTestCaseUtils.getDecodedURLSafeJWT((String)jwtheader.getValue());
        log.debug((Object)("Decoded JWTString = " + decodedJWTString));
        JSONObject jsonObject = new JSONObject(decodedJWTString);
        String claim = jsonObject.getString("iss");
        AssertJUnit.assertTrue((String)"JWT assertion is invalid", (boolean)claim.contains("wso2.org/products/am"));
        claim = jsonObject.getString("http://wso2.org/claims/subscriber");
        AssertJUnit.assertTrue((String)("JWT claim subscriber invalid. Received " + claim), (boolean)claim.contains(this.subscriberUser));
        claim = jsonObject.getString("http://wso2.org/claims/applicationname");
        AssertJUnit.assertTrue((String)("JWT claim applicationname invalid. Received " + claim), (boolean)claim.contains(this.applicationName));
        apiStoreRestClient.removeAPISubscriptionByApplicationName(this.apiName, this.apiVersion, this.providerName, this.applicationName);
        apiStoreRestClient.removeApplication(this.applicationName);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
        if (this.userManagementClient1 != null) {
            this.userManagementClient1.deleteRole("Internal/subscriber");
            this.userManagementClient1.deleteUser(this.subscriberUser);
        }
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.serverConfigurationManager.restoreToLastConfiguration();
        }
    }

    private void addAPI(String apiName, String apiVersion, String apiContext, String description, String endpointURL, String tags, String providerName) throws APIManagerIntegrationTestException, MalformedURLException, XPathExpressionException {
        APIPublisherRestClient apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(endpointURL));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(apiVersion);
        apiRequest.setVisibility("public");
        apiRequest.setProvider(providerName);
        apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(apiName, providerName, APILifeCycleState.PUBLISHED);
        apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.waitForAPIDeploymentSync(providerName, apiName, apiVersion, "\"isApiExists\":true");
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public URLSafeJWTTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }
}

