/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.login;

import java.io.File;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.client.utils.AuthenticateStub;
import org.wso2.am.admin.clients.rest.api.WorkFlowAdminRestClient;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;
import org.wso2.carbon.tenant.mgt.stub.TenantMgtAdminServiceExceptionException;
import org.wso2.carbon.tenant.mgt.stub.TenantMgtAdminServiceStub;
import org.wso2.carbon.tenant.mgt.stub.beans.xsd.TenantInfoBean;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class EmailUserNameLoginTestCase
extends APIMIntegrationBaseTest {
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private WorkFlowAdminRestClient workflowAdmin;
    private static final Log log = LogFactory.getLog(EmailUserNameLoginTestCase.class);
    private ServerConfigurationManager serverConfigurationManager;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        String workflowAdminURLHTTP = this.getStoreURLHttp();
        String apiManagerXml = this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "emailusernametest" + File.separator + "api-manager.xml";
        String userMgtXml = this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "emailusernametest" + File.separator + "user-mgt.xml";
        String carbonXml = this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "emailusernametest" + File.separator + "carbon.xml";
        this.configureServer(apiManagerXml, userMgtXml, carbonXml);
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        this.workflowAdmin = new WorkFlowAdminRestClient(workflowAdminURLHTTP);
    }

    @Test(groups={"wso2.am"}, description="Email username login test case")
    public void LoginWithEmailUserNameTestCase() throws Exception {
        String userNameWithEmail = "emailuser@email.com";
        String password = "email123";
        String domainName = "emailuserdomain.com";
        String fullUserName = userNameWithEmail + "@" + domainName;
        boolean isSuccessful = this.createTenantWithEmailUserName(userNameWithEmail, password, domainName, this.publisherContext.getContextUrls().getBackEndUrl());
        Assert.assertEquals((boolean)isSuccessful, (boolean)true);
        HttpResponse login = this.apiPublisher.login(fullUserName, password);
        Assert.assertEquals((int)login.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Login to Publisher with email username failed");
        login = this.apiStore.login(fullUserName, password);
        Assert.assertEquals((int)login.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Login to Store with email username failed");
        login = this.workflowAdmin.login(fullUserName, password);
        Assert.assertEquals((int)login.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Login to Admin Portal Login to Publisher with email username failed");
    }

    private boolean createTenantWithEmailUserName(String userNameWithEmail, String pwd, String domainName, String backendUrl) throws XPathExpressionException, RemoteException, TenantMgtAdminServiceExceptionException {
        boolean isSuccess = false;
        String endPoint = backendUrl + "TenantMgtAdminService";
        TenantMgtAdminServiceStub tenantMgtAdminServiceStub = new TenantMgtAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub((String)this.publisherContext.getSuperTenant().getContextUser().getUserName(), (String)this.publisherContext.getSuperTenant().getContextUser().getUserName(), (Stub)tenantMgtAdminServiceStub);
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TenantInfoBean tenantInfoBean = new TenantInfoBean();
        tenantInfoBean.setActive(true);
        tenantInfoBean.setEmail(userNameWithEmail);
        tenantInfoBean.setAdminPassword(pwd);
        tenantInfoBean.setAdmin(userNameWithEmail);
        tenantInfoBean.setTenantDomain(domainName);
        tenantInfoBean.setCreatedDate((Calendar)calendar);
        tenantInfoBean.setFirstname("emailuser first name");
        tenantInfoBean.setLastname("email user last name");
        tenantInfoBean.setSuccessKey("true");
        tenantInfoBean.setUsagePlan("demo");
        TenantInfoBean tenantInfoBeanGet = tenantMgtAdminServiceStub.getTenant(domainName);
        if (!tenantInfoBeanGet.getActive() && tenantInfoBeanGet.getTenantId() != 0) {
            tenantMgtAdminServiceStub.activateTenant(domainName);
            log.info((Object)("Tenant domain " + domainName + " Activated successfully"));
        } else if (!tenantInfoBeanGet.getActive() && tenantInfoBeanGet.getTenantId() == 0) {
            tenantMgtAdminServiceStub.addTenant(tenantInfoBean);
            tenantMgtAdminServiceStub.activateTenant(domainName);
            log.info((Object)("Tenant domain " + domainName + " created and activated successfully"));
            log.info((Object)("Tenant domain " + domainName + " created and activated successfully"));
            isSuccess = true;
        } else {
            log.info((Object)("Tenant domain " + domainName + " already registered"));
        }
        return isSuccess;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.serverConfigurationManager.restoreToLastConfiguration();
        super.cleanUp();
    }

    private void configureServer(String apiManagerXml, String userMgtXml, String carbonXml) throws Exception {
        try {
            this.serverConfigurationManager = new ServerConfigurationManager(this.publisherContext);
            this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(apiManagerXml));
            this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(userMgtXml));
            this.serverConfigurationManager.applyConfiguration(new File(carbonXml));
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Error while changing server configuration", (Throwable)e);
        }
    }
}

