/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPathExpressionException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.xml.sax.SAXException;

public class APIApplicationLifeCycleTestCase
extends APIMIntegrationBaseTest {
    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws APIManagerIntegrationTestException, IOException, XPathExpressionException, URISyntaxException, SAXException, XMLStreamException, LoginAuthenticationExceptionException {
        super.init();
    }

    @Test(groups={"wso2.am"}, description="API Life cycle test case")
    public void testAPIApplicationLifeCycleITestCase() throws Exception {
        this.init(TestUserMode.SUPER_TENANT_ADMIN);
        String apiData = "";
        String APIName = "APILifeCycleTestAPI";
        String APIContext = "testAPI";
        String tags = "testTag1, testTag2, testTag3";
        String APIEndpointMethod = "/customers/123";
        String url = "jaxrs_basic/services/customers/customerservice/";
        String description = "This is test API create by API manager integration test";
        String providerName = "admin";
        String APIVersion = "1.0.0";
        String applicationName = "APILifeCycleTestAPI-application";
        String apiContextAddedValue = APIContext + "/" + APIVersion;
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(this.gatewayUrlsWrk.getWebAppURLHttp() + url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setVisibility("restricted");
        apiRequest.setRoles("admin");
        this.apiPublisher.addAPI(apiRequest);
        this.apiPublisher.deleteAPI(APIName, APIVersion, providerName);
        this.apiPublisher.addAPI(apiRequest);
        APIBean apiBean = APIMTestCaseUtils.getAPIBeanFromHttpResponse((HttpResponse)this.apiPublisher.getAPI(APIName, providerName));
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertEquals((String)apiBean.getId().getApiName(), (String)APIName, (String)"API Name mismatch");
        Assert.assertEquals((String)apiBean.getContext().trim().substring(apiBean.getContext().indexOf("/") + 1), (String)apiContextAddedValue, (String)"API context mismatch");
        Assert.assertEquals((String)apiBean.getId().getVersion(), (String)APIVersion, (String)"API version mismatch");
        Assert.assertEquals((String)apiBean.getId().getProviderName(), (String)providerName, (String)"Provider Name mismatch");
        for (String tag : apiBean.getTags()) {
            Assert.assertTrue((boolean)tags.contains(tag), (String)"API tag data mismatched");
        }
        Assert.assertEquals((String)apiBean.getDescription(), (String)description, (String)"API description mismatch");
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        HttpResponse addApplicationResponse = this.apiStore.addApplication(applicationName, "10PerMin", "", "this-is-test");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(APIName, this.storeContext.getContextTenant().getContextUser().getUserName());
        subscriptionRequest.setApplicationName(applicationName);
        HttpResponse subscribeResponse = this.apiStore.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(applicationName);
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "application/json");
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        HttpResponse apiResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(APIContext, APIVersion) + APIEndpointMethod), requestHeaders);
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)200, (String)"Response code mismatched");
        requestHeaders.clear();
        requestHeaders.put("Authorization", "Bearer -wrong-tokent-text-");
        HttpResponse apiResponseError = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(APIContext, APIVersion) + APIEndpointMethod), requestHeaders);
        Assert.assertEquals((int)apiResponseError.getResponseCode(), (int)401, (String)"Response code mismatched");
        this.apiStore.getAllPublishedAPIs();
        this.apiStore.getAllApplications();
        this.apiStore.getPublishedAPIsByApplication(applicationName);
        this.apiStore.isRatingActivated();
        this.apiStore.addRatingToAPI(APIName, APIVersion, providerName, "4");
        this.apiStore.addRatingToAPI(APIName, APIVersion, providerName, "2");
        this.apiStore.addRatingToAPI(APIName, APIVersion, providerName, "1");
        this.apiStore.removeRatingFromAPI(APIName, APIVersion, providerName);
        this.apiStore.getAllDocumentationOfAPI(APIName, APIVersion, providerName);
        this.apiStore.getPublishedAPIsByApplication("APILifeCycleTestAPI-application-wrong");
        this.apiStore.isRatingActivated();
        this.apiStore.addRatingToAPI("NoAPI", APIVersion, providerName, "4");
        this.apiStore.removeRatingFromAPI("NoAPI", APIVersion, providerName);
        this.apiStore.getAllDocumentationOfAPI("NoAPI", APIVersion, providerName);
        apiRequest.setTags("updated");
        apiRequest.setProvider("admin");
        Thread.sleep(1000L);
        this.apiPublisher.updateAPI(apiRequest);
        this.waitForAPIDeployment();
        this.apiPublisher.addDocument(APIName, APIVersion, providerName, "Doc Name", "How To", "In-line", "url-no-need", "summary", "", "", "");
        this.apiPublisher.addDocument(APIName, APIVersion, providerName, "Doc Name1", "How To", "URL", "http://www.businesstoday.lk/article.php?article=3549", "summary", "", "", null);
        this.apiPublisher.addDocument(APIName, APIVersion, providerName, "Doc Name2", "How To", " File", "url-no-need", "summary", this.getAMResourceLocation() + File.separator + "configFiles/tokenTest/" + "api-manager.xml", "", "");
        this.apiPublisher.removeDocumentation(APIName, APIVersion, providerName, "Doc Name", "How To");
        this.apiStore.addApplication("test-application", "20PerMin", "", "this-is-test");
        this.apiStore.addApplication("test-application2", "20PerMin", "", "this-is-test");
        this.apiStore.getAllApplications();
        SubscriptionRequest subscriptionRequest1 = new SubscriptionRequest(APIName, this.storeContext.getContextTenant().getContextUser().getUserName());
        subscriptionRequest1.setApplicationName("test-application");
        this.apiStore.subscribe(subscriptionRequest1);
        APPKeyRequestGenerator generateAppKeyRequest1 = new APPKeyRequestGenerator("test-application");
        String responseString1 = this.apiStore.generateApplicationKey(generateAppKeyRequest1).getData();
        JSONObject response1 = new JSONObject(responseString1);
        String accessToken1 = response1.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeaders1 = new HashMap<String, String>();
        requestHeaders1.put("Authorization", "Bearer " + accessToken1);
        requestHeaders1.put("accept", "application/json");
        HttpResponse apiResponseTestApp = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(APIContext, APIVersion) + APIEndpointMethod), requestHeaders1);
        for (int i = 0; i < 15; ++i) {
            apiResponseTestApp = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(APIContext, APIVersion) + APIEndpointMethod), requestHeaders1);
        }
        Assert.assertEquals((int)apiResponseTestApp.getResponseCode(), (int)200, (String)"Response code mismatched");
        this.apiStore.isCommentActivated();
        this.apiStore.addComment(APIName, APIVersion, providerName, "this-is-comment");
        this.apiStore.getRecentlyAddedAPIs("carbon.super", "5");
        this.apiStore.updateApplication("test-application", "test-updated-application", "test-url", "this-is-updated", "bronze");
        this.apiStore.getAllApplications();
        apiData = this.apiStore.removeApplication("test-updated-application").getData();
        Assert.assertTrue((boolean)apiData.contains("false"), (String)"Error while removing applications");
        this.apiStore.getAllApplications();
        apiData = this.apiStore.getAllSubscriptions().getData();
        Assert.assertTrue((boolean)apiData.contains("test-application"), (String)"Error while getting all the subscriptions");
        this.apiStore.getAllTags();
        HttpResponse updateTierPermissionResponse = this.apiPublisher.updatePermissions("Gold", "Deny", "admin");
        JSONObject jsonObject = new JSONObject(updateTierPermissionResponse.getData());
        Assert.assertTrue(((Boolean)jsonObject.get("error") == false ? 1 : 0) != 0, (String)"Error while updating tier permission");
        HttpResponse removeSubscriptionnResponse = this.apiStore.removeAPISubscription(APIName, APIVersion, providerName, "1");
        apiData = removeSubscriptionnResponse.getData();
        Assert.assertTrue((boolean)apiData.contains("error"), (String)"Error while unsubscribe from API");
        this.apiStore.removeApplication(applicationName);
        this.apiPublisher.updatePermissions("Gold", "allow", "admin");
        this.apiPublisher.logout();
    }

    @Test(groups={"wso2.am"}, description="API Life cycle test invalid scenario", dependsOnMethods={"testAPIApplicationLifeCycleITestCase"})
    public void testInvalidLoginAsPublisherTestCase() {
        APIPublisherRestClient apiPublisherRestClient = new APIPublisherRestClient(this.publisherURLHttp);
        boolean loginFailed = false;
        String loginResponseString = "";
        try {
            HttpResponse invalidLoginResponse = apiPublisherRestClient.login(this.publisherContext.getContextTenant().getContextUser().getUserName() + "invalid", this.publisherContext.getContextTenant().getContextUser().getPassword());
            loginResponseString = invalidLoginResponse.getData();
            JSONObject response = new JSONObject(loginResponseString);
            String isLoginError = response.get("error").toString();
            if (isLoginError.equals("true")) {
                loginFailed = true;
            }
        }
        catch (Exception e) {
            loginFailed = true;
        }
        Assert.assertTrue((loginFailed && loginResponseString.contains("Login failed. Please recheck the username and password and try again..") ? 1 : 0) != 0, (String)"Invalid user can login to the API publisher");
    }

    @Test(groups={"wso2.am"}, description="API Life cycle test subscriber login")
    public void testInvalidLoginAsSubscriberTestCase() throws Exception {
        APIPublisherRestClient apiPublisherRestClient = new APIPublisherRestClient(this.publisherURLHttp);
        boolean loginFailed = false;
        String loginResponseString = "";
        if (this.userManagementClient != null && !this.userManagementClient.userNameExists("Internal/subscriber", "subscriberUser")) {
            this.userManagementClient.addUser("subscriberUser", "password@123", new String[]{"Internal/subscriber"}, null);
        }
        try {
            HttpResponse loginResponse = apiPublisherRestClient.login("subscriberUser", "password@123");
            loginResponseString = loginResponse.getData();
            JSONObject response = new JSONObject(loginResponseString);
            String isLoginError = response.get("error").toString();
            if (isLoginError.equals("true")) {
                loginFailed = true;
            }
        }
        catch (Exception e) {
            loginFailed = true;
        }
        Assert.assertTrue((loginFailed && loginResponseString.contains("Login failed. Insufficient privileges.") ? 1 : 0) != 0, (String)"Invalid subscriber can login to the API publisher");
    }

    @Test(groups={"wso2.am"}, description="API visibility")
    public void testAPIVisibilityTestCase() throws Exception {
        this.init(TestUserMode.SUPER_TENANT_ADMIN);
        this.userManagementClient.addUser("subscriberUser1", "password@123", new String[]{"Internal/everyone"}, null);
        APIPublisherRestClient apiPublisherRestClient = new APIPublisherRestClient(this.publisherURLHttp);
        apiPublisherRestClient.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.addPublicAPI(apiPublisherRestClient);
        this.addVisibleToDomainOnlyAPI(apiPublisherRestClient);
        this.addVisibleToRolesAPI(apiPublisherRestClient);
        boolean bPublishedAPI = false;
        APIStoreRestClient apiStore1 = new APIStoreRestClient(this.storeURLHttp);
        apiStore1.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        String publishedAPIs = apiStore1.getAllPublishedAPIs().getData();
        bPublishedAPI = false;
        if (publishedAPIs.contains("APILifeCycleTestAPIPublic") && publishedAPIs.contains("APILifeCycleTestAPIDomainOnly") && publishedAPIs.contains("APILifeCycleTestAPIRoles")) {
            bPublishedAPI = true;
        }
        Assert.assertTrue((boolean)bPublishedAPI, (String)"Admin user cannot view all API's");
        if (this.userManagementClient != null && !this.userManagementClient.userNameExists("Internal/subscriber", "subscriberUser")) {
            this.userManagementClient.addUser("subscriberUser", "password@123", new String[]{"Internal/subscriber"}, null);
        }
        APIStoreRestClient apiStore2 = new APIStoreRestClient(this.storeURLHttp);
        apiStore2.login("subscriberUser", "password@123");
        publishedAPIs = apiStore2.getAllPublishedAPIs().getData();
        bPublishedAPI = false;
        if (publishedAPIs.contains("APILifeCycleTestAPIPublic") && publishedAPIs.contains("APILifeCycleTestAPIDomainOnly") && !publishedAPIs.contains("APILifeCycleTestAPIRoles")) {
            bPublishedAPI = true;
        }
    }

    @Test(groups={"wso2.am"}, description="API visibility")
    public void copyAPILifeCycleTestCase() throws Exception {
        String APIName = "APILifeCycleTestAPI";
        String APIContext = "testAPI";
        String tags = "testTag1, testTag2, testTag3";
        String APIEndpointMethod = "/customers/123";
        String url = "jaxrs_basic/services/customers/customerservice/";
        String description = "This is test API create by API manager integration test";
        String providerName = "admin";
        String APIVersionOld = "1.0.0";
        String APIVersionNew = "2.0.0";
        String defaultVersion = "default_version";
        APIPublisherRestClient apiPublisherRestClient = new APIPublisherRestClient(this.publisherURLHttp);
        apiPublisherRestClient.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(this.gatewayUrlsWrk.getWebAppURLHttp() + url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersionOld);
        apiRequest.setVisibility("restricted");
        apiRequest.setRoles("admin");
        apiPublisherRestClient.addAPI(apiRequest);
        APIBean apiBean = APIMTestCaseUtils.getAPIBeanFromHttpResponse((HttpResponse)apiPublisherRestClient.getAPI(APIName, providerName));
        APILifeCycleStateRequest updateRequest1 = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.PUBLISHED);
        apiPublisherRestClient.changeAPILifeCycleStatus(updateRequest1);
        apiPublisherRestClient.copyAPI(providerName, APIName, APIVersionOld, APIVersionNew, "");
        apiBean = APIMTestCaseUtils.getAPIBeanFromHttpResponse((HttpResponse)apiPublisherRestClient.getAPI(APIName, providerName));
        APILifeCycleStateRequest updateRequest2 = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.PUBLISHED);
        updateRequest2.setVersion(APIVersionNew);
        apiPublisherRestClient.changeAPILifeCycleStatus(updateRequest2);
        APIStoreRestClient apiStore = new APIStoreRestClient(this.storeURLHttp);
        apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        String apiData = apiStore.getAllPublishedAPIs().getData();
        Assert.assertTrue((!apiData.contains("\"name\" : \"APILifeCycleTestAPI\", \"provider\" : \"admin\", \"version\" : \"" + APIVersionOld + '\"') ? 1 : 0) != 0, (String)"Old version available in the store");
        Assert.assertTrue((boolean)apiData.contains("\"name\" : \"APILifeCycleTestAPI\", \"provider\" : \"admin\", \"version\" : \"" + APIVersionNew + '\"'), (String)"New version not available in the store");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(APIName, this.storeContext.getContextTenant().getContextUser().getUserName());
        apiData = apiStore.subscribe(subscriptionRequest).getData();
        Assert.assertTrue((boolean)apiData.contains("{\"error\" : false, \"status\" : {\"subscriptionStatus\" : \"UNBLOCKED\","), (String)"Can subscribe to the old API version");
        subscriptionRequest.setVersion(APIVersionNew);
        apiData = apiStore.subscribe(subscriptionRequest).getData();
        Assert.assertTrue((boolean)apiData.contains("{\"error\" : false, \"status\" : {\"subscriptionStatus\" : \"UNBLOCKED\","), (String)"Cannot subscribe to the new API version");
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("DefaultApplication");
        String responseString = apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "application/json");
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        HttpResponse apiResponse1 = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(APIContext, "1.0.0") + APIEndpointMethod), requestHeaders);
        Assert.assertEquals((int)apiResponse1.getResponseCode(), (int)200, (String)"Response code mismatched");
        HttpResponse apiResponse2 = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(APIContext, "2.0.0") + APIEndpointMethod), requestHeaders);
        Assert.assertEquals((int)apiResponse2.getResponseCode(), (int)200, (String)"Response code mismatched");
    }

    @Test(groups={"wso2.am"}, description="API visibility")
    public void otherAPILifeCycleStatesTestCase() throws Exception {
        String APIName = "APILifeCycleAPI";
        String APIContext = "testVisibility";
        String tags = "testTag1, testTag2, testTag3";
        String url = "jaxrs_basic/services/customers/customerservice/";
        String description = "This is test API created by API manager Integration tests";
        String providerName = "admin";
        String APIVersion = "1.0.0";
        APIPublisherRestClient apiPublisherRestClient = new APIPublisherRestClient(this.publisherURLHttp);
        apiPublisherRestClient.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(this.gatewayUrlsWrk.getWebAppURLHttp() + url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setVisibility("restricted");
        apiRequest.setRoles("admin");
        apiPublisherRestClient.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest1 = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.PUBLISHED);
        apiPublisherRestClient.changeAPILifeCycleStatus(updateRequest1);
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        String apiData = this.apiStore.getAllPublishedAPIs().getData();
        Assert.assertTrue((boolean)apiData.contains(APIName), (String)"Added API not available in store");
        APILifeCycleStateRequest updateRequest2 = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.DEPRECATED);
        apiPublisherRestClient.changeAPILifeCycleStatus(updateRequest2);
        APILifeCycleStateRequest updateRequest3 = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.RETIRED);
        apiPublisherRestClient.changeAPILifeCycleStatus(updateRequest3);
        apiData = this.apiStore.getAllPublishedAPIs().getData();
        Assert.assertTrue((!apiData.contains(APIName) ? 1 : 0) != 0, (String)"Retired API available in store");
        APILifeCycleStateRequest updateRequest4 = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.BLOCKED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest4);
        apiData = this.apiStore.getAllPublishedAPIs().getData();
        Assert.assertTrue((!apiData.contains(APIName) ? 1 : 0) != 0, (String)"Blocked API available in store");
    }

    @Test(groups={"wso2.am"}, description="API visibility")
    public void copyAndDepricateAPILifeCycleTestCase() throws Exception {
        String APIName = "APILifeCycleTestAPI";
        String APIContext = "testAPI";
        String tags = "testTag1, testTag2, testTag3";
        String APIEndpointMethod = "/customers/123";
        String url = "jaxrs_basic/services/customers/customerservice/";
        String description = "This is test API create by API manager integration test";
        String providerName = "admin";
        String APIVersionOld = "1.0.0";
        String APIVersionNew = "3.0.0";
        String applicationName = "TestApplication";
        APIPublisherRestClient apiPublisherRestClient = new APIPublisherRestClient(this.publisherURLHttp);
        apiPublisherRestClient.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(this.gatewayUrlsWrk.getWebAppURLHttp() + url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersionOld);
        apiRequest.setVisibility("restricted");
        apiRequest.setRoles("admin");
        apiPublisherRestClient.addAPI(apiRequest);
        APIBean apiBean = APIMTestCaseUtils.getAPIBeanFromHttpResponse((HttpResponse)apiPublisherRestClient.getAPI(APIName, providerName));
        APILifeCycleStateRequest updateRequest1 = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.PUBLISHED);
        apiPublisherRestClient.changeAPILifeCycleStatus(updateRequest1);
        apiPublisherRestClient.copyAPI(providerName, APIName, APIVersionOld, APIVersionNew, "");
        apiBean = APIMTestCaseUtils.getAPIBeanFromHttpResponse((HttpResponse)apiPublisherRestClient.getAPI(APIName, providerName));
        APILifeCycleStateRequest updateRequest2 = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.PUBLISHED);
        updateRequest2.setVersion(APIVersionNew);
        apiPublisherRestClient.changeAPILifeCycleStatus(updateRequest2);
        apiBean = APIMTestCaseUtils.getAPIBeanFromHttpResponse((HttpResponse)apiPublisherRestClient.getAPI(APIName, providerName));
        APILifeCycleStateRequest updateRequest3 = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.DEPRECATED);
        updateRequest3.setVersion(APIVersionOld);
        apiPublisherRestClient.changeAPILifeCycleStatus(updateRequest3);
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        String apiData = this.apiStore.getAllPublishedAPIs().getData();
        Assert.assertTrue((!apiData.contains("\"name\" : \"APILifeCycleTestAPI\", \"provider\" : \"admin\", \"version\" : \"" + APIVersionOld + '\"') ? 1 : 0) != 0, (String)"Old version available in the store");
        Assert.assertTrue((boolean)apiData.contains("\"name\" : \"APILifeCycleTestAPI\", \"provider\" : \"admin\", \"version\" : \"" + APIVersionNew + '\"'), (String)"New version not available in the store");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(APIName, this.storeContext.getContextTenant().getContextUser().getUserName());
        apiData = this.apiStore.subscribe(subscriptionRequest).getData();
        Assert.assertTrue((boolean)apiData.contains("Error while adding subscription for user: admin. Reason: Subscriptions not allowed on APIs in the state: DEPRECATED"), (String)"Can subscribe to the old API version");
        this.apiStore.addApplication(applicationName, "10PerMin", "", "this-is-test");
        SubscriptionRequest subscriptionAPIRequest = new SubscriptionRequest(APIName, this.storeContext.getContextTenant().getContextUser().getUserName());
        subscriptionAPIRequest.setApplicationName(applicationName);
        subscriptionAPIRequest.setVersion(APIVersionNew);
        this.apiStore.removeAPISubscriptionByName(APIName, APIVersionNew, providerName, "DefaultApplication");
        HttpResponse subscribeResponse = this.apiStore.subscribe(subscriptionAPIRequest);
        apiData = subscribeResponse.getData();
        Assert.assertTrue((boolean)apiData.contains("\"error\" : false"), (String)"Cannot subscribe to the new API version");
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(applicationName);
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "application/json");
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), APIVersionNew, "\"isApiExists\":true");
        HttpResponse apiResponse1 = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(APIContext, APIVersionOld) + APIEndpointMethod), requestHeaders);
        Assert.assertEquals((int)apiResponse1.getResponseCode(), (int)403, (String)"Response code mismatched");
        HttpResponse apiResponse2 = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(APIContext, APIVersionNew) + APIEndpointMethod), requestHeaders);
        Assert.assertEquals((int)apiResponse2.getResponseCode(), (int)200, (String)"Response code mismatched");
    }

    public void addPublicAPI(APIPublisherRestClient apiPublisherRestClient) throws Exception {
        String APIName = "APILifeCycleTestAPIPublic";
        String APIContext = "testAPIPublic";
        String tags = "testTag1, testTag2, testTag3";
        String APIEndpointMethod = "/customers/123";
        String url = "jaxrs_basic/services/customers/customerservice/";
        String description = "This is test API create by API manager integration test";
        String providerName = "admin";
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(this.gatewayUrlsWrk.getWebAppURLHttp() + url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setVisibility("public");
        apiPublisherRestClient.addAPI(apiRequest);
        APIBean apiBean = APIMTestCaseUtils.getAPIBeanFromHttpResponse((HttpResponse)apiPublisherRestClient.getAPI(APIName, providerName));
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.PUBLISHED);
        apiPublisherRestClient.changeAPILifeCycleStatus(updateRequest);
    }

    public void addVisibleToDomainOnlyAPI(APIPublisherRestClient apiPublisherRestClient) throws Exception {
        String APIName = "APILifeCycleTestAPIDomainOnly";
        String APIContext = "testAPIDomainOnly";
        String tags = "testTag1, testTag2, testTag3";
        String APIEndpointMethod = "/customers/123";
        String url = "jaxrs_basic/services/customers/customerservice/";
        String description = "This is test API create by API manager integration test";
        String providerName = "admin";
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(this.gatewayUrlsWrk.getWebAppURLHttp() + url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setVisibility("private");
        apiPublisherRestClient.addAPI(apiRequest);
        APIBean apiBean = APIMTestCaseUtils.getAPIBeanFromHttpResponse((HttpResponse)apiPublisherRestClient.getAPI(APIName, providerName));
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.PUBLISHED);
        apiPublisherRestClient.changeAPILifeCycleStatus(updateRequest);
    }

    public void addVisibleToRolesAPI(APIPublisherRestClient apiPublisherRestClient) throws Exception {
        String APIName = "APILifeCycleTestAPIRoles";
        String APIContext = "testAPIRoles";
        String tags = "testTag1, testTag2, testTag3";
        String APIEndpointMethod = "/customers/123";
        String url = "jaxrs_basic/services/customers/customerservice/";
        String description = "This is test API create by API manager integration test";
        String providerName = "admin";
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(this.gatewayUrlsWrk.getWebAppURLHttp() + url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setVisibility("restricted");
        apiRequest.setRoles("admin");
        apiPublisherRestClient.addAPI(apiRequest);
        APIBean apiBean = APIMTestCaseUtils.getAPIBeanFromHttpResponse((HttpResponse)apiPublisherRestClient.getAPI(APIName, providerName));
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.PUBLISHED);
        apiPublisherRestClient.changeAPILifeCycleStatus(updateRequest);
    }

    @Test(groups={"wso2.am"}, description="API Life cycle application related tests in store")
    public void testApplicationsInStoreTestCase() throws Exception {
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.tenantManagementServiceClient.addTenant("wso2.com", "wso2@123", "wso2", "demo");
        if (this.userManagementClient != null && !this.userManagementClient.userNameExists("Internal/subscriber", "user1@wso2.com")) {
            this.userManagementClient.addUser("user1@wso2.com", "password@123", new String[]{"Internal/subscriber"}, null);
        }
        if (this.userManagementClient != null && !this.userManagementClient.userNameExists("admin", "adminUser@wso2.com")) {
            this.userManagementClient.addUser("adminUser@wso2.com", "wso2@123", new String[]{"admin"}, null);
        }
        this.apiStore.addApplication("carbonSuperApp", "10PerMin", "", "super-tenant-app");
        HttpResponse addApplicationResponse = this.apiStore.addApplication("carbonSuperApp", "10PerMin", "", "super-tenant-app");
        String apiData = addApplicationResponse.getData();
        Assert.assertTrue((boolean)apiData.contains("A duplicate application already exists"), (String)"Application with duplicate name addition allowed");
        APIStoreRestClient apiStoreRestClient2 = new APIStoreRestClient(this.storeURLHttp);
        apiStoreRestClient2.login("adminUser@wso2.com", "wso2@123");
        HttpResponse addApplicationResponse1 = apiStoreRestClient2.addApplication("carbonSuperApp", "10PerMin", "", "super-tenant-app");
        apiData = addApplicationResponse1.getData();
        Assert.assertTrue((!apiData.contains("{\"error\" : true}") ? 1 : 0) != 0, (String)"Application with same name addition not allowed in other tenant");
        apiData = this.apiStore.removeApplication("carbonSuperApp").getData();
        Assert.assertTrue((boolean)apiData.contains("{\"error\" : false}"), (String)"Application deletion failed");
    }

    @Test(groups={"wso2.am"}, description="API Life cycle login to store")
    public void testLoginToStoreTestCase() throws Exception {
        HttpResponse loginResponse;
        String loginResponseString;
        JSONObject response;
        String isLoginError;
        String APICreatorRole = "APICreatorRole";
        String APIPublisherRole = "APIPublisherRole";
        String APIPublisherUser = "APIPublisherUser";
        String APICreatorUser = "APICreatorUser";
        String password = "password@123";
        boolean loginFailed = false;
        String errorString = "";
        APIStoreRestClient apiStoreRestClient = new APIStoreRestClient(this.storeURLHttp);
        String[] createPermissions = new String[]{"/permission/admin/login", "/permission/admin/manage/api/create"};
        if (!this.userManagementClient.roleNameExists(APICreatorRole)) {
            this.userManagementClient.addRole(APICreatorRole, null, createPermissions);
        }
        if (this.userManagementClient != null && !this.userManagementClient.userNameExists(APICreatorRole, APICreatorUser)) {
            this.userManagementClient.addUser(APICreatorUser, password, new String[]{APICreatorRole}, null);
        }
        String[] publishPermissions = new String[]{"/permission/admin/login", "/permission/admin/manage/api/publish"};
        if (!this.userManagementClient.roleNameExists(APIPublisherRole)) {
            this.userManagementClient.addRole(APIPublisherRole, null, publishPermissions);
        }
        if (this.userManagementClient != null && !this.userManagementClient.userNameExists(APIPublisherRole, APIPublisherUser)) {
            this.userManagementClient.addUser(APIPublisherUser, password, new String[]{APIPublisherRole}, null);
        }
        if ((isLoginError = (response = new JSONObject(loginResponseString = (loginResponse = apiStoreRestClient.login("invaliduser", "invaliduser@123")).getData())).get("error").toString()).equals("true")) {
            loginFailed = true;
        }
        Assert.assertTrue((loginFailed && loginResponseString.contains("Login failed. Please recheck the username and password and try again.") ? 1 : 0) != 0, (String)"Invalid user can login to the API store");
        loginFailed = false;
        try {
            apiStoreRestClient.login(APICreatorUser, password);
        }
        catch (Exception e) {
            loginFailed = true;
            errorString = e.getMessage().toString();
        }
        Assert.assertTrue((loginFailed && errorString.contains("No session cookie found with response") ? 1 : 0) != 0, (String)"API creator can login to the API store");
        loginFailed = false;
        try {
            apiStoreRestClient.login(APIPublisherUser, password);
        }
        catch (Exception e) {
            loginFailed = true;
            errorString = e.getMessage().toString();
        }
        Assert.assertTrue((loginFailed && errorString.contains("No session cookie found with response") ? 1 : 0) != 0, (String)"API publisher can login to the API store");
    }

    @Test(groups={"wso2.am"}, description="API Life cycle test subscriber login")
    public void testInvalidLoginAsTenantSubscriberTestCase() throws Exception {
        this.init(TestUserMode.TENANT_ADMIN);
        APIPublisherRestClient apiPublisherRestClient = new APIPublisherRestClient(this.publisherURLHttp);
        boolean loginFailed = false;
        String loginResponseString = "";
        if (this.userManagementClient != null && !this.userManagementClient.userNameExists("Internal/subscriber", "storeUser@wso2.com")) {
            this.userManagementClient.addUser("storeUser", "password@123", new String[]{"Internal/subscriber"}, null);
        }
        try {
            HttpResponse loginResponse = apiPublisherRestClient.login("storeUser@wso2.com", "password@123");
            loginResponseString = loginResponse.getData();
            JSONObject response = new JSONObject(loginResponseString);
            String isLoginError = response.get("error").toString();
            if (isLoginError.equals("true")) {
                loginFailed = true;
            }
        }
        catch (Exception e) {
            loginFailed = true;
        }
        Assert.assertTrue((loginFailed && loginResponseString.contains("Login failed. Insufficient privileges.") ? 1 : 0) != 0, (String)"Invalid tenant subscriber can login to the API publisher");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

