/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APIThrottlingTier;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIEndpointTypeUpdateTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(APIEndpointTypeUpdateTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private APIPublisherRestClient apiPublisherTenant;
    private APIStoreRestClient apiStoreTenant;
    private String apiName = "APIEndpointTypeUpdateTestCaseAPIName";
    private String APIContext = "APIEndpointTypeUpdateTestCaseAPIContext";
    private String tags = "test, EndpointType";
    private String endpointUrl;
    private String description = "This is test API create by API manager integration test";
    private String APIVersion = "1.0.0";
    private String appName = "APIEndpointTypeUpdateTestCaseAPIApp";
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private APIRequest apiRequest;
    private APIRequest apiRequestTenant;
    private String CARBON_SUPER_ADMIN = "admin";
    private String CARBON_SUPER_ADMIN_PASS = "admin";
    private String TENANT_WSO2_ADMIN = "admin@wso2.com";
    private String TENANT_WSO2_ADMIN_PASS = "admin";
    private String TENANT_WSO2 = "wso2.com";
    private String publisherURLHttp;
    private String storeURLHttp;
    private String ApiHTTPInvocationURLTenant;
    private String ApiHTTPSInvocationURLTenant;

    @Factory(dataProvider="userModeDataProvider")
    public APIEndpointTypeUpdateTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.publisherURLHttp = this.getPublisherURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api/add";
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
    }

    @Test(groups={"wso2.am"}, description="Sample API creation and subscribe")
    public void testAPICreation() throws Exception {
        String providerName = this.user.getUserName();
        this.apiRequest = new APIRequest(this.apiName, this.APIContext, new URL(this.endpointUrl));
        this.apiRequest.setTags(this.tags);
        this.apiRequest.setDescription(this.description);
        this.apiRequest.setVersion(this.APIVersion);
        this.apiRequest.setProvider(providerName);
        HttpResponse serviceResponse = this.apiPublisher.addAPI(this.apiRequest);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(this.apiName, this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        serviceResponse = this.apiStore.addApplication(this.appName, APIThrottlingTier.UNLIMITED.getState(), "", "this-is-test");
        this.verifyResponse(serviceResponse);
        String provider = this.user.getUserName();
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(this.apiName, provider);
        subscriptionRequest.setApplicationName(this.appName);
        subscriptionRequest.setTier("Gold");
        serviceResponse = this.apiStore.subscribe(subscriptionRequest);
        this.verifyResponse(serviceResponse);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(this.appName);
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        Assert.assertNotNull((Object)("Access Token not found " + responseString), (String)accessToken);
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
    }

    @Test(groups={"wso2.am"}, description="Invoke HTTP before Update", dependsOnMethods={"testAPICreation"})
    public void testHTTPTransportBeforeUpdate() throws Exception {
        this.waitForAPIDeploymentSync(this.apiRequest.getProvider(), this.apiRequest.getName(), this.apiRequest.getVersion(), "\"isApiExists\":true");
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
        HttpResponse serviceResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp(this.APIContext + "/" + this.APIVersion), this.requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        serviceResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttps(this.APIContext + "/" + this.APIVersion), this.requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
    }

    @Test(groups={"wso2.am"}, description="Update to only HTTP transport and invoke", dependsOnMethods={"testHTTPTransportBeforeUpdate"})
    public void testUpdatedHTTPTransport() throws Exception {
        APIRequest apiRequest = new APIRequest(this.apiName, this.APIContext, new URL(this.endpointUrl));
        apiRequest.setHttps_checked("");
        apiRequest.setProvider(this.user.getUserName());
        HttpResponse serviceResponse = this.apiPublisher.updateAPI(apiRequest);
        this.waitForAPIDeployment();
        Assert.assertTrue((boolean)serviceResponse.getData().contains("\"error\" : false"), (String)(this.apiName + " is not updated properly"));
        HttpResponse apiUpdateResponsePublisher = this.apiPublisher.getAPI(this.apiName, apiRequest.getProvider(), apiRequest.getVersion());
        serviceResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp(this.APIContext + "/" + this.APIVersion), this.requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        try {
            serviceResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttps(this.APIContext + "/" + this.APIVersion), this.requestHeaders);
            Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Response code mismatched when api invocation");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(groups={"wso2.am"}, description="Update to only HTTPS transport and invoke", dependsOnMethods={"testUpdatedHTTPTransport"})
    public void testUpdatedHTTPSTransport() throws Exception {
        HttpResponse serviceResponse2;
        APIRequest apiRequest = new APIRequest(this.apiName, this.APIContext, new URL(this.endpointUrl));
        apiRequest.setProvider(this.user.getUserName());
        apiRequest.setHttp_checked("");
        apiRequest.setHttps_checked("https");
        this.apiPublisher.updateAPI(apiRequest);
        this.waitForAPIDeployment();
        try {
            serviceResponse2 = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp(this.APIContext + "/" + this.APIVersion), this.requestHeaders);
            Assert.assertEquals((int)serviceResponse2.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Response code mismatched when api invocation");
        }
        catch (Exception serviceResponse2) {
            // empty catch block
        }
        serviceResponse2 = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttps(this.APIContext + "/" + this.APIVersion), this.requestHeaders);
        Assert.assertEquals((int)serviceResponse2.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
    }

    @Test(groups={"wso2.am"}, description="Update to only HTTPS transport and invoke", dependsOnMethods={"testUpdatedHTTPSTransport"})
    public void testAPICreationTenant() throws Exception {
        this.apiStoreTenant = new APIStoreRestClient(this.storeURLHttp);
        this.apiStoreTenant.login(this.TENANT_WSO2_ADMIN, this.TENANT_WSO2_ADMIN_PASS);
        this.apiPublisherTenant = new APIPublisherRestClient(this.publisherURLHttp);
        this.apiPublisherTenant.login(this.TENANT_WSO2_ADMIN, this.TENANT_WSO2_ADMIN_PASS);
        this.apiRequestTenant = new APIRequest(this.apiName, this.APIContext, new URL(this.endpointUrl));
        this.apiRequestTenant.setTags(this.tags);
        this.apiRequestTenant.setDescription(this.description);
        this.apiRequestTenant.setVersion(this.APIVersion);
        this.apiRequestTenant.setProvider(this.TENANT_WSO2_ADMIN);
        HttpResponse serviceResponse = this.apiPublisherTenant.addAPI(this.apiRequestTenant);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(this.apiName, this.TENANT_WSO2_ADMIN, APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisherTenant.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        serviceResponse = this.apiStoreTenant.addApplication(this.appName, APIThrottlingTier.UNLIMITED.getState(), "", "this-is-test");
        this.verifyResponse(serviceResponse);
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(this.apiName, this.TENANT_WSO2_ADMIN);
        subscriptionRequest.setApplicationName(this.appName);
        subscriptionRequest.setTier("Gold");
        serviceResponse = this.apiStoreTenant.subscribe(subscriptionRequest);
        this.verifyResponse(serviceResponse);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(this.appName);
        String responseString = this.apiStoreTenant.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        Assert.assertNotNull((Object)("Access Token not found " + responseString), (String)accessToken);
        this.requestHeaders.clear();
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        this.ApiHTTPInvocationURLTenant = this.getAPIInvocationURLHttp("t/" + this.TENANT_WSO2 + "/" + this.APIContext + "/") + this.APIVersion;
        this.ApiHTTPSInvocationURLTenant = this.getAPIInvocationURLHttps("t/" + this.TENANT_WSO2 + "/" + this.APIContext + "/") + this.APIVersion;
    }

    @Test(groups={"wso2.am"}, description="Invoke HTTP before Update", dependsOnMethods={"testAPICreationTenant"})
    public void testHTTPTransportBeforeUpdateInTenant() throws Exception {
        this.waitForAPIDeploymentSync(this.apiRequestTenant.getProvider(), this.apiRequestTenant.getName(), this.apiRequestTenant.getVersion(), "\"isApiExists\":true");
        this.apiStoreTenant = new APIStoreRestClient(this.storeURLHttp);
        this.apiStoreTenant.login(this.TENANT_WSO2_ADMIN, this.TENANT_WSO2_ADMIN_PASS);
        HttpResponse serviceResponse = HttpRequestUtil.doGet((String)this.ApiHTTPInvocationURLTenant, this.requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)serviceResponse.getData());
        serviceResponse = HttpRequestUtil.doGet((String)this.ApiHTTPSInvocationURLTenant, this.requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)serviceResponse.getData());
    }

    @Test(groups={"wso2.am"}, description="Update to only HTTP transport and invoke", dependsOnMethods={"testHTTPTransportBeforeUpdateInTenant"})
    public void testUpdatedHTTPTransportTenant() throws Exception {
        APIRequest apiRequest = new APIRequest(this.apiName, this.APIContext, new URL(this.endpointUrl));
        apiRequest.setHttps_checked("");
        apiRequest.setProvider(this.TENANT_WSO2_ADMIN);
        HttpResponse serviceResponse = this.apiPublisherTenant.updateAPI(apiRequest);
        this.waitForAPIDeployment();
        Assert.assertTrue((boolean)serviceResponse.getData().contains("\"error\" : false"), (String)(this.apiName + " is not updated properly"));
        HttpResponse apiUpdateResponsePublisher = this.apiPublisherTenant.getAPI(this.apiName, this.TENANT_WSO2_ADMIN, apiRequest.getVersion());
        serviceResponse = HttpRequestUtil.doGet((String)this.ApiHTTPInvocationURLTenant, this.requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        try {
            serviceResponse = HttpRequestUtil.doGet((String)this.ApiHTTPSInvocationURLTenant, this.requestHeaders);
            Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Response code mismatched when api invocation");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(groups={"wso2.am"}, description="Update to only HTTPS transport and invoke", dependsOnMethods={"testUpdatedHTTPTransportTenant"})
    public void testUpdatedHTTPSTransportTenant() throws Exception {
        HttpResponse serviceResponse2;
        APIRequest apiRequest = new APIRequest(this.apiName, this.APIContext, new URL(this.endpointUrl));
        apiRequest.setProvider(this.TENANT_WSO2_ADMIN);
        apiRequest.setHttp_checked("");
        apiRequest.setHttps_checked("https");
        this.apiPublisherTenant.updateAPI(apiRequest);
        this.waitForAPIDeployment();
        try {
            serviceResponse2 = HttpRequestUtil.doGet((String)this.ApiHTTPInvocationURLTenant, this.requestHeaders);
            Assert.assertEquals((int)serviceResponse2.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Response code mismatched when api invocation");
        }
        catch (Exception serviceResponse2) {
            // empty catch block
        }
        serviceResponse2 = HttpRequestUtil.doGet((String)this.ApiHTTPSInvocationURLTenant, this.requestHeaders);
        Assert.assertEquals((int)serviceResponse2.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication(this.appName);
        this.apiStoreTenant.removeApplication(this.appName);
        this.apiPublisher.deleteAPI(this.apiName, this.APIVersion, this.user.getUserName());
        this.apiPublisherTenant.deleteAPI(this.apiName, this.APIVersion, this.TENANT_WSO2_ADMIN);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }
}

