/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIMURLBean;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM641StoreApiTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIM641StoreApiTestCase.class);
    private APIStoreRestClient apiStore;

    @BeforeClass(alwaysRun=true)
    public void init() throws APIManagerIntegrationTestException {
        super.init();
    }

    @DataProvider(name="validLogin")
    public static Object[][] apiLoginCredentialsDataProvider() throws Exception {
        AutomationContext superTenantAdminAutomationContext = new AutomationContext("APIM", "store", TestUserMode.SUPER_TENANT_ADMIN);
        AutomationContext superTenantUserAutomationContext = new AutomationContext("APIM", "store", TestUserMode.SUPER_TENANT_USER);
        AutomationContext tenantAdminAutomationContext = new AutomationContext("APIM", "store", TestUserMode.TENANT_ADMIN);
        AutomationContext tenantUserAutomationContext = new AutomationContext("APIM", "store", TestUserMode.TENANT_USER);
        return new Object[][]{{superTenantAdminAutomationContext.getContextTenant().getContextUser().getUserName(), superTenantAdminAutomationContext.getContextTenant().getContextUser().getPassword()}, {superTenantUserAutomationContext.getContextTenant().getContextUser().getUserName(), superTenantUserAutomationContext.getContextTenant().getContextUser().getPassword()}, {tenantAdminAutomationContext.getContextTenant().getContextUser().getUserName(), tenantAdminAutomationContext.getContextTenant().getContextUser().getPassword()}, {tenantUserAutomationContext.getContextTenant().getContextUser().getUserName(), tenantUserAutomationContext.getContextTenant().getContextUser().getPassword()}};
    }

    @DataProvider(name="invalidLogin")
    public static Object[][] apiInvalidLoginCredentialsDataProvider() throws Exception {
        AutomationContext superTenantAdmin = new AutomationContext("APIM", "store", TestUserMode.SUPER_TENANT_ADMIN);
        return new Object[][]{{superTenantAdmin.getContextTenant().getContextUser().getUserName(), "12345"}, {superTenantAdmin.getContextTenant().getContextUser().getUserName(), ""}, {"", superTenantAdmin.getContextTenant().getContextUser().getPassword()}, {"", ""}, {"abc", "12345"}};
    }

    @DataProvider(name="userSignUp")
    public static Object[][] storeUserSignUpCredentialsDataProvider() throws Exception {
        return new Object[][]{{"user1", "user1pass", "firstName", "lastNmae", "user1@wso2.com"}, {"user3", "user3pass", "User3", "Test", ""}, {"user4", "user4pass", "User2", "", "user2@wso2.com"}, {"user5", "user5pass", "", "Test", "user2@wso2.com"}};
    }

    @DataProvider(name="invalidUserSignUp")
    public static Object[][] storeInvalidUserSignUpCredentialsDataProvider() throws Exception {
        return new Object[][]{{"user6", "", "User6", "Test", "user2@wso2.com"}, {"", "user7pass", "User7", "Test", "user2@wso2.com"}};
    }

    @Test(dataProvider="apiLoginCredentialsDataProvider", description="Verify Valid login for different scenarios")
    public void testValidStoreLoginAndLogout(String userName, String password) throws Exception {
        AutomationContext storeContext = new AutomationContext("APIM", "store", TestUserMode.SUPER_TENANT_ADMIN);
        APIMURLBean storeUrls = new APIMURLBean(storeContext.getContextUrls());
        String storeURLHttp = storeUrls.getWebAppURLHttp();
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        HttpResponse loginResponse = this.apiStore.login(userName, password);
        log.info((Object)("Login User: " + userName + " Password: " + password));
        JSONObject loginJsonObject = new JSONObject(loginResponse.getData());
        Assert.assertFalse((boolean)loginJsonObject.getBoolean("error"), (String)("Error in Login Request: User Name : " + userName));
        HttpResponse logoutResponse = this.apiStore.logout();
        JSONObject logoutJsonObject = new JSONObject(logoutResponse.getData());
        Assert.assertFalse((boolean)logoutJsonObject.getBoolean("error"), (String)("Error in Logout Request : User Name : " + userName));
    }

    @Test(dataProvider="apiInvalidLoginCredentialsDataProvider", description="Verify Invalid Login for different scenarios")
    public void testInvalidStoreLogin(String userName, String password) throws Exception {
        AutomationContext storeContext = new AutomationContext("APIM", "store", TestUserMode.SUPER_TENANT_ADMIN);
        APIMURLBean storeUrls = new APIMURLBean(storeContext.getContextUrls());
        String storeURLHttp = storeUrls.getWebAppURLHttp();
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        HttpResponse loginResponse = this.apiStore.login(userName, password);
        log.info((Object)("Login User: " + userName + " Password: " + password));
        JSONObject loginJsonObject = new JSONObject(loginResponse.getData());
        Assert.assertTrue((boolean)loginJsonObject.getBoolean("error"), (String)("Login success for invalid credentials : User Name: " + userName));
    }

    @Test(dataProvider="storeUserSignUpCredentialsDataProvider", description="Verify user sign up")
    public void testUserSignUp(String userName, String password, String firstName, String lastName, String email) throws Exception {
        AutomationContext storeContext = new AutomationContext("APIM", "store", TestUserMode.SUPER_TENANT_ADMIN);
        APIMURLBean storeUrls = new APIMURLBean(storeContext.getContextUrls());
        String storeURLHttp = storeUrls.getWebAppURLHttp();
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        HttpResponse storeSignUpResponse = this.apiStore.signUp(userName, password, firstName, lastName, email);
        log.info((Object)("Sign Up User: " + userName));
        JSONObject signUpJsonObject = new JSONObject(storeSignUpResponse.getData());
        Assert.assertFalse((boolean)signUpJsonObject.getBoolean("error"), (String)"Error in user sign up Response");
        Assert.assertFalse((boolean)signUpJsonObject.getBoolean("showWorkflowTip"), (String)"Error in sign up Response");
        HttpResponse loginResponse = this.apiStore.login(userName, password);
        JSONObject loginJsonObject = new JSONObject(loginResponse.getData());
        Assert.assertFalse((boolean)loginJsonObject.getBoolean("error"), (String)("Error in Login Request: User Name : " + userName));
    }

    @Test(dataProvider="storeInvalidUserSignUpCredentialsDataProvider", description="invalid user sign up")
    public void testInvalidUserSignUp(String userName, String password, String firstName, String lastName, String email) throws Exception {
        AutomationContext storeContext = new AutomationContext("APIM", "store", TestUserMode.SUPER_TENANT_ADMIN);
        APIMURLBean storeUrls = new APIMURLBean(storeContext.getContextUrls());
        String storeURLHttp = storeUrls.getWebAppURLHttp();
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        HttpResponse storeSignUpResponse = this.apiStore.signUp(userName, password, firstName, lastName, email);
        JSONObject signUpJsonObject = new JSONObject(storeSignUpResponse.getData());
        Assert.assertTrue((boolean)signUpJsonObject.getBoolean("error"), (String)"Error in Invalid User Sign up Response");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        int deletedUserCount = 0;
        int beforeDeleteUserCount = APIM641StoreApiTestCase.storeUserSignUpCredentialsDataProvider().length;
        for (int i = 0; i < APIM641StoreApiTestCase.storeUserSignUpCredentialsDataProvider().length; ++i) {
            this.userManagementClient.deleteUser(APIM641StoreApiTestCase.storeUserSignUpCredentialsDataProvider()[i][0].toString());
            ++deletedUserCount;
        }
        Assert.assertEquals((int)deletedUserCount, (int)beforeDeleteUserCount, (String)"Error in user Deletion");
        super.cleanUp();
    }
}

