/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class APIM684GenerateApplicationKeyTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIM684GenerateApplicationKeyTestCase.class);
    private APIStoreRestClient apiStore;
    private APIPublisherRestClient apiPublisher;
    private String apiName = "APISubscriptionTestAPI";
    private final String version = "1.0.0";
    private final String context = "testScopeAPI";
    private final String tags = "testtag1,teasttag2";
    private final String apiDescription = "TestApiDescription";
    private String apiProvider;
    private String visibility = "public";
    private String endPointType = "http";
    private String tier = "Unlimited";
    private String resTier = "Unlimited";
    private String appTier = "Unlimited";
    private final String webApp = "jaxrs_basic";
    private String applicationName = "NewApplication";
    private final String applicationDescription = "NewKeyGeneration";
    private final String callbackUrl = "http://myserver.com";
    private String endpointUrl = "";
    List<APIResourceBean> resourceBeanList;
    private UserManagementClient userManagementClient;
    private static final String subscriber_role = "subscriber";
    private static final String admin_user = "wso2admin";
    private static final String test_user = "testUser";
    APICreationRequestBean apiCreationRequestBean;

    @Factory(dataProvider="userModeDataProvider")
    public APIM684GenerateApplicationKeyTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        log.info((Object)("Test Starting user mode:" + this.userMode));
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        HttpResponse publisherLogin = this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        Assert.assertEquals((int)publisherLogin.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Publisher Login Response Code is Mismatched: ");
        HttpResponse loginResponse = this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        Assert.assertEquals((int)loginResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code is Mismatched in Login Response");
        JSONObject loginJsonObject = new JSONObject(loginResponse.getData());
        Assert.assertFalse((boolean)loginJsonObject.getBoolean("error"), (String)"Response data error in Login Request");
        String uriGet = "customers/{id}/";
        String uriPost = "customers/name/";
        this.resourceBeanList = new ArrayList<APIResourceBean>();
        this.resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", this.resTier, uriGet));
        this.resourceBeanList.add(new APIResourceBean("POST", "Application & Application User", this.resTier, uriPost));
        String endpoint = "/services/customers/customerservice";
        this.endpointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + "jaxrs_basic" + endpoint;
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"webapp"}, description="Generate New Application Key")
    public void generateApplicationKeyWithoutScope() throws Exception {
        this.apiCreationRequestBean = new APICreationRequestBean(this.apiName, "testScopeAPI", "1.0.0", this.apiProvider, new URL(this.endpointUrl));
        this.apiCreationRequestBean.setEndpointType(this.endPointType);
        this.apiCreationRequestBean.setTiersCollection(this.tier);
        this.apiCreationRequestBean.setTags("testtag1,teasttag2");
        this.apiCreationRequestBean.setResourceBeanList(this.resourceBeanList);
        this.apiCreationRequestBean.setDescription("TestApiDescription");
        this.apiCreationRequestBean.setVisibility(this.visibility);
        log.info((Object)this.apiCreationRequestBean);
        HttpResponse apiCreateResponse = this.apiPublisher.addAPI(this.apiCreationRequestBean);
        Assert.assertEquals((int)apiCreateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
        JSONObject createApiJsonObject = new JSONObject(apiCreateResponse.getData());
        Assert.assertEquals((boolean)createApiJsonObject.getBoolean("error"), (boolean)false, (String)"Error in API Creation");
        HttpResponse verifyApiResponse = this.apiPublisher.getApi(this.apiName, this.apiProvider, "1.0.0");
        JSONObject verifyApiJsonObject = new JSONObject(verifyApiResponse.getData());
        Assert.assertFalse((boolean)verifyApiJsonObject.getBoolean("error"), (String)"Error in Verify API Response");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(this.apiName, this.apiProvider, APILifeCycleState.PUBLISHED);
        HttpResponse statusUpdateResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertEquals((int)statusUpdateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code is Mismatched");
        JSONObject statusUpdateJsonObject = new JSONObject(statusUpdateResponse.getData());
        Assert.assertFalse((boolean)statusUpdateJsonObject.getBoolean("error"), (String)"API is not published");
        this.waitForAPIDeploymentSync(this.apiCreationRequestBean.getProvider(), this.apiCreationRequestBean.getName(), "1.0.0", "\"isApiExists\":true");
        this.apiProvider = this.storeContext.getContextTenant().getContextUser().getUserName();
        HttpResponse addApplicationResponse = this.apiStore.addApplication(this.applicationName, this.appTier, "http://myserver.com", "NewKeyGeneration");
        Assert.assertEquals((int)addApplicationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)("Response Code Mismatched in Create Application: " + this.applicationName));
        JSONObject addApplicationJsonObject = new JSONObject(addApplicationResponse.getData());
        Assert.assertFalse((boolean)addApplicationJsonObject.getBoolean("error"), (String)("Error in Create Application: " + this.applicationName));
        SubscriptionRequest apiSubscriptionRequest = new SubscriptionRequest(this.apiName, "1.0.0", this.apiProvider, this.applicationName, this.tier);
        HttpResponse subscriptionResponse = this.apiStore.subscribe(apiSubscriptionRequest);
        Assert.assertEquals((int)subscriptionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Subscription Response Code is Mismatched");
        JSONObject subscriptionResponseJsonObject = new JSONObject(subscriptionResponse.getData());
        Assert.assertFalse((boolean)subscriptionResponseJsonObject.getBoolean("error"), (String)"Subscription Response is Mismatched");
        APPKeyRequestGenerator appKeyRequestGenerator = new APPKeyRequestGenerator(this.applicationName);
        String responseString = this.apiStore.generateApplicationKey(appKeyRequestGenerator).getData();
        JSONObject jsonObject = new JSONObject(responseString);
        String accessToken = jsonObject.getJSONObject("data").getJSONObject("key").getString("accessToken");
        HashMap<String, String> applicationHeader = new HashMap<String, String>();
        applicationHeader.put("Authorization", " Bearer " + accessToken);
        applicationHeader.put("accept", "text/xml");
        HttpResponse apiInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("testScopeAPI", "1.0.0") + "/customers/123"), applicationHeader);
        String apiResponse = "<Customer><id>123</id><name>John</name></Customer>";
        Assert.assertEquals((int)apiInvokeResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatched");
        Assert.assertTrue((boolean)apiInvokeResponse.getData().contains(apiResponse), (String)"Response Data Mismatch");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        HttpResponse removeSubscriptionResponse = this.apiStore.removeAPISubscriptionByName(this.apiName, "1.0.0", this.apiProvider, this.applicationName);
        Assert.assertEquals((int)removeSubscriptionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)("Remove Subscription Response Code Mismatched: " + this.apiName));
        JSONObject removeSubscriptionJsonObject = new JSONObject(removeSubscriptionResponse.getData());
        Assert.assertFalse((boolean)removeSubscriptionJsonObject.getBoolean("error"), (String)("Response data Mismatched in Remove Subscription: Api Name: " + this.apiName + " Application Name: " + this.applicationName));
        HttpResponse deleteApiResponse = this.apiPublisher.deleteAPI(this.apiName, "1.0.0", this.apiProvider);
        Assert.assertEquals((int)deleteApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)("Delete Api Response Code is Mismatched: " + this.apiName));
        JSONObject deleteApiJsonObject = new JSONObject(deleteApiResponse.getData());
        Assert.assertFalse((boolean)deleteApiJsonObject.getBoolean("error"), (String)("Response data is Mismatched in Delete Api: " + this.apiName));
        HttpResponse removeApplicationResponse = this.apiStore.removeApplication(this.applicationName);
        Assert.assertEquals((int)removeApplicationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)("Response Code is Mismatched in Remove Application: " + this.applicationName));
        JSONObject removeApplicationJsonObject = new JSONObject(removeApplicationResponse.getData());
        Assert.assertFalse((boolean)removeApplicationJsonObject.getBoolean("error"), (String)"Response Data Mismatched in remove Application");
    }
}

