/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIMANAGER2611EndpointValidationTestCase
extends APIManagerLifecycleBaseTest {
    private APIIdentifier apiIdentifier;
    private APIPublisherRestClient apiPublisherRestClient;

    @Factory(dataProvider="userModeDataProvider")
    public APIMANAGER2611EndpointValidationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.apiPublisherRestClient = new APIPublisherRestClient(this.getPublisherURLHttp());
        this.apiPublisherRestClient.login(this.user.getUserName(), this.user.getPassword());
    }

    @Test(groups={"wso2.am"}, description="Validate endpoint with Http Head not support End point")
    public void checkEndpointValidation() throws Exception {
        String APIName = "APIMANAGER2611testAPI";
        String APIContext = "/testEndpointValid";
        String endPointToValidate = this.getGatewayURLHttp() + "oauth2/token";
        String providerName = this.user.getUserName();
        String APIVersion = "1.0.0";
        this.apiIdentifier = new APIIdentifier(providerName, APIName, APIVersion);
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(endPointToValidate));
        apiRequest.setVersion(APIVersion);
        apiRequest.setProvider(providerName);
        this.apiPublisherRestClient.addAPI(apiRequest);
        HttpResponse response = this.apiPublisherRestClient.checkValidEndpoint("http", endPointToValidate, providerName, APIName, APIVersion);
        int statusCode = response.getResponseCode();
        Assert.assertEquals((int)statusCode, (int)200, (String)"response code mismatched");
        String responseString = response.getData();
        Assert.assertTrue((boolean)responseString.contains("success"), (String)("Invalid end point " + endPointToValidate + ":" + responseString));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.deleteAPI(this.apiIdentifier, this.apiPublisherRestClient);
        super.cleanUp();
    }
}

