/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import sun.misc.BASE64Encoder;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIMANAGER5843WSDLHostnameTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIMANAGER5843WSDLHostnameTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private String apiName = "APIMANAGER5843";
    private String apiContext = "apimanager5843";
    private String backendEndWSDL;
    private String backendEndUrl;
    APIRequest apiRequest;

    @Factory(dataProvider="userModeDataProvider")
    public APIMANAGER5843WSDLHostnameTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            super.init();
        }
        String publisherURLHttp = this.getPublisherURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.backendEndWSDL = this.getGatewayURLNhttp() + "services/echo?wsdl";
        this.backendEndUrl = this.getGatewayURLNhttp() + "services/echo";
        this.apiRequest = new APIRequest(this.apiName, this.apiContext, new URL(this.backendEndUrl));
    }

    @Test(groups={"wso2.am"}, description="API creation with wsdl")
    public void testAPICreationWithWSDL() throws Exception {
        this.apiRequest.setWsdl(this.backendEndWSDL);
        this.apiRequest.setProvider(this.user.getUserName());
        this.apiPublisher.addAPI(this.apiRequest);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Authorization", "Basic " + new BASE64Encoder().encode((this.user.getUserName() + ':' + this.user.getPassword()).getBytes()));
        String username = this.user.getUserNameWithoutDomain();
        if (TestUserMode.TENANT_ADMIN == this.userMode) {
            username = this.user.getUserNameWithoutDomain() + "-AT-" + this.user.getUserDomain();
        }
        String wsdl = HTTPSClientUtils.doGet((String)(this.getGatewayMgtURLHttps() + "registry/resourceContent?" + "path=/_system/governance/apimgt/applicationdata/wsdls/" + username + "--APIMANAGER58431.0.0.wsdl"), map).getData();
        Assert.assertFalse((boolean)wsdl.contains("null/"), (String)"WSDL has 'null' as service hostname.");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiPublisher.deleteAPI(this.apiName, this.apiRequest.getVersion(), this.apiRequest.getProvider());
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

