/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class APIScopeTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIScopeTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private UserManagementClient userManagementClient1 = null;
    private static final String API_NAME = "APIScopeTestAPI";
    private static final String API_VERSION = "1.0.0";
    private static final String APP_NAME = "NewApplication";
    private static final String USER_JOHN = "john";
    private static final String SUBSCRIBER_ROLE = "subscriber";
    private final String API_VERSION_WITH_SCOPE = "1.0.0";
    private final String API_VERSION_WITH_SCOPE_COPY = "2.0.0";
    private final String API_NAME_WITH_SCOPE = "APIScopeTestWithScopeName";
    private final String API_CONTEXT_WITH_SCOPE = "APIScopeTestWithScopeContext";
    private final String SCOPE_NAME = "APIScopeUpdateCopyScope";
    private final String ALLOWED_ROLE = "admin";
    private String gatewaySessionCookie;

    @Factory(dataProvider="userModeDataProvider")
    public APIScopeTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        this.gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "dummy_api.xml", this.gatewayContextMgt, this.gatewaySessionCookie);
        }
    }

    @Test(groups={"wso2.am"}, description="Testing the scopes with admin, subscriber roles")
    public void testSetScopeToResourceTestCase() throws Exception {
        String userJohn;
        String gatewayUrl;
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getContextUser().getUserName(), this.keyManagerContext.getContextTenant().getContextUser().getPassword());
        this.userManagementClient1.addRole(SUBSCRIBER_ROLE, new String[0], new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"});
        if (this.keyManagerContext.getContextTenant().getDomain().equals("carbon.super")) {
            gatewayUrl = this.gatewayUrlsWrk.getWebAppURLNhttp();
            userJohn = USER_JOHN;
        } else {
            gatewayUrl = this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.keyManagerContext.getContextTenant().getDomain() + "/";
            userJohn = "john@" + this.keyManagerContext.getContextTenant().getDomain();
        }
        this.userManagementClient1.addUser(USER_JOHN, "john123", new String[]{SUBSCRIBER_ROLE}, USER_JOHN);
        String apiContext = "testScopeAPI";
        String tags = "thomas-bayer, testing, rest-Apis";
        String url = this.getGatewayURLNhttp() + "response";
        String description = "This is a test API created by API manager integration test";
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        APIRequest apiRequest = new APIRequest(API_NAME, apiContext, new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(API_VERSION);
        apiRequest.setProvider(this.user.getUserName());
        this.apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(API_NAME, this.user.getUserName(), APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.waitForAPIDeploymentSync(this.user.getUserName(), API_NAME, API_VERSION, "\"isApiExists\":true");
        String modifiedResource = "{\"paths\":{ \"/*\":{\"put\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\" },\"post\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\",\"x-scope\":\"admin_scope\"},\"get\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\",\"x-scope\":\"user_scope\"},\"delete\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\"},\"options\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"None\",\"x-throttling-tier\":\"Unlimited\"}}},\"swagger\":\"2.0\",\"info\":{\"title\":\"APIScopeTestAPI\",\"version\":\"1.0.0\"},\"x-wso2-security\":{\"apim\":{\"x-wso2-scopes\":[{\"name\":\"admin_scope\",\"description\":\"\",\"key\":\"admin_scope\",\"roles\":\"admin\"},{\"name\":\"user_scope\",\"description\":\"\",\"key\":\"user_scope\",\"roles\":\"admin,subscriber\"}]}}}";
        this.apiPublisher.updateResourceOfAPI(this.user.getUserName(), API_NAME, API_VERSION, modifiedResource);
        this.waitForAPIDeployment();
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.addApplication(APP_NAME, "Unlimited", "some_url", "NewApp");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(API_NAME, this.user.getUserName());
        subscriptionRequest.setApplicationName(APP_NAME);
        this.apiStore.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(APP_NAME);
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject jsonResponse = new JSONObject(responseString);
        String consumerKey = jsonResponse.getJSONObject("data").getJSONObject("key").getString("consumerKey");
        String consumerSecret = jsonResponse.getJSONObject("data").getJSONObject("key").getString("consumerSecret");
        URL tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "token");
        String requestBody = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope=admin_scope user_scope";
        HttpResponse response = this.apiStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL);
        JSONObject accessTokenGenerationResponse = new JSONObject(response.getData());
        String accessToken = accessTokenGenerationResponse.getString("access_token");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        response = HttpRequestUtil.doGet((String)(gatewayUrl + "testScopeAPI/1.0.0/test"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Admin user cannot access the GET Method");
        URL endPointURL = new URL(gatewayUrl + "testScopeAPI/1.0.0/test");
        response = HttpRequestUtil.doPost((URL)endPointURL, (String)"", requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Admin user cannot access the POST Method");
        requestBody = "grant_type=password&username=" + userJohn + "&password=john123&scope=admin_scope user_scope";
        accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
        accessToken = accessTokenGenerationResponse.getString("access_token");
        requestHeaders = new HashMap();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        response = HttpRequestUtil.doGet((String)(gatewayUrl + "testScopeAPI/1.0.0/test"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"User John cannot access the GET Method");
        try {
            endPointURL = new URL(gatewayUrl + "testScopeAPI/1.0.0/test");
            response = HttpRequestUtil.doPost((URL)endPointURL, (String)"", requestHeaders);
            Assert.assertTrue((response.getResponseCode() != Response.Status.OK.getStatusCode() ? 1 : 0) != 0, (String)"testRole John can access the POST Method");
        }
        catch (Exception e) {
            log.error((Object)"user john cannot access the resources (expected behaviour)");
            Assert.assertTrue((boolean)true, (String)"user john cannot access the resources");
        }
    }

    @Test(groups={"wso2.am"}, description="Testing Copy api with scopes assigned", dependsOnMethods={"testSetScopeToResourceTestCase"})
    public void testCopyApiWithScopes() throws Exception {
        String tierCollection = "Unlimited";
        String endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIScopeTestWithScopeName", "APIScopeTestWithScopeContext", API_VERSION, this.user.getUserName(), new URL(endpointUrl));
        apiCreationRequestBean.setTiersCollection(tierCollection);
        String swagger = "{\"paths\": {\"/add\": {\"get\": {\"x-auth-type\": \"" + URLEncoder.encode("Application & Application User", "UTF-8") + "\"," + "\"x-throttling-tier\": \"" + "Unlimited" + "\"," + "\"x-scope\": \"" + "APIScopeUpdateCopyScope" + "\"," + "\"responses\": {" + "\"200\": {}" + "}," + "\"parameters\": [{" + "\"name\": \"x\"," + "\"paramType\": \"query\"," + "\"required\": false," + "\"type\": \"string\"," + "\"description\": \"First value\"," + "\"in\": \"query\"" + "}, {" + "\"name\": \"y\"," + "\"paramType\": \"query\"," + "\"required\": false," + "\"type\": \"string\"," + "\"description\": \"Second Value\"," + "\"in\": \"query\"" + "}]" + "}" + "}" + "}," + "\"swagger\": \"2.0\"," + "\"x-wso2-security\": {" + "\"apim\": {" + "\"x-wso2-scopes\": [{" + "\"description\": \"Sample Scope\"," + "\"name\": \"" + "APIScopeUpdateCopyScope" + "\"," + "\"roles\": \"" + "admin" + "\"," + "\"key\": \"" + "APIScopeUpdateCopyScope" + "\"" + "}]" + "}" + "}," + "\"info\": {" + "\"title\": \"" + "APIScopeTestWithScopeName" + "\"," + "\"" + API_VERSION + "\": \"1.0.0\"" + "}" + "}";
        apiCreationRequestBean.setSwagger(swagger);
        HttpResponse serviceResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIScopeTestWithScopeName", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        HttpResponse newVersionResponse = this.apiPublisher.copyAPI(this.user.getUserName(), "APIScopeTestWithScopeName", API_VERSION, "2.0.0", "");
        Assert.assertEquals((int)newVersionResponse.getResponseCode(), (int)200, (String)"Response Code Mismatch");
    }

    @Test(groups={"wso2.am"}, description="Testing Update api with scopes assigned", dependsOnMethods={"testCopyApiWithScopes"})
    public void testUpdateApiWithScopes() throws Exception {
        String tierCollection = "Gold";
        String endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api/add";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIScopeTestWithScopeName", "APIScopeTestWithScopeContext", API_VERSION, this.user.getUserName(), new URL(endpointUrl));
        apiCreationRequestBean.setTiersCollection(tierCollection);
        apiCreationRequestBean.setDescription("test api description");
        HttpResponse updateResponse = this.apiPublisher.updateAPI(apiCreationRequestBean);
        this.verifyResponse(updateResponse);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        if (this.apiStore != null) {
            this.apiStore.removeApplication(APP_NAME);
            this.apiStore.removeApplication("APIScopeTestWithScopeName");
        }
        if (this.apiPublisher != null) {
            this.apiPublisher.deleteAPI(API_NAME, API_VERSION, this.user.getUserName());
            this.apiPublisher.deleteAPI("APIScopeTestWithScopeName", API_VERSION, this.user.getUserName());
            this.apiPublisher.deleteAPI("APIScopeTestWithScopeName", "2.0.0", this.user.getUserName());
        }
        if (this.userManagementClient1 != null) {
            this.userManagementClient1.deleteUser(USER_JOHN);
            this.userManagementClient1.deleteRole(SUBSCRIBER_ROLE);
        }
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

