/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APISearchAPIByTagTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(APISearchAPIByTagTestCase.class);
    private final String API_NAME_1 = "APISearchAPIByTagAPIName_1";
    private final String API_NAME_2 = "APISearchAPIByTagAPIName_2";
    private final String API_CONTEXT_1 = "PISearchAPIByTagContext_1";
    private final String API_CONTEXT_2 = "PISearchAPIByTagContext_2";
    private final String TAG_API_1 = "api_1_tag";
    private final String TAG_API_2 = "api_2_tag";
    private final String TAG_API = "api_common_tag";
    private final String API_NAME_CONTEXT_UPPER_CASE = "apiNameContextUpperCaseTag";
    private final String API_NAME_CONTEXT_LOWER_CASE = "apiNameContextLowerCaseTag";
    private final String API_NAME_CONTEXT_WITH_SPACE = "apiNameContextWithSpaceTag";
    private final String API_NAME_CONTEXT_WITHOUT_SPACE = "apiNameContextWithoutSpaceTag";
    private final String TAG_GROUP_UPPER_CASE = "API_tag-group";
    private final String TAG_GROUP_LOWER_CASE = "api_tag-group";
    private final String TAG_GROUP_WITH_SPACE = "api tag-group";
    private final String TAG_GROUP_WITHOUT_SPACE = "apiTag-group";
    private final String TAG_NOT_EXIST = "no_such_tag";
    private final String DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION = "1.0.0";
    private static final long WAIT_TIME = 45000L;
    private String publisherURLHttps;
    private String storeURLHttp;
    private APICreationRequestBean apiCreationRequestBean;
    private List<APIResourceBean> resList;
    private String tags;
    private String tierCollection;
    private String endpointUrl;
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private ServerConfigurationManager serverConfigurationManager;

    @Factory(dataProvider="userModeDataProvider")
    public APISearchAPIByTagTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.publisherURLHttps = this.publisherUrls.getWebAppURLHttps();
        this.storeURLHttp = this.getStoreURLHttp();
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttps);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
        this.tierCollection = "Bronze,Gold,Silver,Unlimited";
    }

    @Test(groups={"wso2.am"}, description="Sample API creation")
    public void testAPICreation() throws Exception {
        this.resList = new ArrayList<APIResourceBean>();
        APIResourceBean addResource = new APIResourceBean("GET", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION.getAuthType(), "Unlimited", "/add");
        this.apiCreationRequestBean = new APICreationRequestBean("APISearchAPIByTagAPIName_1", "PISearchAPIByTagContext_1", "1.0.0", this.user.getUserName(), new URL(this.endpointUrl));
        this.tags = "api_common_tag,api_1_tag";
        this.apiCreationRequestBean.setTags(this.tags);
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTiersCollection(this.tierCollection);
        this.resList.add(addResource);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        HttpResponse serviceResponse = this.apiPublisher.addAPI(this.apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APISearchAPIByTagAPIName_1", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APISearchAPIByTagAPIName_1", "1.0.0", "\"isApiExists\":true");
        this.apiCreationRequestBean = new APICreationRequestBean("APISearchAPIByTagAPIName_2", "PISearchAPIByTagContext_2", "1.0.0", this.user.getUserName(), new URL(this.endpointUrl));
        this.tags = "api_common_tag,api_2_tag";
        this.apiCreationRequestBean.setTags(this.tags);
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTiersCollection(this.tierCollection);
        this.resList.add(addResource);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        serviceResponse = this.apiPublisher.addAPI(this.apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        updateRequest = new APILifeCycleStateRequest("APISearchAPIByTagAPIName_2", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APISearchAPIByTagAPIName_2", "1.0.0", "\"isApiExists\":true");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.serverConfigurationManager.restoreToLastConfiguration();
        }
        super.cleanUp();
    }

    @Test(groups={"wso2.am"}, description="API search by TAG", dependsOnMethods={"testAPICreation"})
    public void testAPISearchByTag() throws Exception {
        this.watForAPIsAvailableOnSearchApi();
        String searchTerm = "tags:api_common_tag";
        HttpResponse response = this.apiStore.searchPaginateAPIs(this.user.getUserDomain(), "0", "10", searchTerm);
        this.verifyResponse(response);
        JSONObject results = new JSONObject(response.getData());
        JSONArray resultArray = results.getJSONArray("result");
        Assert.assertEquals((int)resultArray.length(), (int)2, (String)"Search API return invalid APIs");
        Assert.assertTrue((boolean)response.getData().contains("APISearchAPIByTagAPIName_1"), (String)"API with searched tag not returned");
        Assert.assertTrue((boolean)response.getData().contains("APISearchAPIByTagAPIName_2"), (String)"API with searched tag not returned");
        searchTerm = "tags:api_1_tag";
        response = this.apiStore.searchPaginateAPIs(this.user.getUserDomain(), "0", "10", searchTerm);
        this.verifyResponse(response);
        results = new JSONObject(response.getData());
        resultArray = results.getJSONArray("result");
        Assert.assertEquals((int)resultArray.length(), (int)1, (String)"Search API return invalid APIs");
        Assert.assertTrue((boolean)response.getData().contains("APISearchAPIByTagAPIName_1"), (String)"API with searched tag not returned");
        Assert.assertFalse((boolean)response.getData().contains("APISearchAPIByTagAPIName_2"), (String)"Result contain API without the requested Tag");
        searchTerm = "tags:no_such_tag";
        response = this.apiStore.searchPaginateAPIs(this.user.getUserDomain(), "0", "10", searchTerm);
        this.verifyResponse(response);
        results = new JSONObject(response.getData());
        resultArray = results.getJSONArray("result");
        Assert.assertEquals((int)resultArray.length(), (int)0, (String)"Search API return invalid APIs");
    }

    @Test(groups={"wso2.am"}, description="API search by group TAG", dependsOnMethods={"testAPISearchByTag"})
    public void testAPISearchByTagGroup() throws Exception {
        String[] tt;
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
            String carbonHome = System.getProperty("carbon.home");
            File srcFile = new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "tag" + File.separator + "site.json");
            File targetFile = new File(carbonHome + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "jaggeryapps" + File.separator + "store" + File.separator + "site" + File.separator + "conf" + File.separator + "site.json");
            this.serverConfigurationManager.applyConfigurationWithoutRestart(srcFile, targetFile, true);
        }
        APIResourceBean addResource = new APIResourceBean("GET", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION.getAuthType(), "Unlimited", "/add");
        this.apiCreationRequestBean = new APICreationRequestBean("apiNameContextUpperCaseTag", "apiNameContextUpperCaseTag", "1.0.0", this.user.getUserName(), new URL(this.endpointUrl));
        this.apiCreationRequestBean.setTags("API_tag-group");
        this.resList.add(addResource);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        HttpResponse serviceResponse = this.apiPublisher.addAPI(this.apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("apiNameContextUpperCaseTag", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "apiNameContextUpperCaseTag", "1.0.0", "\"isApiExists\":true");
        this.apiCreationRequestBean = new APICreationRequestBean("apiNameContextLowerCaseTag", "apiNameContextLowerCaseTag", "1.0.0", this.user.getUserName(), new URL(this.endpointUrl));
        this.apiCreationRequestBean.setTags("api_tag-group");
        this.resList.add(addResource);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        serviceResponse = this.apiPublisher.addAPI(this.apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        updateRequest = new APILifeCycleStateRequest("apiNameContextLowerCaseTag", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "apiNameContextLowerCaseTag", "1.0.0", "\"isApiExists\":true");
        this.apiCreationRequestBean = new APICreationRequestBean("apiNameContextWithSpaceTag", "apiNameContextWithSpaceTag", "1.0.0", this.user.getUserName(), new URL(this.endpointUrl));
        this.apiCreationRequestBean.setTags("api tag-group");
        this.resList.add(addResource);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        serviceResponse = this.apiPublisher.addAPI(this.apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        updateRequest = new APILifeCycleStateRequest("apiNameContextWithSpaceTag", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "apiNameContextWithSpaceTag", "1.0.0", "\"isApiExists\":true");
        this.apiCreationRequestBean = new APICreationRequestBean("apiNameContextWithoutSpaceTag", "apiNameContextWithoutSpaceTag", "1.0.0", this.user.getUserName(), new URL(this.endpointUrl));
        this.apiCreationRequestBean.setTags("apiTag-group");
        this.resList.add(addResource);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        serviceResponse = this.apiPublisher.addAPI(this.apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        updateRequest = new APILifeCycleStateRequest("apiNameContextWithoutSpaceTag", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "apiNameContextWithoutSpaceTag", "1.0.0", "\"isApiExists\":true");
        this.watForTagsAvailableOnSearchApi("apiTag-group");
        HttpResponse res = this.apiStore.getAllTags();
        JSONObject tags = new JSONObject(res.getData());
        JSONArray tagList = tags.getJSONArray("tags");
        for (String t : tt = new String[]{"API_tag-group", "api_tag-group", "api tag-group", "apiTag-group"}) {
            boolean found = false;
            for (int i = 0; i < tagList.length(); ++i) {
                JSONObject tagObj = tagList.getJSONObject(i);
                if (!t.equals(tagObj.getString("name"))) continue;
                Assert.assertEquals((int)tagObj.getInt("count"), (int)1);
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found, (String)("Tag " + t + " is not available on tag cloud"));
        }
    }

    public void watForAPIsAvailableOnSearchApi() throws Exception {
        String searchTerm = "";
        long waitTime = System.currentTimeMillis() + 45000L;
        while (waitTime > System.currentTimeMillis()) {
            HttpResponse response = this.apiStore.searchPaginateAPIs(this.user.getUserDomain(), "0", "10", searchTerm);
            this.verifyResponse(response);
            this.log.info((Object)"WAIT for availability of API : APISearchAPIByTagAPIName_1 and APISearchAPIByTagAPIName_2 found on Store search API");
            if (response == null) continue;
            this.log.info((Object)("Data: " + response.getData()));
            if (response.getData().contains("APISearchAPIByTagAPIName_1") && response.getData().contains("APISearchAPIByTagAPIName_2")) {
                this.log.info((Object)"API :APISearchAPIByTagAPIName_1 and APISearchAPIByTagAPIName_2 found");
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void watForTagsAvailableOnSearchApi(String tag) throws Exception {
        long waitTime = System.currentTimeMillis() + 45000L;
        while (waitTime > System.currentTimeMillis()) {
            HttpResponse response = this.apiStore.getAllTags();
            this.verifyResponse(response);
            this.log.info((Object)("WAIT for availability of tags : " + tag + " found on Store tag cloud"));
            if (response == null) continue;
            this.log.info((Object)("Data: " + response.getData()));
            if (response.getData().contains(tag)) {
                this.log.info((Object)("Tag :" + tag + " found"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

