/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.wso2.am.admin.clients.webapp.WebAppAdminClient;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.TestConfigurationProvider;
import org.wso2.am.integration.test.utils.webapp.WebAppDeploymentUtil;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;

public class AdvancedWebAppDeploymentConfig
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(AdvancedWebAppDeploymentConfig.class);
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private String providerName;
    private WebAppAdminClient webAppAdminClient;
    private APIIdentifier apiIdentifier;

    @BeforeTest(alwaysRun=true)
    public void deployWebApps() throws Exception {
        super.init();
        String fileFormat = ".war";
        String webApp = "jaxrs_basic";
        String path = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator;
        String sourcePath = path + webApp + fileFormat;
        String sessionId = this.createSession(this.gatewayContextWrk);
        this.webAppAdminClient = new WebAppAdminClient(this.gatewayContextWrk.getContextUrls().getBackEndUrl(), sessionId);
        this.webAppAdminClient.uploadWarFile(sourcePath);
        this.webAppAdminClient.uploadWarFile(path + "name-check1_SB" + ".war");
        WebAppDeploymentUtil.isWebApplicationDeployed((String)this.gatewayContextWrk.getContextUrls().getBackEndUrl(), (String)sessionId, (String)webApp);
        WebAppDeploymentUtil.isWebApplicationDeployed((String)this.gatewayContextWrk.getContextUrls().getBackEndUrl(), (String)sessionId, (String)"name-check1_SB");
        log.info((Object)"Web App Deployed");
        this.initialize();
    }

    @AfterTest(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.apiStoreClientUser1.removeApplication("ApplicationTest");
        super.cleanUp();
    }

    private void initialize() throws Exception {
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.createAPIs();
    }

    private void createAPIs() throws Exception {
        this.apiStoreClientUser1.addApplication("ApplicationTest", "50PerMin", "", "");
        this.apiIdentifier = new APIIdentifier(this.providerName, "APITest", "1.0.0");
        this.apiIdentifier.setTier("Gold");
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APITest", "{version}/api", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.createPublishAndSubscribeToAPI(this.apiIdentifier, apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, "ApplicationTest");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APITest", "1.0.0", "\"isApiExists\":true");
    }
}

