/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APIThrottlingTier;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class InvalidAuthTokenLargePayloadTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(InvalidAuthTokenLargePayloadTestCase.class);
    private final String API_NAME = "InvalidAuthTokenLargePayloadAPIName";
    private final String API_CONTEXT = "InvalidAuthTokenLargePayloadContext";
    private final String DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION = "1.0.0";
    private final String APP_NAME = "InvalidAuthTokenLargePayloadApp";
    private String publisherURLHttp;
    private APICreationRequestBean apiCreationRequestBean;
    private List<APIResourceBean> resList;
    private String endpointUrl;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String tierCollection;
    private String testFile1KBFilePath;
    private String testFile100KBFilePath;
    private String testFile1MBFilePath;

    @Factory(dataProvider="userModeDataProvider")
    public InvalidAuthTokenLargePayloadTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.publisherURLHttp = this.getPublisherURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.tierCollection = "Bronze,Gold,Silver,Unlimited";
        String testArtifactPath = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "testFiles";
        this.testFile1KBFilePath = testArtifactPath + File.separator + "test1kb.db";
        this.testFile100KBFilePath = testArtifactPath + File.separator + "test100kb.db";
        this.testFile1MBFilePath = testArtifactPath + File.separator + "test1Mb.db";
    }

    @Test(groups={"wso2.am"}, description="Sample API creation")
    public void testApiCreation() throws Exception {
        String providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("InvalidAuthTokenLargePayloadAPIName", "InvalidAuthTokenLargePayloadContext", "1.0.0", providerName, new URL(this.endpointUrl));
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTiersCollection(this.tierCollection);
        this.resList = new ArrayList<APIResourceBean>();
        APIResourceBean resource = new APIResourceBean("POST", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType(), "Plus", "/post");
        this.resList.add(resource);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        HttpResponse serviceResponse = this.apiPublisher.addAPI(this.apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("InvalidAuthTokenLargePayloadAPIName", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
    }

    @Test(groups={"wso2.am"}, description="Subscribe and invoke api", dependsOnMethods={"testApiCreation"})
    public void testApiInvocation() throws Exception {
        HttpResponse response;
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiStore.login(this.user.getUserName(), String.valueOf(this.user.getPassword()));
        HttpResponse serviceResponse = this.apiStore.addApplication("InvalidAuthTokenLargePayloadApp", APIThrottlingTier.UNLIMITED.getState(), "", "this-is-test");
        this.verifyResponse(serviceResponse);
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("InvalidAuthTokenLargePayloadAPIName", this.user.getUserName());
        subscriptionRequest.setApplicationName("InvalidAuthTokenLargePayloadApp");
        subscriptionRequest.setTier("Gold");
        serviceResponse = this.apiStore.subscribe(subscriptionRequest);
        this.verifyResponse(serviceResponse);
        this.requestHeaders.put("Authorization", "Bearer invalid_token_key");
        this.requestHeaders.put("Content-Type", ContentType.APPLICATION_JSON.toString());
        String invokeURL = this.getAPIInvocationURLHttp("InvalidAuthTokenLargePayloadContext", "1.0.0") + "/post";
        try {
            response = this.uploadFile(invokeURL, new File(this.testFile1KBFilePath), this.requestHeaders);
            Assert.fail((String)"Resource cannot be access with wrong access token");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(String.valueOf(401)));
        }
        try {
            response = this.uploadFile(invokeURL, new File(this.testFile100KBFilePath), this.requestHeaders);
            Assert.fail((String)"Resource cannot be access with wrong access token");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(String.valueOf(401)));
        }
        try {
            response = this.uploadFile(invokeURL, new File(this.testFile1MBFilePath), this.requestHeaders);
            Assert.fail((String)"Resource cannot be access with wrong access token");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(String.valueOf(401)));
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication("InvalidAuthTokenLargePayloadApp");
        this.apiPublisher.deleteAPI("InvalidAuthTokenLargePayloadAPIName", "1.0.0", this.user.getUserName());
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse uploadFile(String endpointUrl, File fileName, Map<String, String> headers) throws IOException {
        String temp;
        URL url = new URL(endpointUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        FileBody fileBody = new FileBody(fileName);
        MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.STRICT);
        multipartEntity.addPart("file", (ContentBody)fileBody);
        connection.setRequestProperty("Content-Type", multipartEntity.getContentType().getValue());
        if (headers != null && headers.size() > 0) {
            for (String string : headers.keySet()) {
                if (string == null) continue;
                connection.setRequestProperty(string, headers.get(string));
            }
            for (String key : headers.keySet()) {
                connection.setRequestProperty(key, headers.get(key));
            }
        }
        OutputStream out = connection.getOutputStream();
        try {
            multipartEntity.writeTo(out);
        }
        finally {
            out.close();
        }
        int n = connection.getResponseCode();
        BufferedReader read = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder responseMsg = new StringBuilder();
        while ((temp = read.readLine()) != null) {
            responseMsg.append(temp);
        }
        HttpResponse response = new HttpResponse(responseMsg.toString(), n);
        return response;
    }
}

