/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class NewCopyWithDefaultVersion
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(NewCopyWithDefaultVersion.class);
    private APIPublisherRestClient apiPublisher;
    private String API_NAME = "DefaultVersionAPITest";
    private String apiContext = "DefaultVersionAPI";
    private String version = "1.0.0";
    private static String newVersion = "2.0.0";
    private String TAGS = "testtag1, testtag2";
    private String providerName;
    private String visibility = "public";
    private String description = "Test Description";
    private String tier = "Gold";
    private String resTier = "Ultimate";
    private String endPointType = "http";

    @Factory(dataProvider="userModeDataProvider")
    public NewCopyWithDefaultVersion(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        String publisherUrlHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherUrlHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
    }

    @Test(groups={"webapp"}, description="New Copy with Default Version")
    public void setDefaultVersionToNewcopy() throws Exception {
        String gatewayUrl = this.gatewayContextWrk.getContextTenant().getDomain().equals("carbon.super") ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        String endpointUrl = gatewayUrl + "jaxrs_basic/services/customers/customerservice";
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        ArrayList<APIResourceBean> apiResourceBeanList = new ArrayList<APIResourceBean>();
        apiResourceBeanList.add(new APIResourceBean("GET", "Application & Application User", this.resTier, "customers/{id}/"));
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(this.API_NAME, this.apiContext, this.version, this.providerName, new URL(endpointUrl));
        apiCreationRequestBean.setEndpointType(this.endPointType);
        apiCreationRequestBean.setResourceBeanList(apiResourceBeanList);
        apiCreationRequestBean.setTier(this.tier);
        apiCreationRequestBean.setDescription(this.description);
        apiCreationRequestBean.setDefault_version(this.version);
        apiCreationRequestBean.setTags(this.TAGS);
        apiCreationRequestBean.setVisibility(this.visibility);
        HttpResponse apiAddRequest = this.apiPublisher.addAPI(apiCreationRequestBean);
        Assert.assertEquals((int)apiAddRequest.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
        Assert.assertTrue((boolean)apiAddRequest.getData().contains("{\"error\" : false}"), (String)"Response Data Mismatched");
        HttpResponse apiCopyResponse = this.apiPublisher.copyAPI(this.providerName, this.API_NAME, this.version, newVersion, "default_version");
        Assert.assertEquals((int)apiCopyResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatch");
        Assert.assertTrue((boolean)apiCopyResponse.getData().contains("{\"error\" : false}"), (String)"Response Data Mismatched");
        HttpResponse newVersionApi = this.apiPublisher.getAPI(this.API_NAME, this.providerName, newVersion);
        Assert.assertEquals((int)newVersionApi.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatched");
        JSONObject jsonObject = new JSONObject(newVersionApi.getData());
        String name = jsonObject.getJSONObject("api").getString("name");
        Assert.assertEquals((String)name, (String)this.API_NAME, (String)"API name is mismatched");
        String version = jsonObject.getJSONObject("api").getString("version");
        Assert.assertEquals((String)version, (String)newVersion, (String)"API Version is mismatched");
        boolean defaultVersion = jsonObject.getJSONObject("api").getBoolean("isDefaultVersion");
        Assert.assertEquals((boolean)defaultVersion, (boolean)true, (String)"Error in Default Version selection");
        String currentDefaultVersionCheck = jsonObject.getJSONObject("api").getString("currentDefaultVersion");
        Assert.assertEquals((String)currentDefaultVersionCheck, (String)newVersion, (String)"Error in Default Version");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiPublisher.deleteAPI(this.API_NAME, this.version, this.providerName);
        this.apiPublisher.deleteAPI(this.API_NAME, newVersion, this.providerName);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

