/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.mail.internet.MimeMessage;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class NotificationTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(NotificationTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private static final String API_NAME = "NOTIFICATION_TEST_API";
    private static final String API_CONTEXT = "NOTIFICATION_TEST_API";
    private static final String API_VERSION = "1.0.0";
    private static final String NEW_API_VERSION = "2.0.0";
    private static final String APP_NAME = "NOTIFICATION_TEST_APP";
    private final String STORE_USERNAME = "api_store";
    private final String STORE_PASSWORD = "admin";
    private static final String EMAIL_USERNAME = "APIM";
    private static final String EMAIL_PASSWORD = "APIM+123";
    private static final String USER_EMAIL_ADDRESS = "apim@gmail.com";
    private static final int SMTP_TEST_PORT = 3025;
    private String gatewaySessionCookie;
    private GreenMail greenMail;
    private String storeURLHttp;

    @Factory(dataProvider="userModeDataProvider")
    public NotificationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String publisherURLHttp = this.getPublisherURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
    }

    @Test(groups={"wso2.am"}, description="Testing Notification Feature")
    public void notificationTestCase() throws Exception {
        ServerSetup setup = new ServerSetup(3025, "localhost", "smtp");
        this.greenMail = new GreenMail(setup);
        this.greenMail.setUser(USER_EMAIL_ADDRESS, EMAIL_USERNAME, EMAIL_PASSWORD);
        this.greenMail.start();
        log.info((Object)"green mail server started ");
        String url = this.getGatewayURLNhttp() + "response";
        String description = "This is a test API created by API manager integration test";
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        APIRequest apiRequest = new APIRequest("NOTIFICATION_TEST_API", "NOTIFICATION_TEST_API", new URL(url));
        apiRequest.setDescription(description);
        apiRequest.setVersion(API_VERSION);
        apiRequest.setProvider(this.user.getUserName());
        this.apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("NOTIFICATION_TEST_API", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        AutomationContext storeContext = new AutomationContext(EMAIL_USERNAME, "store", TestUserMode.SUPER_TENANT_ADMIN);
        HttpResponse storeSignUpResponse = this.signUp("api_store", "admin", USER_EMAIL_ADDRESS);
        log.info((Object)"Sign Up User: api_store");
        JSONObject signUpJsonObject = new JSONObject(storeSignUpResponse.getData());
        Assert.assertFalse((boolean)signUpJsonObject.getBoolean("error"), (String)"Error in user sign up Response");
        HttpResponse loginResponse = this.apiStore.login("api_store", "admin");
        JSONObject loginJsonObject = new JSONObject(loginResponse.getData());
        Assert.assertFalse((boolean)loginJsonObject.getBoolean("error"), (String)"Error in Login Request: User Name : api_store");
        this.apiStore.login("api_store", "admin");
        this.apiStore.addApplication(APP_NAME, "Unlimited", "some_url", "NewApp");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("NOTIFICATION_TEST_API", this.user.getUserName());
        subscriptionRequest.setApplicationName(APP_NAME);
        this.apiStore.subscribe(subscriptionRequest);
        HttpResponse newVersionResponse = this.apiPublisher.copyAPI(this.user.getUserName(), "NOTIFICATION_TEST_API", API_VERSION, NEW_API_VERSION, "");
        Assert.assertEquals((int)newVersionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatch");
        APIIdentifier apiIdentifier = new APIIdentifier(this.user.getUserName(), "NOTIFICATION_TEST_API", NEW_API_VERSION);
        HttpResponse newVersionPublishResponse = this.apiPublisher.changeAPILifeCycleStatusToPublish(apiIdentifier, false);
        Assert.assertEquals((int)newVersionPublishResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatch");
        this.greenMail.waitForIncomingEmail(50000L, 1);
        MimeMessage[] messages = this.greenMail.getReceivedMessages();
        if (messages.length > 0) {
            Assert.assertTrue((boolean)true, (String)"Email received BY Greenmail server");
        } else {
            Assert.assertTrue((boolean)false, (String)"Email NOT received BY Greenmail server");
        }
    }

    protected String readFile(String fileLocation) throws APIManagerIntegrationTestException {
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(new File(fileLocation)));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException ioE) {
            throw new APIManagerIntegrationTestException("IOException when reading the file from:" + fileLocation, (Throwable)ioE);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error when closing the buffer reade which used to reed the file:" + fileLocation + ". Error:" + e.getMessage()));
                }
            }
        }
    }

    public HttpResponse signUp(String userName, String password, String email) throws APIManagerIntegrationTestException {
        try {
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            requestHeaders.put("Content-Type", "application/x-www-form-urlencoded");
            return HttpRequestUtil.doPost((URL)new URL(this.storeURLHttp + "store/site/blocks/user/sign-up/ajax/user-add.jag"), (String)("action=addUser&username=" + userName + "&password=" + password + "&allFieldsValues=" + "||||" + email), requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Error in user sign up. Error: " + e.getMessage(), (Throwable)e);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        if (this.apiStore != null) {
            this.apiStore.removeApplication(APP_NAME);
        }
        if (this.apiPublisher != null) {
            this.apiPublisher.deleteAPI("NOTIFICATION_TEST_API", API_VERSION, this.user.getUserName());
        }
        this.greenMail.stop();
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }
}

