/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;

public class PublisherAccessControlTestCase
extends APIMIntegrationBaseTest {
    private static final String VERSION = "1.0.0";
    private static final String RESTRICTED_ACCESS_CONTROL = "restricted";
    private static final String PUBLIC_VISIBILITY = "public";
    private static final String NO_ACCESS_CONTROL = "all";
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStoreRestClient;
    private String contextUsername = "admin";
    private String contextUserPassword = "admin";
    private final String FIRST_USER = "publisher_user";
    private final String SECOND_USER = "publisher_user2";
    private final String PUB_SUB_USER = "pub_sub_user1";
    private final String FIRST_ROLE = "publisher_role1";
    private final String SECOND_ROLE = "publisher_role2";
    private final String SUBSCRIBER_ROLE = "subscriber_role1";
    private final String PUB_SUB_ROLE = "pub_sub_role1";
    private final String USER_PASSWORD = "123123";
    private final String SUBSCRIBER_USER = "subscriber_user1";
    private final String EP_URL = "http://gdata.youtube.com/feeds/api/standardfeeds";
    private String publisherAccessControlAPI = "PublisherAccessControl";
    private String publisherAccessControlAPI2 = "PublisherAccessControl2";
    private String publicAccessRestrictedVisibilityAPI = "PublicAccessRestrictedVisibility";
    private String accessControlledPublicVisibilityAPI = "AccessControlledPublicVisibility";
    private final String restrictedAccessRestrictedVisibilityAPI = "RestrictedAccessRestrictedVisibility";
    UserManagementClient userManagementClient1;

    @BeforeClass
    public void initTestCase() throws APIManagerIntegrationTestException, XPathExpressionException, RemoteException, UserAdminUserAdminException {
        super.init();
        this.publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        this.apiStoreRestClient = new APIStoreRestClient(this.storeURLHttp);
        this.contextUsername = this.keyManagerContext.getContextTenant().getContextUser().getUserName();
        this.contextUserPassword = this.keyManagerContext.getContextTenant().getContextUser().getPassword();
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.contextUsername, this.contextUserPassword);
        String apiCreatePermission = "/permission/admin/manage/api/create";
        String loginPermission = "/permission/admin/login";
        this.userManagementClient1.addRole("publisher_role1", new String[0], new String[]{loginPermission, apiCreatePermission});
        String apiPublishPermission = "/permission/admin/manage/api/publish";
        String apiSubscribePermission = "/permission/admin/manage/api/subscribe";
        this.userManagementClient1.addRole("publisher_role2", new String[0], new String[]{loginPermission, apiPublishPermission});
        this.userManagementClient1.addRole("subscriber_role1", new String[0], new String[]{loginPermission, apiSubscribePermission});
        this.userManagementClient1.addRole("pub_sub_role1", new String[0], new String[]{loginPermission, apiPublishPermission, apiSubscribePermission});
        this.userManagementClient1.addUser("publisher_user", "123123", new String[]{"publisher_role1"}, "publisher_user");
        this.userManagementClient1.addUser("publisher_user2", "123123", new String[]{"publisher_role2"}, "publisher_user2");
        this.userManagementClient1.addUser("subscriber_user1", "123123", new String[]{"subscriber_role1"}, "subscriber_user1");
        this.userManagementClient1.addUser("pub_sub_user1", "123123", new String[]{"pub_sub_role1"}, "pub_sub_user1");
    }

    @Test(groups={"wso2.am"}, description="This test case tests the retrieval of API which was added with a access control restriction.")
    public void testAPIAdditionWithAccessControlRestriction() throws Exception {
        this.apiPublisher.login(this.contextUsername, this.contextUserPassword);
        APIRequest brokenApiRequest = new APIRequest(this.publisherAccessControlAPI, this.publisherAccessControlAPI, new URL("http://gdata.youtube.com/feeds/api/standardfeeds"));
        brokenApiRequest.setVersion(VERSION);
        brokenApiRequest.setProvider(this.contextUsername);
        brokenApiRequest.setAccessControl(RESTRICTED_ACCESS_CONTROL);
        brokenApiRequest.setAccessControlRoles("publisher_role1");
        this.apiPublisher.addAPI(brokenApiRequest);
        HttpResponse response = this.apiPublisher.getAPI(this.publisherAccessControlAPI, this.contextUsername);
        Assert.assertTrue((boolean)response.getData().contains("publisher_role1"), (String)"API was not visible to the APIM admin user");
        this.apiPublisher.logout();
        this.apiPublisher.login("publisher_user", "123123");
        response = this.apiPublisher.getAPI(this.publisherAccessControlAPI, this.contextUsername);
        Assert.assertTrue((boolean)response.getData().contains("publisher_role1"), (String)"API was not visible to the creators who have the relevant access control roles of the API");
        this.apiPublisher.logout();
        this.apiPublisher.login("publisher_user2", "123123");
        response = this.apiPublisher.getAPI(this.publisherAccessControlAPI, this.contextUsername);
        Assert.assertFalse((boolean)response.getData().contains("publisher_role1"), (String)"API was visible to the creators who do not have the relevant access control roles of the API");
    }

    @Test(groups={"wso2.am"}, description="This test case tests the retrieval of API which was added without access control restriction.")
    public void testAPIAdditionWithoutAccessControlRestriction() throws APIManagerIntegrationTestException, MalformedURLException {
        this.apiPublisher.login(this.contextUsername, this.contextUserPassword);
        APIRequest brokenApiRequest = new APIRequest(this.publisherAccessControlAPI2, this.publisherAccessControlAPI2, new URL("http://gdata.youtube.com/feeds/api/standardfeeds"));
        brokenApiRequest.setVersion(VERSION);
        brokenApiRequest.setProvider(this.contextUsername);
        this.apiPublisher.addAPI(brokenApiRequest);
        HttpResponse response = this.apiPublisher.getAPI(this.publisherAccessControlAPI2, this.contextUsername);
        Assert.assertTrue((boolean)response.getData().contains("\"provider\" : \"admin\""), (String)"API is not visible to APIM admin without access control restriction");
        this.apiPublisher.logout();
        this.apiPublisher.login("publisher_user", "123123");
        response = this.apiPublisher.getAPI(this.publisherAccessControlAPI2, this.contextUsername);
        Assert.assertTrue((boolean)response.getData().contains("\"provider\" : \"admin\""), (String)"API is not visible to creator without access control restriction");
        this.apiPublisher.logout();
        this.apiPublisher.login("publisher_user2", "123123");
        response = this.apiPublisher.getAPI(this.publisherAccessControlAPI2, this.contextUsername);
        Assert.assertTrue((boolean)response.getData().contains("\"provider\" : \"admin\""), (String)"API is not visible to creator without access control restriction");
    }

    @Test(groups={"wso2.am"}, description="This test case tests the retrieval of API which from store which was added without access control restriction and public visibility.")
    public void testGetPublicAPIFromStoreWithRestrictedPublisherAccess() throws APIManagerIntegrationTestException, MalformedURLException, XPathExpressionException {
        this.apiPublisher.login(this.contextUsername, this.contextUserPassword);
        APIRequest createAPIRequest = new APIRequest(this.accessControlledPublicVisibilityAPI, this.accessControlledPublicVisibilityAPI, new URL("http://gdata.youtube.com/feeds/api/standardfeeds"));
        createAPIRequest.setVersion(VERSION);
        createAPIRequest.setProvider(this.contextUsername);
        createAPIRequest.setAccessControl(RESTRICTED_ACCESS_CONTROL);
        createAPIRequest.setAccessControlRoles("publisher_role1");
        createAPIRequest.setVisibility(PUBLIC_VISIBILITY);
        this.apiPublisher.addAPI(createAPIRequest);
        APIIdentifier apiIdentifier = new APIIdentifier(this.contextUsername, this.accessControlledPublicVisibilityAPI, VERSION);
        this.apiPublisher.changeAPILifeCycleStatusToPublish(apiIdentifier, false);
        this.apiStoreRestClient.login("subscriber_user1", "123123");
        HttpResponse httpResponse = this.apiStoreRestClient.getAllPublishedAPIs(this.storeContext.getContextTenant().getDomain());
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)200, (String)"Response code does not match");
        Assert.assertTrue((boolean)httpResponse.getData().contains(this.accessControlledPublicVisibilityAPI), (String)("Public API with name " + this.accessControlledPublicVisibilityAPI + "is not " + "returned"));
    }

    @Test(groups={"wso2.am"}, description="This test case add restricted visibility on store for role1, but user who can log into publisher should be able to view the api even though he does not have the role role1")
    public void testCheckPublisherRoleCanViewRestrictedVisibilityAPIs() throws APIManagerIntegrationTestException, MalformedURLException, XPathExpressionException {
        this.apiPublisher.login(this.contextUsername, this.contextUserPassword);
        APIRequest createAPIRequest = new APIRequest(this.publicAccessRestrictedVisibilityAPI, this.publicAccessRestrictedVisibilityAPI, new URL("http://gdata.youtube.com/feeds/api/standardfeeds"));
        createAPIRequest.setVersion(VERSION);
        createAPIRequest.setProvider(this.contextUsername);
        createAPIRequest.setAccessControl(NO_ACCESS_CONTROL);
        createAPIRequest.setVisibility(RESTRICTED_ACCESS_CONTROL);
        createAPIRequest.setRoles("publisher_role1");
        this.apiPublisher.addAPI(createAPIRequest);
        APIIdentifier apiIdentifier = new APIIdentifier(this.contextUsername, this.publicAccessRestrictedVisibilityAPI, VERSION);
        this.apiPublisher.changeAPILifeCycleStatusToPublish(apiIdentifier, false);
        this.apiStoreRestClient.login("pub_sub_user1", "123123");
        HttpResponse httpResponse = this.apiStoreRestClient.getAllPublishedAPIs(this.storeContext.getContextTenant().getDomain());
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)200, (String)"Response code does not match");
        Assert.assertTrue((boolean)httpResponse.getData().contains(this.publicAccessRestrictedVisibilityAPI), (String)("Restricted visible api " + this.publicAccessRestrictedVisibilityAPI + "is not" + " visible to user  " + "pub_sub_user1" + ", who can view it in publisher"));
    }

    @Test(groups={"wso2.am"}, description="This test case add restricted access in publisher(role1) and restricted visibility in store(subscriber_role1). So check correct behaviour in publisher and store ")
    public void testPublisherAndStoreRestricted() throws Exception {
        this.apiPublisher.login(this.contextUsername, this.contextUserPassword);
        APIRequest createAPIRequest = new APIRequest("RestrictedAccessRestrictedVisibility", "RestrictedAccessRestrictedVisibility", new URL("http://gdata.youtube.com/feeds/api/standardfeeds"));
        createAPIRequest.setVersion(VERSION);
        createAPIRequest.setProvider(this.contextUsername);
        createAPIRequest.setAccessControl(RESTRICTED_ACCESS_CONTROL);
        createAPIRequest.setAccessControlRoles("publisher_role1");
        createAPIRequest.setVisibility(PUBLIC_VISIBILITY);
        this.apiPublisher.addAPI(createAPIRequest);
        APIIdentifier apiIdentifier = new APIIdentifier(this.contextUsername, "RestrictedAccessRestrictedVisibility", VERSION);
        this.apiPublisher.changeAPILifeCycleStatusToPublish(apiIdentifier, false);
        Thread.sleep(10000L);
        this.apiPublisher.login("publisher_user", "123123");
        HttpResponse publisherAllAPIS = this.apiPublisher.getAllAPIs();
        Assert.assertEquals((int)publisherAllAPIS.getResponseCode(), (int)200, (String)"Response code does not match");
        Assert.assertTrue((boolean)publisherAllAPIS.getData().contains("RestrictedAccessRestrictedVisibility"), (String)"Restricted visible api RestrictedAccessRestrictedVisibilityis not visible to user  publisher_user, who should be able to view it");
        this.apiPublisher.login("pub_sub_user1", "123123");
        publisherAllAPIS = this.apiPublisher.getAllAPIs();
        Assert.assertEquals((int)publisherAllAPIS.getResponseCode(), (int)200, (String)"Response code does not match");
        Assert.assertFalse((boolean)publisherAllAPIS.getData().contains("RestrictedAccessRestrictedVisibility"), (String)"Restricted access api RestrictedAccessRestrictedVisibilityis visible to user  publisher_user, who should not be able to view it");
        this.apiPublisher.login(this.contextUsername, this.contextUserPassword);
        createAPIRequest.setVisibility(RESTRICTED_ACCESS_CONTROL);
        createAPIRequest.setRoles("subscriber_role1");
        this.apiPublisher.updateAPI(createAPIRequest);
        Thread.sleep(10000L);
        this.apiStoreRestClient.login("subscriber_user1", "123123");
        HttpResponse storeAllAPIs = this.apiStoreRestClient.getAllPaginatedPublishedAPIs(this.storeContext.getContextTenant().getDomain(), 0, 10);
        Assert.assertEquals((int)storeAllAPIs.getResponseCode(), (int)200, (String)"Response code does not match");
        Assert.assertTrue((boolean)storeAllAPIs.getData().contains("RestrictedAccessRestrictedVisibility"), (String)"Restricted visible api RestrictedAccessRestrictedVisibility is not visible to user  subscriber_user1, who can  view it in store");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiPublisher.deleteAPI(this.publisherAccessControlAPI, VERSION, this.contextUsername);
        this.apiPublisher.deleteAPI(this.publicAccessRestrictedVisibilityAPI, VERSION, this.contextUsername);
        this.apiPublisher.deleteAPI(this.publisherAccessControlAPI2, VERSION, this.contextUsername);
        this.apiPublisher.deleteAPI("RestrictedAccessRestrictedVisibility", VERSION, this.contextUsername);
        this.apiPublisher.deleteAPI(this.accessControlledPublicVisibilityAPI, VERSION, this.contextUsername);
        this.userManagementClient1.deleteUser("publisher_user");
        this.userManagementClient1.deleteUser("publisher_user2");
        this.userManagementClient1.deleteUser("subscriber_user1");
        this.userManagementClient1.deleteUser("pub_sub_user1");
        this.userManagementClient1.deleteRole("publisher_role1");
        this.userManagementClient1.deleteRole("publisher_role2");
        this.userManagementClient1.deleteRole("subscriber_role1");
        this.userManagementClient1.deleteRole("pub_sub_role1");
    }
}

