/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class SameVersionAPITestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(SameVersionAPITestCase.class);
    private APIPublisherRestClient apiPublisher;
    private static final String API_NAME = "SameVersionAPITest";
    private static final String API_CONTEXT = "SameVersionAPI";
    private String version = "1.0.0";
    private String newVersion = "1.0.0";
    private String TAGS = "testtag1, testtag2";
    private String providerName;
    private String visibility = "public";
    private String description = "Test Description";
    private String tier = "Gold";
    private String resTier = "Ultimate";
    private String endPointType = "http";

    @Factory(dataProvider="userModeDataProvider")
    public SameVersionAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        String publisherUrlHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherUrlHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
    }

    @Test(groups={"webapp"}, description="Copy Same Version")
    public void copySameVersion() throws Exception {
        String gatewayUrl = this.gatewayContextWrk.getContextTenant().getDomain().equals("carbon.super") ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        String endpointUrl = gatewayUrl + "jaxrs_basic/services/customers/customerservice";
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", this.resTier, "customers/{id}/"));
        resourceBeanList.add(new APIResourceBean("POST", "Application & Application User", this.resTier, "customers/name/"));
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(API_NAME, API_CONTEXT, this.version, this.providerName, new URL(endpointUrl));
        apiCreationRequestBean.setResourceBeanList(resourceBeanList);
        apiCreationRequestBean.setTags(this.TAGS);
        apiCreationRequestBean.setDescription(this.description);
        apiCreationRequestBean.setTier(this.tier);
        apiCreationRequestBean.setVisibility(this.visibility);
        apiCreationRequestBean.setEndpointType(this.endPointType);
        HttpResponse apiAddRequest = this.apiPublisher.addAPI(apiCreationRequestBean);
        Assert.assertEquals((int)apiAddRequest.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
        Assert.assertTrue((boolean)apiAddRequest.getData().contains("{\"error\" : false}"), (String)"Response Data Mismatched");
        HttpResponse copyAPIResponse = this.apiPublisher.copyAPI(this.providerName, API_NAME, this.version, this.newVersion, "");
        Assert.assertEquals((int)copyAPIResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatched");
        Assert.assertTrue((boolean)copyAPIResponse.getData().contains("\"error\" : true"), (String)"Response Data Mismatched. No error thrown.");
        Assert.assertTrue((boolean)copyAPIResponse.getData().contains("API already exists with version: " + this.version), (String)"Response Data Mismatched.");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiPublisher.deleteAPI(API_NAME, this.version, this.providerName);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

