/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class StoreChangePasswordTestCase
extends APIMIntegrationBaseTest {
    private APIStoreRestClient apiStoreClient;
    Log log = LogFactory.getLog(StoreChangePasswordTestCase.class);

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiStoreClient = new APIStoreRestClient(storeURLHttp);
        this.apiStoreClient.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
    }

    @Test(groups={"wso2.am"}, description="Change password in a invalid session")
    public void changePasswordWithInvalidSession() throws Exception {
        this.apiStoreClient.logout();
        HttpResponse serviceResponse = this.apiStore.changePassword(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword(), "newPassword!");
        JSONObject response = new JSONObject(serviceResponse.getData());
        Assert.assertTrue((boolean)response.getBoolean("error"), (String)"Should get an error when trying to change password in a invalid session.");
        Assert.assertEquals((Object)response.get("message"), (Object)"Please login with a valid username/password", (String)"Should get an error when trying to change password in a invalid session.");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_USER}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public StoreChangePasswordTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }
}

