/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIDesignBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM514CreateAnAPIWithoutProvidingMandatoryFieldsTestCase
extends APIMIntegrationBaseTest {
    private final String apiNameTest1 = "APIM514PublisherTest1";
    private final String apiVersion = "1.0.0";
    private final String apiDescription = "This is Test API Created by API Manager Integration Test";
    private String apiTag = "tag514-1, tag514-2, tag514-3";
    private APIPublisherRestClient apiPublisher;
    private String apiProviderName;
    private String apiProductionEndPointUrl;

    @Factory(dataProvider="userModeDataProvider")
    public APIM514CreateAnAPIWithoutProvidingMandatoryFieldsTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiProductionEndPointUrl = this.getGatewayURLHttp() + apiProductionEndpointPostfixUrl;
        this.apiProviderName = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Create an API Through the Publisher Rest API without proving API Name")
    public void testCreateAnAPIThroughThePublisherRestWithoutName() throws Exception {
        String apiContextTest = "apim514PublisherTestAPI1";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("", apiContextTest, "1.0.0", this.apiProviderName, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        JSONObject apiResponse = new JSONObject(apiCreationResponse.getData());
        Assert.assertTrue((boolean)apiResponse.getBoolean("error"), (String)"can be create API without name");
        Assert.assertTrue((boolean)apiResponse.getString("message").contains("API name is not specified"), (String)"can be create API without name");
    }

    @Test(groups={"wso2.am"}, description="Create an API Through the Publisher Rest API without proving Context")
    public void testCreateAnAPIThroughThePublisherRestWithoutContext() throws Exception {
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM514PublisherTest1", "", "1.0.0", this.apiProviderName, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        JSONObject apiResponse = new JSONObject(apiCreationResponse.getData());
        Assert.assertTrue((boolean)apiResponse.getBoolean("error"), (String)"APIM514PublisherTest1can be create without Context");
        Assert.assertTrue((boolean)apiResponse.getString("message").contains("Context not defined for API"), (String)"APIM514PublisherTest1can be create without Context");
    }

    @Test(groups={"wso2.am"}, description="Create an API Through the Publisher Rest API without proving version")
    public void testCreateAnAPIThroughThePublisherRestWithoutVersion() throws Exception {
        String apiContextTest = "apim514PublisherTestAPI2";
        String apiNameTest2 = "APIM514PublisherTest2";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiNameTest2, apiContextTest, "", this.apiProviderName, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        JSONObject apiResponse = new JSONObject(apiCreationResponse.getData());
        Assert.assertTrue((boolean)apiResponse.getBoolean("error"), (String)(apiNameTest2 + "can be create without Version"));
        Assert.assertTrue((boolean)apiResponse.getString("message").contains("Version not specified for API " + apiNameTest2), (String)(apiNameTest2 + "can be create without Version"));
    }

    @Test(groups={"wso2.am"}, description="Create an API Through the Publisher Rest API without proving tier availability")
    public void testCreateAnAPIThroughThePublisherRestWithoutTierAvailability() throws Exception {
        String apiContextTest = "apim514PublisherTestAPI3";
        String apiNameTest3 = "APIM514PublisherTest3";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiNameTest3, apiContextTest, "1.0.0", this.apiProviderName, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        apiCreationRequestBean.setTiersCollection("");
        apiCreationRequestBean.setTier("");
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        JSONObject apiResponse = new JSONObject(apiCreationResponse.getData());
        Assert.assertTrue((boolean)apiResponse.getBoolean("error"), (String)(apiNameTest3 + "can be create without Tier availability"));
        Assert.assertTrue((boolean)apiResponse.getString("message").contains("No tier defined for the API"), (String)(apiNameTest3 + "can be create without Tier availability"));
    }

    public void testCreateAnAPIThroughThePublisherRestWithoutEndpoint() throws Exception {
        String apiContextTest = "apim514PublisherTestAPI4";
        String apiNameTest4 = "APIM514PublisherTest4";
        URL url = null;
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiNameTest4, apiContextTest, "1.0.0", this.apiProviderName, url);
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        JSONObject apiResponse = new JSONObject(apiCreationResponse.getData());
        Assert.assertTrue((boolean)apiResponse.getBoolean("error"), (String)(apiNameTest4 + "can be create without Endpoint"));
        Assert.assertTrue((boolean)apiResponse.getString("message").contains("Endpoint Configuration is missing"), (String)(apiNameTest4 + "can be create without Endpoint"));
    }

    public void testCreateAnAPIThroughThePublisherRestWithoutResources() throws Exception {
        String apiContextTest = "apim514PublisherTestAPI5";
        String apiNameTest5 = "APIM514PublisherTest5";
        APIDesignBean designBean = new APIDesignBean(apiNameTest5, apiContextTest, "1.0.0", "This is Test API Created by API Manager Integration Test", this.apiTag);
        designBean.setSwagger("");
        HttpResponse apiCreationResponse = this.apiPublisher.designAPI(designBean);
        JSONObject apiResponse = new JSONObject(apiCreationResponse.getData());
        Assert.assertTrue((boolean)apiResponse.getBoolean("error"), (String)(apiNameTest5 + "can be create without Resources"));
        Assert.assertTrue((boolean)apiResponse.getString("message").contains("Invalid resource configuration "), (String)(apiNameTest5 + "can be create without Resources"));
    }

    @Test(groups={"wso2.am"}, description="Create an API Through the Publisher Rest API without proving Action")
    public void testCreateAnAPIThroughThePublisherRestWithoutAction() throws Exception {
        String apiContextTest = "apim514PublisherTestAPI6";
        String apiNameTest6 = "APIM514PublisherTest6";
        APICreationRequestBeanWithoutAction apiCreationRequestBean = new APICreationRequestBeanWithoutAction(apiNameTest6, apiContextTest, "1.0.0", this.apiProviderName, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setTags(this.apiTag);
        apiCreationRequestBean.setDescription("This is Test API Created by API Manager Integration Test");
        apiCreationRequestBean.setAction("");
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI((APICreationRequestBean)apiCreationRequestBean);
        JSONObject apiResponse = new JSONObject(apiCreationResponse.getData());
        Assert.assertTrue((boolean)apiResponse.getBoolean("error"), (String)(apiNameTest6 + "can be create without Action"));
        Assert.assertTrue((boolean)apiResponse.getString("message").contains(" is not supported"), (String)(apiNameTest6 + "can be create without Action"));
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.apiPublisher.deleteAPI("", "1.0.0", this.apiProviderName);
        this.apiPublisher.deleteAPI("APIM514PublisherTest5", "1.0.0", this.apiProviderName);
    }

    private class APICreationRequestBeanWithoutAction
    extends APICreationRequestBean {
        public APICreationRequestBeanWithoutAction(String apiName, String context, String version, String provider, URL endpointUrl) throws APIManagerIntegrationTestException {
            super(apiName, context, version, provider, endpointUrl);
        }

        public void setAction() {
            this.setAction("");
        }
    }
}

